/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Vector;

public class jongsDisplay
extends Canvas
implements Runnable {
    public static final int EFE_NOEFFECT = 2000;
    public static final int EFE_ZOOMIN = 2001;
    public static final int EFE_MOSAIC = 2002;
    public static final int EFE_FADEIN = 2003;
    public static final int EFE_WIPE = 2004;
    public static final int EFE_HASH = 2005;
    public static final int EFE_BOOK_LEFT = 2006;
    public static final int EFE_BOOK_RIGHT = 2007;
    static final long serialVersionUID = 0x100001L;
    BufferedImage disp_buf00 = null;
    BufferedImage disp_buf01 = null;
    BufferedImage disp_buf02 = null;
    Graphics gdb01;
    int width;
    int height;
    Font textFont;
    int fontCol1;
    int fontCol2;
    Color fontColor1;
    Color fontColor2;
    String text;
    Rectangle txtArea;
    boolean letterWriteMode;
    int letter_spacing;
    int line_height;
    int textWaittime;
    int textPosition;
    char presskey;
    int pressx;
    int pressy;
    int releasex;
    int releasey;
    int mouseX;
    int mouseY;
    Rectangle selectArea;
    int[] selectColor;
    Rectangle[] selectbtn;
    Font selectFont;
    Vector<String> selectTexts;
    String selectText;
    int buttonNum;
    int buttonT1st;
    int selectButton;
    int cellvalue;
    int pressed;
    int nowSelect;
    HashMap<String, int[]> transitionMap;
    int transCode;
    int commandCode;
    int transition_wtime;
    boolean busy;

    public jongsDisplay() {
        this.initJongsDisplay(800, 600);
    }

    public jongsDisplay(int n, int n2) {
        this.initJongsDisplay(n, n2);
    }

    public void initJongsDisplay(int n, int n2) {
        this.addKeyListener(this.getKeyListener());
        this.addMouseListener(this.getMouseListener());
        this.addMouseMotionListener(this.getMouseMotionListener());
        this.setBounds(n, n2);
        this.setTextFont(new Font("Selif", 0, 14));
        this.setFontColor(0xFFFFFF, 0xAAAAAA);
        this.setTextArea(n / 10, n2 / 10, n * 8 / 10, n2 * 8 / 10);
        this.text = "";
        this.letter_spacing = 3;
        this.line_height = 0;
        this.setSelectArea(50, n2 / 2, n - 100, 50);
        this.setSelectFont(new Font("Selif", 1, 8));
        this.setSelectColor(0xFFFFFF, 0xBBBBFF, 0xFFAAAA, 0);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.initTransitionCode();
        this.commandCode = 0;
        this.busy = false;
        this.mouseY = -1;
        this.mouseX = -1;
    }

    private MouseListener getMouseListener() {
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (jongsDisplay.this.commandCode == 1019) {
                    if (jongsDisplay.this.letterWriteMode) {
                        jongsDisplay.this.letterWriteMode = false;
                    } else {
                        jongsDisplay.this.presskey = (char)32;
                        jongsDisplay.this.commandCode = 0;
                    }
                }
                if (jongsDisplay.this.busy) {
                    return;
                }
                jongsDisplay.this.mouseX = jongsDisplay.this.calcPositionX(mouseEvent.getX());
                jongsDisplay.this.mouseY = jongsDisplay.this.calcPositionY(mouseEvent.getY());
                if (jongsDisplay.this.commandCode == 2020) {
                    jongsDisplay.this.selectButton = jongsDisplay.this.checkSelectButton(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.selectButton != -1) {
                        if (jongsDisplay.this.selectButton == jongsDisplay.this.pressed) {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.selectButton, 2);
                            jongsDisplay.this.selectText = jongsDisplay.this.selectTexts.get(jongsDisplay.this.buttonT1st + jongsDisplay.this.selectButton);
                            jongsDisplay.this.commandCode = 0;
                        } else {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.pressed, 0);
                            jongsDisplay.this.selectButton = -1;
                            jongsDisplay.this.pressed = -1;
                        }
                    } else {
                        jongsDisplay.this.nowSelect = jongsDisplay.this.pressed;
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.pressed, 1);
                        jongsDisplay.this.pressed = -1;
                    }
                    jongsDisplay.this.drawDisplay();
                } else if (jongsDisplay.this.commandCode == 2032) {
                    jongsDisplay.this.releasex = jongsDisplay.this.mouseX;
                    jongsDisplay.this.releasey = jongsDisplay.this.mouseY;
                    jongsDisplay.this.commandCode = 0;
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (jongsDisplay.this.busy) {
                    return;
                }
                jongsDisplay.this.mouseX = jongsDisplay.this.calcPositionX(mouseEvent.getX());
                jongsDisplay.this.mouseY = jongsDisplay.this.calcPositionY(mouseEvent.getY());
                if (jongsDisplay.this.commandCode == 2020) {
                    jongsDisplay.this.pressed = jongsDisplay.this.checkSelectButton(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.pressed != -1) {
                        if (jongsDisplay.this.nowSelect != -1) {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 0);
                        }
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.pressed, 2);
                        jongsDisplay.this.nowSelect = jongsDisplay.this.pressed;
                    }
                    jongsDisplay.this.drawDisplay();
                } else if (jongsDisplay.this.commandCode == 2032) {
                    jongsDisplay.this.pressx = jongsDisplay.this.mouseX;
                    jongsDisplay.this.pressy = jongsDisplay.this.mouseY;
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }
        };
        return mouseListener;
    }

    private KeyListener getKeyListener() {
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if ((jongsDisplay.this.commandCode == 1019 || jongsDisplay.this.commandCode == 2020) && keyEvent.getKeyCode() == 16) {
                    jongsDisplay.this.busy = false;
                    Graphics graphics = jongsDisplay.this.getGraphics();
                    graphics.drawImage(jongsDisplay.this.disp_buf01, 0, 0, jongsDisplay.this.getWidth(), jongsDisplay.this.getHeight(), null);
                    jongsDisplay.this.drawDisplay();
                    return;
                }
                if (jongsDisplay.this.busy) {
                    return;
                }
                if (jongsDisplay.this.commandCode == 2020) {
                    if (keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 40) {
                        if (jongsDisplay.this.nowSelect < 0) {
                            jongsDisplay.this.nowSelect = 0;
                        } else {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 0);
                            ++jongsDisplay.this.nowSelect;
                            if (jongsDisplay.this.nowSelect >= jongsDisplay.this.buttonNum) {
                                jongsDisplay.this.nowSelect = 0;
                            }
                        }
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 1);
                        jongsDisplay.this.pressed = -1;
                        jongsDisplay.this.selectButton = -1;
                        jongsDisplay.this.drawDisplay();
                    } else if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 38) {
                        if (jongsDisplay.this.nowSelect < 0) {
                            jongsDisplay.this.nowSelect = 0;
                        } else {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 0);
                            --jongsDisplay.this.nowSelect;
                            if (jongsDisplay.this.nowSelect < 0) {
                                jongsDisplay.this.nowSelect = jongsDisplay.this.buttonNum - 1;
                            }
                        }
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 1);
                        jongsDisplay.this.pressed = -1;
                        jongsDisplay.this.selectButton = -1;
                        jongsDisplay.this.drawDisplay();
                    } else if (keyEvent.getKeyCode() == 10) {
                        if (jongsDisplay.this.nowSelect < 0) {
                            jongsDisplay.this.nowSelect = 0;
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 1);
                            jongsDisplay.this.drawDisplay();
                        } else {
                            jongsDisplay.this.selectButton = jongsDisplay.this.nowSelect;
                            jongsDisplay.this.selectText = jongsDisplay.this.selectTexts.get(jongsDisplay.this.buttonT1st + jongsDisplay.this.selectButton);
                            jongsDisplay.this.commandCode = 0;
                            jongsDisplay.this.pressed = -1;
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.selectButton, 2);
                            jongsDisplay.this.drawDisplay();
                        }
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Graphics graphics;
                if (jongsDisplay.this.commandCode == 1019) {
                    if (jongsDisplay.this.letterWriteMode) {
                        jongsDisplay.this.letterWriteMode = false;
                    } else if (keyEvent.getKeyCode() == 16) {
                        if (!jongsDisplay.this.busy) {
                            jongsDisplay.this.busy = true;
                            graphics = jongsDisplay.this.getGraphics();
                            graphics.drawImage(jongsDisplay.this.disp_buf02, 0, 0, jongsDisplay.this.getWidth(), jongsDisplay.this.getHeight(), null);
                        }
                    } else {
                        jongsDisplay.this.presskey = keyEvent.getKeyChar();
                        jongsDisplay.this.commandCode = 0;
                    }
                }
                if (jongsDisplay.this.commandCode == 2020 && keyEvent.getKeyCode() == 16 && !jongsDisplay.this.busy) {
                    jongsDisplay.this.busy = true;
                    graphics = jongsDisplay.this.getGraphics();
                    graphics.drawImage(jongsDisplay.this.disp_buf02, 0, 0, jongsDisplay.this.getWidth(), jongsDisplay.this.getHeight(), null);
                }
            }
        };
        return keyListener;
    }

    private MouseMotionListener getMouseMotionListener() {
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (jongsDisplay.this.busy) {
                    return;
                }
                if (jongsDisplay.this.commandCode == 2020) {
                    int n;
                    jongsDisplay.this.mouseX = jongsDisplay.this.calcPositionX(mouseEvent.getX());
                    jongsDisplay.this.mouseY = jongsDisplay.this.calcPositionY(mouseEvent.getY());
                    if (jongsDisplay.this.selectArea.contains(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY) && (n = jongsDisplay.this.checkSelectButton(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY)) != -1) {
                        if (jongsDisplay.this.nowSelect != -1) {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 0);
                        }
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, n, 1);
                        jongsDisplay.this.nowSelect = n;
                        jongsDisplay.this.drawDisplay();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }
        };
        return mouseMotionListener;
    }

    private int calcPositionX(int n) {
        return n * this.width / this.getWidth();
    }

    private int calcPositionY(int n) {
        return n * this.height / this.getHeight();
    }

    private void initTransitionCode() {
        this.transitionMap = new HashMap();
        this.transitionMap.put("_noeffect", this.getIntArray(2000));
        this.transitionMap.put("_zoomin", this.getIntArray(2001));
        this.transitionMap.put("_mosaic", this.getIntArray(2002));
        this.transitionMap.put("_fadein", this.getIntArray(2003));
        this.transitionMap.put("_wipe", this.getIntArray(2004));
        this.transitionMap.put("_hash", this.getIntArray(2005));
        this.transitionMap.put("_bookleft", this.getIntArray(2006));
        this.transitionMap.put("_bookright", this.getIntArray(2007));
    }

    public int getTransitionCode(String string) {
        String string2 = string.trim().toLowerCase();
        if (this.transitionMap.containsKey(string2)) {
            return this.transitionMap.get(string2)[0];
        }
        return 0;
    }

    private int[] getIntArray(int n) {
        int[] nArray = new int[]{n};
        return nArray;
    }

    public void setBounds(int n, int n2) {
        this.setVisible(false);
        this.setBounds(0, 0, n, n2);
        this.disp_buf01 = new BufferedImage(n, n2, 4);
        this.gdb01 = this.disp_buf01.getGraphics();
        this.setVisible(true);
        this.setTextArea(10, 30, n - 20, n2 - 60);
    }

    public void setTextArea(int n, int n2, int n3, int n4) {
        this.txtArea = new Rectangle(n, n2, n3, n4);
    }

    public void setTextInterval(int n, int n2) {
        this.letter_spacing = n;
        this.line_height = n2;
    }

    public void setFontColor(int n, int n2) {
        this.fontColor1 = new Color(n);
        this.fontColor2 = new Color(n2);
        this.fontCol1 = n;
        this.fontCol2 = n2;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public void cellClick() {
        this.nowSelect = -1;
        this.pressed = -1;
        this.cellvalue = -1;
        this.commandCode = 2032;
    }

    public void selectClick() {
        this.commandCode = 2020;
        this.nowSelect = -1;
        this.pressed = -1;
        this.selectButton = -1;
        this.buttonsWrite();
    }

    public void buttonsWrite() {
        Graphics graphics = this.getGraphics();
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        this.textWrite(this.gdb01);
        this.drawSelectButtons(this.gdb01);
        graphics.drawImage(this.disp_buf01, 0, 0, this.getWidth(), this.getHeight(), this);
        graphics.dispose();
    }

    public void setSelectArea(int n, int n2, int n3, int n4) {
        this.selectArea = new Rectangle(n, n2, n3, n4);
    }

    public void setSelectArea(Rectangle rectangle) {
        this.selectArea = rectangle;
    }

    public void setSelectButton(Rectangle[] rectangleArray) {
        this.selectbtn = rectangleArray;
    }

    public void setSelectText(Vector<String> vector, int n, int n2) {
        this.selectTexts = vector;
        this.buttonT1st = n;
        this.buttonNum = n2;
    }

    public void setSelectFont(Font font) {
        this.selectFont = font;
    }

    public void setSelectColor(int n, int n2, int n3, int n4) {
        this.selectColor = new int[4];
        this.selectColor[0] = n;
        this.selectColor[1] = n2;
        this.selectColor[2] = n3;
        this.selectColor[3] = n4;
    }

    public void setSelectColor(int[] nArray) {
        this.selectColor = nArray;
    }

    public void drawSelectButtons(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.selectFont);
        if (this.commandCode == 2020) {
            if (this.selectbtn == null) {
                return;
            }
            for (int i = 0; i < this.buttonNum; ++i) {
                if (this.selectButton == i) {
                    this.drawSelectButton(graphics, i, 2, fontMetrics);
                    continue;
                }
                if (this.pressed == i) {
                    this.drawSelectButton(graphics, i, 2, fontMetrics);
                    continue;
                }
                if (this.nowSelect == i) {
                    this.drawSelectButton(graphics, i, 1, fontMetrics);
                    continue;
                }
                this.drawSelectButton(graphics, i, 0, fontMetrics);
            }
        }
    }

    public void drawSelectButton(Graphics graphics, int n, int n2) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.selectFont);
        this.drawSelectButton(graphics, n, n2, fontMetrics);
    }

    public void drawSelectButton(Graphics graphics, int n, int n2, FontMetrics fontMetrics) {
        boolean bl;
        int n3;
        if (n < 0 || n > this.buttonNum) {
            return;
        }
        Rectangle rectangle = this.selectbtn[n];
        String string = this.selectTexts.get(n + this.buttonT1st);
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        switch (n2) {
            case 0: {
                n3 = this.selectColor[0];
                bl = true;
                break;
            }
            case 1: {
                n3 = this.selectColor[1];
                bl = true;
                break;
            }
            case 2: {
                n3 = this.selectColor[2];
                bl = false;
                break;
            }
            default: {
                return;
            }
        }
        graphics.setColor(new Color(n3));
        graphics.fill3DRect(n4, n5, n6, n7, bl);
        graphics.draw3DRect(n4 + 1, n5 + 1, n6 - 2, n7 - 2, bl);
        graphics.draw3DRect(n4 + 2, n5 + 2, n6 - 4, n7 - 4, bl);
        graphics.setColor(new Color(this.selectColor[3]));
        int n8 = fontMetrics.getHeight();
        int n9 = n5 + n8 + (n7 - n8) / 2;
        int n10 = fontMetrics.stringWidth(string);
        int n11 = n4 + (n6 - n10) / 2;
        graphics.drawString(string, n11, n9);
    }

    public int checkSelectButton(int n, int n2) {
        for (int i = 0; i < this.buttonNum; ++i) {
            if (this.selectbtn[i] == null || !this.selectbtn[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public void drawText(String string) {
        if (string.charAt(0) == '+') {
            this.textPosition = this.text.length();
            this.text = this.text + string.substring(1);
        } else {
            this.textPosition = 0;
            this.text = string;
        }
        this.commandCode = 1019;
        this.drawText();
    }

    public void drawWaitText(String string, int n) {
        if (string.charAt(0) == '+') {
            this.textPosition = this.text.length();
            this.text = this.text + string.substring(1);
        } else {
            this.textPosition = 0;
            this.text = string;
        }
        this.textWaittime = n;
        this.commandCode = 1020;
        this.drawText();
        this.waitMiliSec(this.textWaittime);
        this.commandCode = 0;
    }

    public void clearText() {
        this.text = "";
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        this.commandCode = 0;
    }

    public void drawText() {
        this.busy = true;
        VolatileImage volatileImage = this.createVolatileImage(this.width, this.height);
        Graphics2D graphics2D = (Graphics2D)volatileImage.getGraphics();
        Graphics graphics = this.getGraphics();
        if (this.textPosition == 0) {
            this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
            graphics2D.drawImage((Image)this.disp_buf00, 0, 0, this);
        } else {
            graphics2D.drawImage((Image)this.disp_buf01, 0, 0, this);
        }
        this.letterWriteMode = true;
        this.textLetterWrite(graphics, graphics2D, volatileImage);
        this.letterWriteMode = false;
        graphics2D.dispose();
        volatileImage.flush();
        this.textWrite(this.gdb01);
        graphics.drawImage(this.disp_buf01, 0, 0, this.getWidth(), this.getHeight(), this);
        this.busy = false;
    }

    public void textWrite(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.text + " ";
        graphics2D.setFont(this.textFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.textFont);
        int n2 = fontMetrics.getHeight() + this.line_height;
        int n3 = this.txtArea.x;
        int n4 = this.txtArea.y;
        int n5 = this.txtArea.width;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n6 = 1;
        int n7 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (this.calcStringWidth(string, n7, i + 1, fontMetrics) <= n5 && (string.charAt(i) != '\\' || string.charAt(i + 1) != 'n')) continue;
            n = n6 * n2;
            if (i >= this.textPosition) {
                this.drawTextString(graphics2D, string.substring(n7, i), n3, n4 + n, fontMetrics);
            }
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'n') {
                i = n7 = i + 2;
            } else {
                n7 = i;
            }
            ++n6;
        }
        n = n6 * n2;
        this.drawTextString(graphics2D, string.substring(n7), n3, n4 + n, fontMetrics);
    }

    public void textLetterWrite(Graphics graphics, Graphics2D graphics2D, VolatileImage volatileImage) {
        int n;
        String string = this.text + " ";
        graphics2D.setFont(this.textFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.textFont);
        int n2 = fontMetrics.getHeight() + this.line_height;
        int n3 = this.txtArea.x;
        int n4 = this.txtArea.y;
        int n5 = this.txtArea.width;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n6 = 1;
        int n7 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (this.calcStringWidth(string, n7, i + 1, fontMetrics) <= n5 && (string.charAt(i) != '\\' || string.charAt(i + 1) != 'n')) continue;
            n = n6 * n2;
            if (i >= this.textPosition) {
                this.drawTextString(graphics, graphics2D, volatileImage, string.substring(n7, i), n3, n4 + n, fontMetrics, 10);
            }
            if (!this.letterWriteMode) {
                return;
            }
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'n') {
                i = n7 = i + 2;
            } else {
                n7 = i;
            }
            ++n6;
        }
        n = n6 * n2;
        this.drawTextString(graphics, graphics2D, volatileImage, string.substring(n7), n3, n4 + n, fontMetrics, 20);
    }

    private int calcStringWidth(String string, int n, int n2, FontMetrics fontMetrics) {
        return fontMetrics.stringWidth(string.substring(n, n2)) + this.letter_spacing * (n2 - n);
    }

    private void drawTextString(Graphics graphics, Graphics2D graphics2D, VolatileImage volatileImage, String string, int n, int n2, FontMetrics fontMetrics, int n3) {
        for (int i = 0; i < string.length(); ++i) {
            int n4 = n + this.calcStringWidth(string, 0, i, fontMetrics);
            String string2 = string.substring(i, i + 1);
            graphics2D.setColor(this.fontColor2);
            graphics2D.drawString(string2, n4 - 1, n2 - 1);
            graphics2D.drawString(string2, n4 + 1, n2 + 1);
            graphics2D.drawString(string2, n4 - 1, n2 + 1);
            graphics2D.drawString(string2, n4 + 1, n2 - 1);
            graphics2D.setColor(this.fontColor1);
            graphics2D.drawString(string2, n4, n2);
            graphics.drawImage(volatileImage, 0, 0, this.getWidth(), this.getHeight(), this);
            if (!this.letterWriteMode) {
                return;
            }
            this.waitMiliSec(n3);
        }
    }

    private void drawTextString(Graphics2D graphics2D, String string, int n, int n2, FontMetrics fontMetrics) {
        for (int i = 0; i < string.length(); ++i) {
            int n3 = n + this.calcStringWidth(string, 0, i, fontMetrics);
            String string2 = string.substring(i, i + 1);
            graphics2D.setColor(this.fontColor2);
            graphics2D.drawString(string2, n3 - 1, n2 - 1);
            graphics2D.drawString(string2, n3 + 1, n2 + 1);
            graphics2D.drawString(string2, n3 - 1, n2 + 1);
            graphics2D.drawString(string2, n3 + 1, n2 - 1);
            graphics2D.setColor(this.fontColor1);
            graphics2D.drawString(string2, n3, n2);
        }
    }

    public void viewDisplay(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.commandCode = 2012;
        this.disp_buf00 = bufferedImage;
        this.disp_buf02 = bufferedImage2;
        this.viewDisplay();
        this.commandCode = 0;
    }

    public void transitionDisplay(BufferedImage bufferedImage, BufferedImage bufferedImage2, String string) {
        this.commandCode = 2013;
        int n = this.getTransitionCode(string);
        if (n == 0) {
            this.viewDisplay(bufferedImage, bufferedImage2);
        } else {
            this.transitionDisplay(bufferedImage, bufferedImage2, n);
        }
    }

    public void transitionDisplay(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n) {
        this.commandCode = 2013;
        this.transCode = n;
        this.disp_buf00 = bufferedImage;
        this.disp_buf02 = bufferedImage2;
        this.transitionDisplay();
        this.commandCode = 0;
    }

    private void viewDisplay() {
        Graphics graphics = this.getGraphics();
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        graphics.drawImage(this.disp_buf00, 0, 0, this.getWidth(), this.getHeight(), this);
        graphics.dispose();
    }

    private void drawDisplay() {
        Graphics graphics = this.getGraphics();
        graphics.drawImage(this.disp_buf01, 0, 0, this.getWidth(), this.getHeight(), this);
        graphics.dispose();
    }

    public void transitionDisplay() {
        Graphics graphics = this.getGraphics();
        VolatileImage volatileImage = this.createVolatileImage(this.width, this.height);
        Graphics graphics2 = volatileImage.getGraphics();
        graphics2.drawImage(this.disp_buf01, 0, 0, this);
        VolatileImage volatileImage2 = this.createVolatileImage(this.width, this.height);
        graphics2 = volatileImage2.getGraphics();
        graphics2.drawImage(this.disp_buf00, 0, 0, this);
        graphics2.dispose();
        this.busy = true;
        switch (this.transCode) {
            case 2003: {
                this.transition_wtime = 20;
                this.EffectFadein(graphics, volatileImage, volatileImage2);
                break;
            }
            case 2005: {
                this.transition_wtime = 10;
                this.EffectHash(graphics, volatileImage, volatileImage2);
                break;
            }
            case 2002: {
                this.transition_wtime = 20;
                this.EffectMosaic(graphics, volatileImage, volatileImage2);
                break;
            }
            case 2004: {
                this.transition_wtime = 5;
                this.EffectWipe(graphics, volatileImage, volatileImage2, 50);
                break;
            }
            case 2001: {
                this.transition_wtime = 20;
                this.EffectZoomin(graphics, volatileImage, volatileImage2, 100);
                break;
            }
            case 2007: {
                this.transition_wtime = 5;
                this.EffectBook(graphics, volatileImage, volatileImage2, 0, 50);
                break;
            }
            case 2006: {
                this.transition_wtime = 5;
                this.EffectBook(graphics, volatileImage, volatileImage2, 1, 50);
                break;
            }
        }
        this.gdb01.drawImage(volatileImage2, 0, 0, this);
        graphics.drawImage(volatileImage2, 0, 0, this.getWidth(), this.getHeight(), this);
        graphics.dispose();
        volatileImage.flush();
        volatileImage2.flush();
        this.transCode = -1;
        this.busy = false;
    }

    private void EffectFadein(Graphics graphics, Image image, Image image2) {
        int n = this.width;
        int n2 = this.height;
        VolatileImage volatileImage = this.createVolatileImage(n, n2 * 2);
        Graphics graphics2 = volatileImage.getGraphics();
        VolatileImage volatileImage2 = this.createVolatileImage(n, n2);
        Graphics graphics3 = volatileImage2.getGraphics();
        graphics2.drawImage(image, 0, 0, n, n2, this);
        graphics2.drawImage(image2, 0, n2, n, n2, this);
        int n3 = 5;
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            for (n5 = i; n5 < n; n5 += n3) {
                graphics2.copyArea(n5, 0 + n2, 1, n2, 0, -n2);
            }
            graphics3.drawImage(volatileImage, 0, 0, n, n2 * 2, this);
            graphics.drawImage(volatileImage2, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
            for (n4 = n3 - 1 - i; n4 < n2; n4 += n3) {
                graphics2.copyArea(0, n4 + n2, n, 1, 0, -n2);
            }
            graphics3.drawImage(volatileImage, 0, 0, n, n2 * 2, this);
            graphics.drawImage(volatileImage2, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
            for (n5 = n3 - 1 - i; n5 < n; n5 += n3) {
                graphics2.copyArea(n5, 0 + n2, 1, n2, 0, -n2);
            }
            graphics3.drawImage(volatileImage, 0, 0, n, n2 * 2, this);
            graphics.drawImage(volatileImage2, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
            for (n4 = i; n4 < n2; n4 += n3) {
                graphics2.copyArea(0, n4 + n2, n, 1, 0, -n2);
            }
            graphics3.drawImage(volatileImage, 0, 0, n, n2 * 2, this);
            graphics.drawImage(volatileImage2, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
        }
        graphics.drawImage(image2, 0, 0, this.getWidth(), this.getHeight(), this);
        volatileImage2.flush();
    }

    private void EffectHash(Graphics graphics, Image image, Image image2) {
        int n = this.width;
        int n2 = this.height;
        int n3 = 20;
        int n4 = n / n3;
        int n5 = n3 + n4;
        VolatileImage volatileImage = this.createVolatileImage(n, n2 * 2);
        Graphics graphics2 = volatileImage.getGraphics();
        VolatileImage volatileImage2 = this.createVolatileImage(n, n2);
        Graphics graphics3 = volatileImage2.getGraphics();
        graphics2.drawImage(image, 0, 0, n, n2, this);
        graphics2.drawImage(image2, 0, n2, n, n2, this);
        graphics2.copyArea(0, n, 1, n2, 0, -n2);
        for (int i = 0; i < n5; ++i) {
            int n6 = 0;
            int n7 = i;
            while (n6 < i) {
                int n8 = n4 * (i - n7) + n7;
                graphics2.copyArea(n8, n2, 1, n2, 0, -n2);
                ++n6;
                --n7;
            }
            graphics3.drawImage(volatileImage, 0, 0, this);
            graphics.drawImage(volatileImage2, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
        }
        volatileImage.flush();
        graphics2.dispose();
        volatileImage2.flush();
        graphics3.dispose();
        graphics.drawImage(image2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void EffectMosaic(Graphics graphics, Image image, Image image2) {
        Graphics graphics2;
        VolatileImage volatileImage;
        int n;
        int n2;
        int n3;
        int n4 = this.width;
        int n5 = this.height;
        for (n3 = 2; n3 <= 64; n3 *= 2) {
            n2 = n4 / n3;
            n = n4 / n3;
            volatileImage = this.createVolatileImage(n2, n);
            graphics2 = volatileImage.getGraphics();
            graphics2.drawImage(image, 0, 0, n2, n, this);
            graphics.drawImage(volatileImage, 0, 0, this.getWidth(), this.getHeight(), this);
            volatileImage.flush();
            graphics2.dispose();
            this.waitMiliSec(this.transition_wtime);
        }
        for (n3 = 64; n3 > 1; n3 /= 2) {
            n2 = n4 / n3;
            n = n5 / n3;
            volatileImage = this.createVolatileImage(n2, n);
            graphics2 = volatileImage.getGraphics();
            graphics2.drawImage(image2, 0, 0, n2, n, this);
            graphics.drawImage(volatileImage, 0, 0, this.getWidth(), this.getHeight(), this);
            volatileImage.flush();
            graphics2.dispose();
            this.waitMiliSec(this.transition_wtime);
        }
        graphics.drawImage(image2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void EffectWipe(Graphics graphics, Image image, Image image2, int n) {
        int n2 = this.width;
        int n3 = this.height;
        VolatileImage volatileImage = this.createVolatileImage(n2, n3);
        Graphics graphics2 = volatileImage.getGraphics();
        int n4 = n2 / n;
        Image image3 = this.createImage(n2, n3);
        Graphics graphics3 = image3.getGraphics();
        graphics3.drawImage(image, 0, 0, this);
        for (int i = 0; i < n2; i += n4) {
            graphics2.drawImage(image2, 0, 0, this);
            graphics2.drawImage(image3, i, 0, this);
            graphics.drawImage(volatileImage, 0, 0, this.getWidth(), this.getHeight(), this);
            graphics3.copyArea(n4, 0, n2 - i, n3, -n4, 0);
            this.waitMiliSec(this.transition_wtime);
        }
        volatileImage.flush();
        graphics2.dispose();
        graphics.drawImage(image2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void EffectZoomin(Graphics graphics, Image image, Image image2, int n) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        for (int i = 0; i < n; i += i / 10 + 1) {
            int n4 = n2 * i / n;
            int n5 = n3 * i / n;
            int n6 = (n2 - n4) / 2;
            int n7 = (n3 - n5) / 2;
            graphics.drawImage(image2, n6, n7, n4, n5, this);
            this.waitMiliSec(this.transition_wtime);
        }
        graphics.drawImage(image2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void EffectBook(Graphics graphics, Image image, Image image2, int n, int n2) {
        int n3 = this.width;
        int n4 = this.height;
        int n5 = n3 / 2;
        int n6 = n3 / n2;
        VolatileImage volatileImage = this.createVolatileImage(n3, n4);
        Graphics graphics2 = volatileImage.getGraphics();
        VolatileImage volatileImage2 = this.createVolatileImage(n5, n4);
        Graphics graphics3 = volatileImage2.getGraphics();
        graphics3.drawImage(image, 0, 0, this);
        VolatileImage volatileImage3 = this.createVolatileImage(n5, n4);
        graphics3 = volatileImage3.getGraphics();
        graphics3.drawImage(image, -n5, 0, this);
        VolatileImage volatileImage4 = this.createVolatileImage(n5, n4);
        graphics3 = volatileImage4.getGraphics();
        graphics3.drawImage(image2, 0, 0, this);
        VolatileImage volatileImage5 = this.createVolatileImage(n5, n4);
        graphics3 = volatileImage5.getGraphics();
        graphics3.drawImage(image2, -n5, 0, this);
        graphics3.dispose();
        if (n == 0) {
            int n7;
            for (n7 = 0; n7 < n5; n7 += n6) {
                graphics2.drawImage(volatileImage2, 0, 0, this);
                graphics2.drawImage(volatileImage5, n5, 0, this);
                graphics2.drawImage(volatileImage3, n5, 0, n5 - n7, n4, this);
                graphics.drawImage(volatileImage, 0, 0, this.getWidth(), this.getHeight(), this);
                this.waitMiliSec(this.transition_wtime);
            }
            for (n7 = 0; n7 < n5; n7 += n6) {
                graphics2.drawImage(volatileImage2, 0, 0, this);
                graphics2.drawImage(volatileImage5, n5, 0, this);
                graphics2.drawImage(volatileImage4, n5 - n7, 0, n7, n4, this);
                graphics.drawImage(volatileImage, 0, 0, this.getWidth(), this.getHeight(), this);
                this.waitMiliSec(this.transition_wtime);
            }
        } else {
            int n8;
            for (n8 = n5; n8 > 0; n8 -= n6) {
                graphics2.drawImage(volatileImage4, 0, 0, this);
                graphics2.drawImage(volatileImage3, n5, 0, this);
                graphics2.drawImage(volatileImage2, n5 - n8, 0, n8, n4, this);
                graphics.drawImage(volatileImage, 0, 0, this.getWidth(), this.getHeight(), this);
                this.waitMiliSec(this.transition_wtime);
            }
            for (n8 = n5; n8 > 0; n8 -= n6) {
                graphics2.drawImage(volatileImage4, 0, 0, this);
                graphics2.drawImage(volatileImage3, n5, 0, this);
                graphics2.drawImage(volatileImage5, n5, 0, n5 - n8, n4, this);
                graphics.drawImage(volatileImage, 0, 0, this.getWidth(), this.getHeight(), this);
                this.waitMiliSec(this.transition_wtime);
            }
        }
        volatileImage2.flush();
        volatileImage4.flush();
        volatileImage3.flush();
        volatileImage5.flush();
        volatileImage.flush();
        graphics2.dispose();
        graphics.drawImage(image2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    @Override
    public void run() {
        this.waitMiliSec(100);
    }

    public void waitMiliSec(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public void update(Graphics graphics) {
        if (this.busy) {
            return;
        }
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.drawImage(this.disp_buf01, 0, 0, this.getWidth(), this.getHeight(), this);
    }
}

