/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import jongs.jongsDisplayManagement;
import jongs.jongsSound;

public class JongScripter
extends Thread {
    public static final int LGK_and = 1;
    public static final int LGK_or = 2;
    public static final int TYPE_int = 100;
    public static final int TYPE_str = 200;
    public static final int CMD_if = 1001;
    public static final int CMD_else = 1002;
    public static final int CMD_while = 1003;
    public static final int CMD_for = 1004;
    public static final int CMD_goto = 1005;
    public static final int CMD_gosub = 1006;
    public static final int CMD_goScript = 1007;
    public static final int CMD_return = 1008;
    public static final int CMD_begin = 1009;
    public static final int CMD_end = 1010;
    public static final int CMD_set = 1011;
    public static final int CMD_exit = 1012;
    public static final int CMD_input = 1013;
    public static final int CMD_switch = 1014;
    public static final int CMD_case = 1015;
    public static final int CMD_label = 1016;
    public static final int CMD_break = 1017;
    public static final int CMD_continue = 1018;
    public static final int CMD_text = 1019;
    public static final int CMD_WaitText = 1020;
    public static final int CMD_print = 1021;
    public static final int CMD_setCellNumber = 2001;
    public static final int CMD_setCellImage = 2002;
    public static final int CMD_setCellPosition = 2003;
    public static final int CMD_setCellSize = 2004;
    public static final int CMD_setCellTransColor = 2005;
    public static final int CMD_setCellFlag = 2006;
    public static final int CMD_setCellCanvas = 2007;
    public static final int CMD_setCellTextParam = 2008;
    public static final int CMD_setCellText = 2009;
    public static final int CMD_setShiftView = 2010;
    public static final int CMD_setShiftHide = 2011;
    public static final int CMD_viewDisplay = 2012;
    public static final int CMD_transitionDisplay = 2013;
    public static final int CMD_setDisplaySize = 2014;
    public static final int CMD_wait = 2015;
    public static final int CMD_setFontColor = 2016;
    public static final int CMD_setFont = 2017;
    public static final int CMD_setTextArea = 2018;
    public static final int CMD_setTextInterval = 2019;
    public static final int CMD_select = 2020;
    public static final int CMD_setSelectArea = 2021;
    public static final int CMD_setSelectColor = 2022;
    public static final int CMD_midiPlay = 2023;
    public static final int CMD_midiLoad = 2024;
    public static final int CMD_midiStop = 2025;
    public static final int CMD_audioPlay = 2026;
    public static final int CMD_audioLoop = 2027;
    public static final int CMD_audioStop = 2028;
    public static final int CMD_clipLoop = 2029;
    public static final int CMD_clipStop = 2030;
    public static final int CMD_setWaitTime = 2031;
    public static final int CMD_cellClick = 2032;
    public static final int CMD_debug = 2033;
    public static final int CMD_display = 2034;
    public static final int CMD_save = 2035;
    public static final int CMD_load = 2036;
    public static final int CMD_random = 2037;
    public static final int CMD_abs = 2038;
    Vector<Vector<String>> scriptParams;
    Vector<int[]> scriptCode;
    int scriptPointer;
    HashMap<String, int[]> typeMap;
    HashMap<String, int[]> basicMap;
    HashMap<String, int[]> cmdMap;
    HashMap<String, int[]> labelMap;
    HashMap<String, Object> varIntMap;
    HashMap<String, Object> varStrMap;
    Stack<int[]> parStack;
    Stack<int[]> subroutineStack;
    int th_wtime;
    int debug;
    String Text;
    BufferedReader bread = new BufferedReader(new InputStreamReader(System.in));
    String now_Line;
    jongsDisplayManagement dmng;
    jongsSound sound;

    public JongScripter() {
        super("JONGS");
        this.varIntMap = new HashMap();
        this.varStrMap = new HashMap();
        this.initBasicCode();
        this.initCommandCode();
        this.th_wtime = 0;
        this.debug = 0;
        this.Text = "";
        this.sound = new jongsSound();
    }

    private void initBasicCode() {
        this.typeMap = new HashMap();
        this.typeMap.put("int", this.getIntArray(100));
        this.typeMap.put("integer", this.getIntArray(100));
        this.typeMap.put("str", this.getIntArray(200));
        this.typeMap.put("string", this.getIntArray(200));
        this.basicMap = new HashMap();
        this.basicMap.put("if", this.getIntArray(1001));
        this.basicMap.put("else", this.getIntArray(1002));
        this.basicMap.put("while", this.getIntArray(1003));
        this.basicMap.put("for", this.getIntArray(1004));
        this.basicMap.put("goto", this.getIntArray(1005));
        this.basicMap.put("gosub", this.getIntArray(1006));
        this.basicMap.put("goscript", this.getIntArray(1007));
        this.basicMap.put("return", this.getIntArray(1008));
        this.basicMap.put("begin", this.getIntArray(1009));
        this.basicMap.put("end", this.getIntArray(1010));
        this.basicMap.put("set", this.getIntArray(1011));
        this.basicMap.put("exit", this.getIntArray(1012));
        this.basicMap.put("input", this.getIntArray(1013));
        this.basicMap.put("switch", this.getIntArray(1014));
        this.basicMap.put("case", this.getIntArray(1015));
        this.basicMap.put("label", this.getIntArray(1016));
        this.basicMap.put("break", this.getIntArray(1017));
        this.basicMap.put("continue", this.getIntArray(1018));
        this.basicMap.put("text", this.getIntArray(1019));
        this.basicMap.put("waittext", this.getIntArray(1020));
        this.basicMap.put("print", this.getIntArray(1021));
        this.basicMap.put("printf", this.getIntArray(1021));
    }

    private void initCommandCode() {
        this.cmdMap = new HashMap();
        this.cmdMap.put("setcellnumber", this.getIntArray(2001));
        this.cmdMap.put("setcellimage", this.getIntArray(2002));
        this.cmdMap.put("setcellposition", this.getIntArray(2003));
        this.cmdMap.put("setcellsize", this.getIntArray(2004));
        this.cmdMap.put("setcelltranscolor", this.getIntArray(2005));
        this.cmdMap.put("setcellflag", this.getIntArray(2006));
        this.cmdMap.put("setcellcanvas", this.getIntArray(2007));
        this.cmdMap.put("setcelltextparam", this.getIntArray(2008));
        this.cmdMap.put("setcelltext", this.getIntArray(2009));
        this.cmdMap.put("setshiftview", this.getIntArray(2010));
        this.cmdMap.put("setshifthide", this.getIntArray(2011));
        this.cmdMap.put("viewdisplay", this.getIntArray(2012));
        this.cmdMap.put("transitiondisplay", this.getIntArray(2013));
        this.cmdMap.put("showimage", this.getIntArray(2012));
        this.cmdMap.put("setdisplaysize", this.getIntArray(2014));
        this.cmdMap.put("wait", this.getIntArray(2015));
        this.cmdMap.put("setfontcolor", this.getIntArray(2016));
        this.cmdMap.put("settextfont", this.getIntArray(2017));
        this.cmdMap.put("setfont", this.getIntArray(2017));
        this.cmdMap.put("settextarea", this.getIntArray(2018));
        this.cmdMap.put("settextinterval", this.getIntArray(2019));
        this.cmdMap.put("select", this.getIntArray(2020));
        this.cmdMap.put("setselectarea", this.getIntArray(2021));
        this.cmdMap.put("setselectcolor", this.getIntArray(2022));
        this.cmdMap.put("midiload", this.getIntArray(2024));
        this.cmdMap.put("midiplay", this.getIntArray(2023));
        this.cmdMap.put("midistop", this.getIntArray(2025));
        this.cmdMap.put("audioloop", this.getIntArray(2027));
        this.cmdMap.put("audioplay", this.getIntArray(2026));
        this.cmdMap.put("audiostop", this.getIntArray(2028));
        this.cmdMap.put("soundloop", this.getIntArray(2027));
        this.cmdMap.put("soundplay", this.getIntArray(2026));
        this.cmdMap.put("soundstop", this.getIntArray(2028));
        this.cmdMap.put("cliploop", this.getIntArray(2029));
        this.cmdMap.put("clipstop", this.getIntArray(2030));
        this.cmdMap.put("setwaittime", this.getIntArray(2031));
        this.cmdMap.put("cellclick", this.getIntArray(2032));
        this.cmdMap.put("debug", this.getIntArray(2033));
        this.cmdMap.put("display", this.getIntArray(2034));
        this.cmdMap.put("save", this.getIntArray(2035));
        this.cmdMap.put("load", this.getIntArray(2036));
        this.cmdMap.put("random", this.getIntArray(2037));
        this.cmdMap.put("abs", this.getIntArray(2038));
    }

    public void getScript(String string, String string2) {
        Vector<String> vector;
        int n;
        int n2;
        int n3;
        this.scriptParams = new Vector();
        this.scriptCode = new Vector();
        this.scriptPointer = 0;
        this.labelMap = new HashMap();
        this.parStack = new Stack();
        this.subroutineStack = new Stack();
        try {
            String string3;
            FileInputStream fileInputStream = new FileInputStream("./" + string);
            System.out.println("JONGS GetScript:./" + string + ":CODE:" + string2);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                if ((string3 = string3.trim()).length() == 0) continue;
                this.setScriptOneLine(string3);
            }
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.Error(8, "\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb[" + string + "]\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
        }
        block6: for (n3 = 0; n3 < this.scriptCode.size(); ++n3) {
            n2 = this.scriptCode.get(n3)[0];
            switch (n2) {
                case 1001: 
                case 1002: 
                case 1003: 
                case 1004: {
                    n = n3 + 1;
                    if (n == this.scriptCode.size() || (n2 = this.scriptCode.get(n)[0]) == 1009) continue block6;
                    this.scriptCode.add(n3 + 2, this.getIntArray(1010));
                    vector = new Vector();
                    vector.add("end");
                    this.scriptParams.add(n3 + 2, vector);
                    this.scriptCode.add(n3 + 1, this.getIntArray(1009));
                    vector = new Vector();
                    vector.add("begin");
                    this.scriptParams.add(n3 + 1, vector);
                    continue block6;
                }
            }
        }
        for (n3 = 0; n3 < this.scriptCode.size(); ++n3) {
            String string4;
            n2 = this.scriptCode.get(n3)[0];
            if (n2 != 1016 || (string4 = (vector = this.scriptParams.get(n3)).get(1)).length() <= 0) continue;
            if (this.labelMap.containsKey(string4)) {
                this.Error(8, "\u30e9\u30d9\u30eb[" + string4 + "]\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
            }
            this.labelMap.put(string4, this.getIntArray(n3));
        }
        this.parStack.clear();
        for (n3 = 0; n3 < this.scriptCode.size(); ++n3) {
            n2 = this.scriptCode.get(n3)[0];
            if (n2 == 1009) {
                this.parStack.push(this.getIntArray(n3));
                continue;
            }
            if (n2 != 1010) continue;
            if (this.parStack.size() == 0) {
                this.Error(8, "\u30b9\u30af\u30ea\u30d7\u30c8\u306e\uff5b\uff5d\u306e\u5bfe\u5fdc\u304c\u3068\u308c\u3066\u3044\u307e\u305b\u3093\u3001\uff5d\u304c\u591a\u3044\u3088\u3046\u3067\u3059");
            }
            n = this.parStack.pop()[0];
            int n4 = n3;
            int n5 = n - 1;
            if (n5 < 0) {
                this.Error(8, "\uff5b\uff5d\u306e\u8a18\u8ff0\u4f4d\u7f6e\u304c\u4e0d\u6b63\u3067\u3059");
            }
            Vector<String> vector2 = this.scriptParams.get(n);
            vector2.add(Integer.toString(n4));
            Vector<String> vector3 = this.scriptParams.get(n4);
            vector3.add(Integer.toString(n));
            vector = this.scriptParams.get(n5);
            int n6 = this.scriptCode.get(n5)[0];
            vector2.add(vector.get(0));
            vector3.add(vector.get(0));
            if (n6 == 1003) {
                if (vector.size() < 2) {
                    this.Error(8, "WHILE\u6587\u306e\u69cb\u6587\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                vector3.add(vector.get(1));
                continue;
            }
            if (n6 != 1004) continue;
            if (vector.size() < 4) {
                this.Error(8, "FOR\u6587\u306e\u69cb\u6587\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            vector3.add(vector.get(2));
            vector3.add(vector.get(3));
        }
        if (this.parStack.size() > 0) {
            this.scriptPointer = this.parStack.pop()[0];
            this.Error(8, "\u30b9\u30af\u30ea\u30d7\u30c8\u306e\uff5b\uff5d\u306e\u5bfe\u5fdc\u304c\u3068\u308c\u3066\u3044\u307e\u305b\u3093\u3002}\u304c\u4e0d\u8db3\u3067\u3059");
        }
    }

    private void setScriptOneLine(String string) {
        int n;
        String string2;
        int n2;
        int n3;
        String string3;
        this.now_Line = string3 = string.trim();
        if (string3.length() == 0) {
            return;
        }
        int n4 = string3.indexOf("//");
        if (n4 >= 0) {
            string3 = string3.substring(0, n4);
            if ((string3 = string3.trim()).length() == 0) {
                return;
            }
        }
        if ((n4 = string3.indexOf(";")) >= 0) {
            string3 = string3.substring(0, n4);
            if ((string3 = string3.trim()).length() == 0) {
                return;
            }
        }
        if ((n3 = string3.indexOf(58)) > 0) {
            String string4 = string3.substring(0, n3).trim();
            n2 = string4.indexOf(32);
            if (n2 < 0) {
                n2 = string4.indexOf(9);
            }
            if (n2 > 0) {
                string2 = string4.substring(0, n2).toLowerCase();
                if (this.basicMap.get(string2)[0] == 1015) {
                    String string5 = string4.substring(n2).trim();
                    this.scriptCode.add(this.basicMap.get(string2));
                    this.scriptParams.add(this.getParams(string2 + "," + string5));
                    string3 = string3.substring(n3 + 1).trim();
                    if (string3.length() > 0) {
                        this.setScriptOneLine(string3);
                    }
                    return;
                }
                this.Error(16, "\u30e9\u30d9\u30eb\u306b\u7a7a\u767d\u3084TAB\u306e\u542b\u307e\u308c\u308b\u6587\u5b57\u3092\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093[" + string3 + "]");
            } else {
                String string6 = "label";
                String string7 = string3.substring(0, n3).trim();
                this.checkLabelName(string7);
                this.scriptCode.add(this.basicMap.get(string6));
                this.scriptParams.add(this.getParams(string6 + "," + string7));
                string3 = string3.substring(n3 + 1).trim();
                if (string3.length() > 0) {
                    this.setScriptOneLine(string3);
                }
                return;
            }
        }
        if (string3.charAt(0) == '{') {
            string2 = "begin";
            this.scriptCode.add(this.basicMap.get(string2));
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            this.scriptParams.add(vector);
            string3 = string3.substring(1).trim();
            if (string3.length() > 0) {
                this.setScriptOneLine(string3);
            }
            return;
        }
        if (string3.charAt(0) == '}') {
            string2 = "end";
            this.scriptCode.add(this.basicMap.get(string2));
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            this.scriptParams.add(vector);
            string3 = string3.substring(1).trim();
            if (string3.length() > 0) {
                this.setScriptOneLine(string3);
            }
            return;
        }
        n3 = string3.indexOf(32);
        if (n3 < 0) {
            n3 = string3.indexOf(9);
        }
        n2 = string3.indexOf(40);
        if (n3 > 0 && (n2 < 0 || n3 < n2)) {
            int[] nArray;
            string2 = string3.substring(0, n3).trim().toLowerCase();
            if (this.typeMap.containsKey(string2)) {
                String string8 = string3.substring(n3).trim();
                this.VarResist(string8, this.typeMap.get(string2)[0]);
                return;
            }
            if (this.basicMap.containsKey(string2) && (nArray = this.basicMap.get(string2))[0] == 1002) {
                this.scriptCode.add(nArray);
                this.scriptParams.add(this.getParams(string2));
                String string9 = string3.substring(n3).trim();
                if (string9.length() > 0) {
                    this.setScriptOneLine(string9);
                }
                return;
            }
        }
        if ((n = string3.indexOf(40)) > 0) {
            string2 = string3.substring(0, n).trim().toLowerCase();
            n2 = this.ParenthesesIndexOf(string3, n, '(', ')');
            String string10 = string3.substring(n + 1, n2);
            if (this.basicMap.containsKey(string2)) {
                String string11;
                this.scriptCode.add(this.basicMap.get(string2));
                this.scriptParams.add(this.getParams(string2 + "," + string10));
                if (n2 > 0 && n2 < string3.length() && (string11 = string3.substring(n2 + 1).trim()).length() > 0) {
                    this.setScriptOneLine(string11);
                }
                return;
            }
            if (this.cmdMap.containsKey(string2)) {
                this.scriptCode.add(this.cmdMap.get(string2));
                this.scriptParams.add(this.getParams(string2 + "," + string10));
                return;
            }
        } else {
            n = string3.indexOf(123);
            if (n < 0) {
                n = string3.length();
            }
            if (this.basicMap.containsKey(string2 = string3.substring(0, n).trim().toLowerCase())) {
                String string12;
                this.scriptCode.add(this.basicMap.get(string2));
                this.scriptParams.add(this.getParams(string2));
                if (n > 0 && n < string3.length() && (string12 = string3.substring(n).trim()).length() > 0) {
                    this.setScriptOneLine(string12);
                }
                return;
            }
        }
        if (this.isSubstitution(string3)) {
            string2 = "set";
            this.scriptCode.add(this.basicMap.get(string2));
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            vector.add(string3);
            this.scriptParams.add(vector);
        } else {
            string2 = "text";
            this.scriptCode.add(this.basicMap.get(string2));
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            vector.add(string3);
            this.scriptParams.add(vector);
        }
    }

    private void checkLabelName(String string) {
        String string2 = "!\"#$%&'()*+,-./:;<=>?[\\]^`{|}~";
        String string3 = string.trim();
        if (this.labelMap.containsKey(string3)) {
            this.Error(8, "\u30e9\u30d9\u30eb[" + string + "]\u306f\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
        }
        if (this.basicMap.containsKey(string3)) {
            this.Error(8, "\u30e9\u30d9\u30eb[" + string + "]\u306f\u4e88\u7d04\u8a9e\u3067\u3042\u308a\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.cmdMap.containsKey(string3)) {
            this.Error(8, "\u30e9\u30d9\u30eb[" + string + "]\u306f\u4e88\u7d04\u8a9e\u3067\u3042\u308a\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.typeMap.containsKey(string3)) {
            this.Error(8, "\u30e9\u30d9\u30eb[" + string + "]\u306f\u4e88\u7d04\u8a9e\u3067\u3042\u308a\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        for (int i = 0; i < string3.length(); ++i) {
            if (string2.indexOf(string3.charAt(i)) <= -1) continue;
            this.Error(8, "\u30e9\u30d9\u30eb\u306b\u4f7f\u7528\u3057\u3066\u306f\u306a\u3089\u306a\u3044\u6587\u5b57\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + string + "]");
        }
    }

    private void checkVariableName(String string) {
        String string2 = "!\"#$%&'()*+,-./:;<=>?[\\]^`{|}~";
        String string3 = string.trim();
        if (this.varIntMap.containsKey(string3)) {
            this.Error(8, "\u5909\u6570\u540d[" + string3 + "]\u306f\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
        }
        if (this.varStrMap.containsKey(string3)) {
            this.Error(8, "\u5909\u6570\u540d[" + string3 + "]\u306f\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
        }
        if (this.basicMap.containsKey(string3)) {
            this.Error(8, "\u5909\u6570\u540d[" + string3 + "]\u306f\u4e88\u7d04\u8a9e\u3067\u3042\u308a\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.cmdMap.containsKey(string3)) {
            this.Error(8, "\u5909\u6570\u540d[" + string3 + "]\u306f\u4e88\u7d04\u8a9e\u3067\u3042\u308a\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.typeMap.containsKey(string3)) {
            this.Error(8, "\u5909\u6570\u540d[" + string3 + "]\u306f\u4e88\u7d04\u8a9e\u3067\u3042\u308a\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if ('0' <= string3.charAt(0) && string3.charAt(0) <= '9') {
            this.Error(8, "\u5909\u6570\u540d\u306e\u5148\u982d\u306b\u534a\u89d2\u6570\u5b57\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + string3 + "]");
        }
        for (int i = 0; i < string3.length(); ++i) {
            if (string2.indexOf(string3.charAt(i)) <= -1) continue;
            this.Error(8, "\u5909\u6570\u540d\u306b\u4f7f\u7528\u3057\u3066\u306f\u306a\u3089\u306a\u3044\u6587\u5b57\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + string3 + "]");
        }
    }

    private boolean isSubstitution(String string) {
        int n = string.indexOf(61);
        if (n > 0) {
            String string2;
            int n2 = string.indexOf(91);
            if (n2 > 0 && n2 < n) {
                n = n2;
            }
            if (this.varIntMap.containsKey(string2 = string.substring(0, n).trim())) {
                return true;
            }
            if (this.varStrMap.containsKey(string2)) {
                return true;
            }
        }
        return false;
    }

    private void VarResist(String string, int n) {
        Vector<String> vector = this.getParams(string);
        block10: for (int i = 0; i < vector.size(); ++i) {
            String string2;
            String string3 = string2 = vector.get(i);
            int n2 = 0;
            if (string2.indexOf(91) > 0) {
                int n3 = string2.indexOf(91);
                string3 = string2.substring(0, n3).trim();
                int n4 = this.ParenthesesIndexOf(string2, n3, '[', ']');
                String string4 = string2.substring(n3 + 1, n4);
                n2 = this.Calc(string4);
            }
            this.checkVariableName(string3);
            switch (n) {
                case 100: {
                    Object[] objectArray;
                    switch (n2) {
                        case 0: {
                            objectArray = new int[1];
                            this.varIntMap.put(string3, objectArray);
                            continue block10;
                        }
                    }
                    Object[] objectArray2 = new int[n2];
                    this.varIntMap.put(string3, objectArray2);
                    continue block10;
                }
                case 200: {
                    Object[] objectArray;
                    switch (n2) {
                        case 0: {
                            objectArray = new String[1];
                            this.varStrMap.put(string3, objectArray);
                            continue block10;
                        }
                    }
                    Object[] objectArray2 = new String[n2];
                    this.varStrMap.put(string3, objectArray2);
                }
            }
        }
    }

    public Vector<String> getArrayMatrixParams(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(91);
        if (n < 0) {
            vector.add(string.trim());
            return vector;
        }
        String string2 = string.substring(0, n).trim();
        vector.add(string2);
        while (n > 0) {
            int n2 = this.ParenthesesIndexOf(string, n, '[', ']');
            if (n2 == -1) {
                this.Error(8, "[]\u306e\u5bfe\u5fdc\u304c\u3068\u308c\u3066\u3044\u307e\u305b\u3093[" + string + "]");
            }
            string2 = string.substring(n + 1, n2);
            vector.add(string2);
            n = string.indexOf(91, n2);
        }
        return vector;
    }

    private Vector<String> getParams(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.countTokens() > 0) {
            vector.add(stringTokenizer.nextToken().trim());
        }
        return vector;
    }

    private Vector<String> stringToVector(String string, String string2) {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = string2.length();
        int n3 = 0;
        while ((n = string.indexOf(string2, n3)) >= 0) {
            vector.add(string.substring(n3, n));
            n3 = n + n2;
        }
        vector.add(string.substring(n3));
        return vector;
    }

    public void outScriptState() {
        int n;
        System.err.println("----------------------------");
        System.err.println("----- JONG Script State-----");
        System.err.println("----------------------------");
        System.err.println("\u2605\u57fa\u672c\u578b\u2605");
        Object[] objectArray = this.typeMap.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            System.err.print("KEY:" + objectArray[n]);
            System.err.println(" CODE:" + this.typeMap.get(objectArray[n])[0]);
        }
        System.err.println();
        System.err.println("\u2605\u57fa\u672c\u30b3\u30de\u30f3\u30c9\u2605");
        objectArray = this.basicMap.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            System.err.print("KEY:" + objectArray[n]);
            System.err.println(" CODE:" + this.basicMap.get(objectArray[n])[0]);
        }
        System.err.println();
        System.err.println("\u2605\u767b\u9332\u30b3\u30de\u30f3\u30c9\u2605");
        objectArray = this.cmdMap.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            System.err.print("KEY:" + objectArray[n]);
            System.err.println(" CODE:" + this.cmdMap.get(objectArray[n])[0]);
        }
        System.err.println();
        System.err.println("\u2605\u30e9\u30d9\u30eb\u2605");
        objectArray = this.labelMap.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            System.err.print("KEY:" + objectArray[n]);
            System.err.println(" CODE:" + this.labelMap.get(objectArray[n])[0]);
        }
        System.err.println();
        System.err.println("\u2605\u30b9\u30af\u30ea\u30d7\u30c8\u2605");
        for (n = 0; n < this.scriptCode.size(); ++n) {
            int[] nArray = this.scriptCode.get(n);
            Vector<String> vector = this.scriptParams.get(n);
            String string = "0000" + nArray[0];
            String string2 = "000" + n;
            System.err.print(string2.substring(string2.length() - 3));
            System.err.print(" Cmd:" + string.substring(string.length() - 4));
            System.err.println(" Param[" + vector.size() + "]" + vector.toString());
        }
    }

    private void setVariable(String string) {
        int n = string.indexOf(61);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1).trim();
        if (this.isIntVar(string2)) {
            this.setVarIntValue(string2, this.Calc(string3));
        } else if (this.isStrVar(string2)) {
            this.setVarStrValue(string2, this.getStrValue(string3));
        }
    }

    private int getIntValue(String string) {
        String string2 = string.trim();
        if (this.isIntVar(string2)) {
            return this.getVarIntValue(string2);
        }
        int n = this.strToInt(string2);
        if (n != 0) {
            return n;
        }
        if (string2.charAt(0) != '0') {
            this.Error(8, "[" + string2 + "]\u3068\u3044\u3046\u6570\u5024\u578b\u306e\u5909\u6570\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return 0;
    }

    private String getStrValue(String string) {
        String string2 = string.trim();
        char c = string2.charAt(0);
        if (c == '+') {
            string2 = string2.substring(1);
        }
        if (this.isStrVar(string2)) {
            string2 = this.getVarStrValue(string2);
        } else if (this.isIntVar(string2)) {
            string2 = "" + this.getVarIntValue(string2);
        } else if (string2.indexOf(43) >= 0) {
            string2 = this.strToStr(string2);
        } else if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (c == '+') {
            string2 = "+" + string2;
        }
        return string2;
    }

    private String strToStr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"+", false);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (this.isIntVar(string3)) {
                string2 = string2 + this.getIntValue(string3);
                continue;
            }
            if (this.isStrVar(string3)) {
                string2 = string2 + this.getVarStrValue(string3);
                continue;
            }
            string2 = string2 + string3;
        }
        return string2;
    }

    private int strToInt(String string) {
        int n = 0;
        if (string.length() == 0) {
            return 0;
        }
        String string2 = string.charAt(0) == '-' || string.charAt(0) == '+' ? string.substring(1) : string;
        try {
            n = string2.length() > 2 && string2.charAt(0) == '0' && string2.charAt(1) == 'x' ? Integer.parseInt(string2.substring(2), 16) : (string2.charAt(0) >= '0' && string2.charAt(0) <= '9' ? Integer.parseInt(string2, 10) : 0);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        if (string.charAt(0) == '-') {
            n = -n;
        }
        return n;
    }

    private int getVarIntValue(String string) {
        Vector<String> vector = this.getArrayMatrixParams(string);
        int[] nArray = (int[])this.varIntMap.get(vector.get(0).trim());
        if (nArray == null) {
            this.Error(8, "\u5909\u6570" + vector.get(0).trim() + "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        if (vector.size() == 1) {
            return nArray[0];
        }
        int n = this.Calc(vector.get(1));
        return nArray[n];
    }

    private String getVarStrValue(String string) {
        Vector<String> vector = this.getArrayMatrixParams(string);
        String[] stringArray = (String[])this.varStrMap.get(vector.get(0).trim());
        if (stringArray == null) {
            this.Error(8, "\u5909\u6570" + vector.get(0).trim() + "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        if (vector.size() == 1) {
            return stringArray[0];
        }
        int n = this.getIntValue(vector.get(1));
        return stringArray[n];
    }

    private void setVarIntValue(String string, int n) {
        Vector<String> vector = this.getArrayMatrixParams(string);
        int[] nArray = (int[])this.varIntMap.get(vector.get(0).trim());
        if (vector.size() == 1) {
            nArray[0] = n;
        } else {
            int n2 = this.Calc(vector.get(1));
            if (n2 < nArray.length) {
                nArray[n2] = n;
            } else {
                this.Error(8, "\u5909\u6570" + string + "\u306e\u914d\u5217\u6dfb\u5b57\u3092\u30aa\u30fc\u30d0\u30fc" + n2 + "\u3057\u307e\u3057\u305f");
            }
        }
    }

    private void setVarStrValue(String string, String string2) {
        Vector<String> vector = this.getArrayMatrixParams(string);
        String[] stringArray = (String[])this.varStrMap.get(vector.get(0).trim());
        if (vector.size() == 1) {
            stringArray[0] = string2;
        } else {
            int n = this.Calc(vector.get(1));
            if (n < stringArray.length) {
                stringArray[n] = string2;
            } else {
                this.Error(8, "\u5909\u6570" + string + "\u306e\u914d\u5217\u6dfb\u5b57\u3092\u30aa\u30fc\u30d0\u30fc" + n + "\u3057\u307e\u3057\u305f");
            }
        }
    }

    private boolean isIntVar(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = string.indexOf(91);
        String string2 = n > 0 ? string.substring(0, n).trim() : string.trim();
        return this.varIntMap.containsKey(string2);
    }

    private boolean isStrVar(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = string.indexOf(91);
        String string2 = n > 0 ? string.substring(0, n).trim() : string.trim();
        return this.varStrMap.containsKey(string2);
    }

    public int Calc(String string) {
        int n = 0;
        n = string.indexOf(40) < 0 ? this.singleCalc(string) : this.parenthesesCalc(string);
        return n;
    }

    public int parenthesesCalc(String string) {
        int n;
        int n2 = 0;
        String string2 = string.trim();
        String string3 = "+-*/%";
        if (string2.charAt(0) == '-') {
            string2 = "0" + string.trim();
        }
        Vector<String> vector = new Vector<String>();
        String string4 = "";
        int n3 = 0;
        for (n = 0; n < string2.length(); ++n) {
            char c = string2.charAt(n);
            if (string3.indexOf(c) >= 0) {
                String string5 = string2.substring(n3, n).trim();
                if (string5.charAt(0) == '(') {
                    string5 = string5.substring(1, string5.length() - 1).trim();
                }
                vector.add(string5);
                n3 = n + 1;
                string4 = string4 + string2.substring(n, n3);
                continue;
            }
            if (c == '(') {
                n = this.ParenthesesIndexOf(string2, n, '(', ')');
                continue;
            }
            if (c != '[') continue;
            n = this.ParenthesesIndexOf(string2, n, '[', ']');
        }
        vector.add(string2.substring(n3, n).trim());
        Vector<int[]> vector2 = new Vector<int[]>();
        for (int i = 0; i < vector.size(); ++i) {
            int n4 = this.Calc((String)vector.get(i));
            vector2.add(this.getIntArray(n4));
        }
        n2 = this.vectorCalc(vector2, string4);
        return n2;
    }

    private int singleCalc(String string) {
        int n;
        int n2 = 0;
        String string2 = string.trim();
        String string3 = "+-*/%";
        if (string2.charAt(0) == '-') {
            string2 = "0" + string.trim();
        }
        Vector<String> vector = new Vector<String>();
        String string4 = "";
        int n3 = 0;
        for (n = 0; n < string2.length(); ++n) {
            char c = string2.charAt(n);
            if (string3.indexOf(c) >= 0) {
                vector.add(new String(string2.substring(n3, n)));
                n3 = n + 1;
                string4 = string4 + string2.substring(n, n3);
                continue;
            }
            if (c != '[') continue;
            n = this.ParenthesesIndexOf(string2, n, '[', ']');
        }
        vector.add(new String(string2.substring(n3, n).trim()));
        Vector<int[]> vector2 = new Vector<int[]>();
        for (int i = 0; i < vector.size(); ++i) {
            int n4 = this.getIntValue((String)vector.get(i));
            vector2.add(this.getIntArray(n4));
        }
        n2 = this.vectorCalc(vector2, string4);
        return n2;
    }

    private int vectorCalc(Vector<int[]> vector, String string) {
        int n;
        int n2;
        int n3;
        char c;
        int n4;
        char[] cArray = string.toCharArray();
        block10: for (n4 = 0; n4 < cArray.length; ++n4) {
            c = cArray[n4];
            switch (c) {
                case '*': {
                    n3 = vector.get(n4)[0];
                    n2 = vector.get(n4 + 1)[0];
                    int n5 = n = n3 * n2;
                    vector.get((int)(n4 + 1))[0] = n5;
                    vector.get((int)n4)[0] = n5;
                    cArray[n4] = 32;
                    continue block10;
                }
                case '/': {
                    n3 = vector.get(n4)[0];
                    n2 = vector.get(n4 + 1)[0];
                    int n6 = n = n3 / n2;
                    vector.get((int)(n4 + 1))[0] = n6;
                    vector.get((int)n4)[0] = n6;
                    cArray[n4] = 32;
                    continue block10;
                }
                case '%': {
                    n3 = vector.get(n4)[0];
                    n2 = vector.get(n4 + 1)[0];
                    int n7 = n = n3 % n2;
                    vector.get((int)(n4 + 1))[0] = n7;
                    vector.get((int)n4)[0] = n7;
                    cArray[n4] = 32;
                }
            }
        }
        for (n4 = cArray.length - 1; n4 >= 0; --n4) {
            if (cArray[n4] != ' ') continue;
            vector.get((int)n4)[0] = vector.get(n4 + 1)[0];
        }
        block12: for (n4 = 0; n4 < cArray.length; ++n4) {
            c = cArray[n4];
            switch (c) {
                case '+': {
                    n3 = vector.get(n4)[0];
                    n2 = vector.get(n4 + 1)[0];
                    int n8 = n = n3 + n2;
                    vector.get((int)(n4 + 1))[0] = n8;
                    vector.get((int)n4)[0] = n8;
                    cArray[n4] = 32;
                    continue block12;
                }
                case '-': {
                    n3 = vector.get(n4)[0];
                    n2 = vector.get(n4 + 1)[0];
                    int n9 = n = n3 - n2;
                    vector.get((int)(n4 + 1))[0] = n9;
                    vector.get((int)n4)[0] = n9;
                    cArray[n4] = 32;
                    continue block12;
                }
                case ' ': {
                    vector.get((int)(n4 + 1))[0] = vector.get(n4)[0];
                }
            }
        }
        int n10 = vector.get(vector.size() - 1)[0];
        return n10;
    }

    private boolean judge(String string) {
        boolean bl = false;
        bl = string.indexOf("&&") > 0 || string.indexOf("||") > 0 ? this.someJudge(string) : this.singleJudge(string);
        return bl;
    }

    private boolean someJudge(String string) {
        int n;
        String string2;
        int n2;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        block7: for (n2 = 0; n2 < string.length(); ++n2) {
            switch (string.charAt(n2)) {
                case '(': {
                    n2 = this.ParenthesesIndexOf(string, n2, '(', ')');
                    continue block7;
                }
                case '[': {
                    n2 = this.ParenthesesIndexOf(string, n2, '[', ']');
                    continue block7;
                }
                case '\"': {
                    n2 = this.ParenthesesIndexOf(string, n2, '\"', '\"');
                    continue block7;
                }
                case '&': {
                    if (string.charAt(n2 + 1) == '&') {
                        string2 = string.substring(n3, n2).trim();
                        if (string2.length() > 2 && string2.charAt(0) == '(' && string2.charAt(string2.length() - 1) == ')') {
                            string2 = string2.substring(1, string2.length() - 1).trim();
                        }
                        if (string2.length() > 0) {
                            vector.add(string2);
                            n3 = n2 += 2;
                        }
                    }
                    stringBuffer.append('&');
                    continue block7;
                }
                case '|': {
                    if (string.charAt(n2 + 1) == '|') {
                        string2 = string.substring(n3, n2).trim();
                        if (string2.length() > 2 && string2.charAt(0) == '(' && string2.charAt(string2.length() - 1) == ')') {
                            string2 = string2.substring(1, string2.length() - 1).trim();
                        }
                        if (string2.length() > 0) {
                            vector.add(string2);
                            n3 = n2 += 2;
                        }
                    }
                    stringBuffer.append('|');
                }
            }
        }
        string2 = string.substring(n3, n2).trim();
        if (string2.length() > 2 && string2.charAt(0) == '(' && string2.charAt(string2.length() - 1) == ')') {
            string2 = string2.substring(1, string2.length() - 1).trim();
        }
        if (string2.length() > 0) {
            vector.add(string2);
            n3 = n2 += 2;
        }
        char[] cArray = stringBuffer.toString().toCharArray();
        boolean[] blArray = new boolean[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            blArray[n] = this.judge((String)vector.get(n));
        }
        for (n = 0; n < cArray.length; ++n) {
            boolean bl;
            if (cArray[n] == '&') {
                boolean bl2 = bl = blArray[n] && blArray[n + 1];
                blArray[n + 1] = bl2;
                blArray[n] = bl2;
                continue;
            }
            if (cArray[n] != '|') continue;
            boolean bl3 = bl = blArray[n] && blArray[n + 1];
            blArray[n + 1] = bl3;
            blArray[n] = bl3;
        }
        boolean bl = blArray[cArray.length];
        return bl;
    }

    private boolean singleJudge(String string) {
        boolean bl = false;
        String string2 = string.trim().charAt(0) == '!' ? string.substring(1).trim() : string.trim();
        int n = 2;
        int n2 = string2.indexOf("==");
        int n3 = 0;
        if (n2 < 0) {
            n = 2;
            n2 = string2.indexOf("!=");
            n3 = 1;
        }
        if (n2 < 0) {
            n = 2;
            n2 = string2.indexOf("=!");
            n3 = 2;
        }
        if (n2 < 0) {
            n = 2;
            n2 = string2.indexOf("<=");
            n3 = 3;
        }
        if (n2 < 0) {
            n = 2;
            n2 = string2.indexOf("=<");
            n3 = 4;
        }
        if (n2 < 0) {
            n = 2;
            n2 = string2.indexOf(">=");
            n3 = 5;
        }
        if (n2 < 0) {
            n = 2;
            n2 = string2.indexOf("=>");
            n3 = 6;
        }
        if (n2 < 0) {
            n = 1;
            n2 = string2.indexOf("<");
            n3 = 7;
        }
        if (n2 < 0) {
            n = 1;
            n2 = string2.indexOf(">");
            n3 = 8;
        }
        if (n2 < 0) {
            this.Error(8, "\u6bd4\u8f03\u306e\u8a18\u8ff0\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        String string3 = string2.substring(0, n2).trim();
        String string4 = string2.substring(n2 + n).trim();
        if (this.isStrVar(string3) || this.isStrVar(string4)) {
            String string5 = this.getStrValue(string3);
            String string6 = this.getStrValue(string4);
            bl = n3 == 0 ? string5.equals(string6) : !string5.equals(string6);
        } else {
            int n4 = this.Calc(string3);
            int n5 = this.Calc(string4);
            switch (n3) {
                case 0: {
                    bl = n4 == n5;
                    break;
                }
                case 1: 
                case 2: {
                    bl = n4 != n5;
                    break;
                }
                case 3: 
                case 4: {
                    bl = n4 <= n5;
                    break;
                }
                case 5: 
                case 6: {
                    bl = n4 >= n5;
                    break;
                }
                case 7: {
                    bl = n4 < n5;
                    break;
                }
                case 8: {
                    boolean bl2 = bl = n4 > n5;
                }
            }
        }
        if (string.trim().charAt(0) == '!') {
            bl = !bl;
        }
        return bl;
    }

    private int[] getIntArray(int n) {
        int[] nArray = new int[]{n};
        return nArray;
    }

    private int ParenthesesIndexOf(String string, int n, char c, char c2) {
        int n2 = string.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) == c) {
                ++n3;
                continue;
            }
            if (string.charAt(i) != c2 || --n3 != 0) continue;
            return i;
        }
        this.Error(8, "\u62ec\u5f27\u306e\u5bfe\u5fdc\u304c\u3068\u308c\u3066\u3044\u307e\u305b\u3093\u3002(" + string + ")");
        return -1;
    }

    public String loadText(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string3;
            FileInputStream fileInputStream = new FileInputStream("./" + string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                string3 = string3.trim();
                stringBuffer.append(string3);
            }
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.Error(8, "\u30d5\u30a1\u30a4\u30eb[" + string + "]\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
        }
        return stringBuffer.toString();
    }

    public void saveText(String string, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("./" + string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string3);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.Error(8, "\u30d5\u30a1\u30a4\u30eb[" + string + "]\u3092\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093");
        }
    }

    public void saveVariable(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getStrValue((String)vector.get(1));
        int n = vector.size() - 2;
        for (int i = 0; i < n; ++i) {
            int n2;
            String string2;
            int n3;
            String string3 = (String)vector.get(i + 2);
            int n4 = string3.indexOf(91);
            if (n4 > 0) {
                int n5 = this.ParenthesesIndexOf(string3, n4, '[', ']');
                String string4 = string3.substring(n4 + 1, n5).trim();
                n3 = this.Calc(string4);
                string2 = string3.substring(0, n4);
            } else {
                n3 = -1;
                string2 = string3.trim();
            }
            if (this.isIntVar(string2)) {
                int[] nArray = (int[])this.varIntMap.get(string2);
                if (n3 >= 0) {
                    stringBuffer.append(nArray[n3]);
                    stringBuffer.append("\t");
                } else {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        stringBuffer.append(nArray[n2]);
                        stringBuffer.append('\t');
                    }
                }
            } else if (this.isStrVar(string2)) {
                String[] stringArray = (String[])this.varStrMap.get(string2);
                if (n3 >= 0) {
                    stringBuffer.append(stringArray[n3]);
                    stringBuffer.append('\t');
                } else {
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        stringBuffer.append(stringArray[n2]);
                        stringBuffer.append('\t');
                    }
                }
            } else {
                this.Error(8, string2 + "\u3068\u3044\u3046\u5909\u6570\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        this.saveText(string, stringBuffer.toString(), "EUC_JP");
    }

    public void loadVariable(Vector vector) {
        int n;
        String string = this.getStrValue((String)vector.get(1));
        String[] stringArray = new String[vector.size() - 2];
        int[] nArray = new int[vector.size() - 2];
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = (String)vector.get(n + 2);
            int n2 = string2.indexOf(91);
            if (n2 > 0) {
                int n3 = this.ParenthesesIndexOf(string2, n2, '[', ']');
                String string3 = string2.substring(n2 + 1, n3).trim();
                nArray[n] = this.Calc(string3);
                stringArray[n] = string2.substring(0, n2);
                continue;
            }
            nArray[n] = -1;
            stringArray[n] = string2.trim();
        }
        try {
            String string4;
            FileInputStream fileInputStream = new FileInputStream("./" + string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "EUC_JP");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            for (n = 0; (string4 = bufferedReader.readLine()) != null && n < stringArray.length; ++n) {
                int n4;
                Vector<String> vector2 = this.stringToVector(string4, "\t");
                String string5 = stringArray[n];
                int n5 = nArray[n];
                if (this.isIntVar(stringArray[n])) {
                    int[] nArray2 = (int[])this.varIntMap.get(string5);
                    if (n5 == -1) {
                        for (n4 = 0; n4 < nArray2.length && n4 < vector2.size(); ++n4) {
                            nArray2[n4] = Integer.parseInt(vector2.get(n4));
                        }
                        continue;
                    }
                    nArray2[n5] = Integer.parseInt(vector2.get(0));
                    continue;
                }
                if (this.isStrVar(stringArray[n])) {
                    String[] stringArray2 = (String[])this.varStrMap.get(string5);
                    if (n5 == -1) {
                        for (n4 = 0; n4 < stringArray2.length && n4 < vector2.size(); ++n4) {
                            stringArray2[n4] = vector2.get(n4);
                        }
                        continue;
                    }
                    stringArray2[n5] = vector2.get(0);
                    continue;
                }
                this.Error(8, string5 + "\u3068\u3044\u3046\u5909\u6570\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            }
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.Error(8, "\u30d5\u30a1\u30a4\u30eb[" + string + "]\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
        }
    }

    private void inputValue(String string) {
        String string2 = "";
        try {
            string2 = this.bread.readLine();
        }
        catch (IOException iOException) {
            this.Error(8, "\u30ad\u30fc\u5165\u529b\u306b\u5931\u6557");
        }
        if (this.isStrVar(string)) {
            this.setVarStrValue(string, string2);
        } else if (this.isIntVar(string)) {
            this.setVarIntValue(string, this.strToInt(string2));
        }
    }

    private void buttonSelect(Vector<String> vector) {
        Vector<String> vector2 = new Vector<String>();
        String string = new String(vector.get(1));
        for (int i = 2; i < vector.size(); ++i) {
            String string2 = vector.get(i);
            String string3 = this.strToStr(string2);
            vector2.add(string3);
        }
        this.dmng.setSelectParam(vector2);
        this.waitDisplayExec();
        if (this.isIntVar(string)) {
            this.setVarIntValue(string, this.dmng.getSelectButton());
        } else if (this.isStrVar(string)) {
            this.setVarStrValue(string, this.dmng.getSelectText());
        }
    }

    private void arrayButtonSelect(Vector<String> vector) {
        String string = new String(vector.get(1));
        this.dmng.setSelectParam(vector);
        this.waitDisplayExec();
        if (this.isIntVar(string)) {
            this.setVarIntValue(string, this.dmng.getSelectButton());
        } else if (this.isStrVar(string)) {
            this.setVarStrValue(string, this.dmng.getSelectText());
        }
    }

    private void cellClick(Vector<String> vector) {
        String string = vector.get(1);
        if (this.dmng.visibleCellNum() == 0) {
            this.setVarIntValue(string, -1);
            return;
        }
        this.dmng.cellClick();
        int n = -1;
        while (n == -1) {
            this.waitDisplayExec();
            n = this.dmng.getSelectCell();
        }
        this.setVarIntValue(string, n);
    }

    private void waitDisplayExec() {
        while (this.dmng.diaplayBusy()) {
            this.waitMiliSec(100);
        }
    }

    public void waitMiliSec(int n) {
        long l = n;
        try {
            JongScripter.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void drawText(String string, boolean bl, int n) {
        String string2 = string.trim();
        if (this.dmng == null) {
            this.Text = string2.charAt(0) == '+' ? string2 + string2.substring(1) : string2;
            System.out.println(this.Text);
        } else if (bl) {
            this.dmng.drawText(string2);
            this.waitDisplayExec();
        } else {
            this.dmng.drawWaitText(string2, n);
        }
    }

    private void oneLineExec() {
        int n = this.scriptCode.get(this.scriptPointer)[0];
        Vector<String> vector = this.scriptParams.get(this.scriptPointer);
        block0 : switch (n) {
            case 2034: {
                if (vector.size() == 3) {
                    int n2 = this.Calc(vector.get(1));
                    int n3 = this.Calc(vector.get(2));
                    this.dmng = new jongsDisplayManagement(n2, n3);
                } else {
                    this.dmng = new jongsDisplayManagement();
                }
                ++this.scriptPointer;
                break;
            }
            case 1005: {
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (this.labelMap.containsKey(this.getStrValue(vector.get(1)))) {
                    this.scriptPointer = this.labelMap.get(vector.get(1))[0];
                    break;
                }
                this.Error(8, this.getStrValue(vector.get(1)) + "\u3068\u3044\u3046\u30e9\u30d9\u30eb\u306f\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                break;
            }
            case 1006: {
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (this.labelMap.containsKey(this.getStrValue(vector.get(1)))) {
                    this.subroutineStack.add(this.getIntArray(this.scriptPointer));
                    this.scriptPointer = this.labelMap.get(vector.get(1))[0];
                    break;
                }
                this.Error(8, this.getStrValue(vector.get(1)) + "\u3068\u3044\u3046\u30e9\u30d9\u30eb\u306f\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                break;
            }
            case 1008: {
                if (this.subroutineStack.empty()) {
                    this.Error(8, "return\u6587\u306e\u623b\u308a\u5148\u304c\u3042\u308a\u307e\u305b\u3093");
                }
                this.scriptPointer = this.subroutineStack.pop()[0] + 1;
                break;
            }
            case 1007: {
                if (vector.size() == 2) {
                    String string = this.getStrValue(vector.get(1));
                    this.getScript(string, "EUC_JP");
                } else if (vector.size() == 3) {
                    String string = this.getStrValue(vector.get(1));
                    String string2 = this.getStrValue(vector.get(2));
                    this.getScript(string, string2);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.scriptPointer = 0;
                break;
            }
            case 1019: {
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                String string = this.strToStr(vector.get(1));
                this.drawText(string, true, 0);
                ++this.scriptPointer;
                break;
            }
            case 1021: {
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                String string = this.strToStr(vector.get(1));
                System.out.println(string);
                ++this.scriptPointer;
                break;
            }
            case 1020: {
                if (vector.size() == 2) {
                    String string = this.getStrValue(vector.get(1));
                    this.drawText(string, false, 2000);
                } else if (vector.size() == 3) {
                    String string = this.getStrValue(vector.get(1));
                    int n4 = this.Calc(vector.get(2));
                    this.drawText(string, false, n4);
                } else if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 1013: {
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.inputValue(vector.get(1));
                ++this.scriptPointer;
                break;
            }
            case 1011: {
                this.setVariable(vector.get(1));
                ++this.scriptPointer;
                break;
            }
            case 1001: {
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (this.judge(vector.get(1))) {
                    ++this.scriptPointer;
                } else {
                    Vector<String> vector2 = this.scriptParams.get(this.scriptPointer + 1);
                    this.scriptPointer = Integer.parseInt(vector2.get(1));
                }
                ++this.scriptPointer;
                break;
            }
            case 1003: {
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (this.judge(vector.get(1))) {
                    ++this.scriptPointer;
                } else {
                    Vector<String> vector3 = this.scriptParams.get(this.scriptPointer + 1);
                    this.scriptPointer = Integer.parseInt(vector3.get(1));
                }
                ++this.scriptPointer;
                break;
            }
            case 1004: {
                if (vector.size() != 4) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.setVariable(vector.get(1));
                if (this.judge(vector.get(2))) {
                    ++this.scriptPointer;
                } else {
                    Vector<String> vector4 = this.scriptParams.get(this.scriptPointer + 1);
                    this.scriptPointer = Integer.parseInt(vector4.get(1));
                }
                ++this.scriptPointer;
                break;
            }
            case 1010: {
                int n5 = Integer.parseInt(vector.get(1));
                int n6 = this.basicMap.get(vector.get(2))[0];
                switch (n6) {
                    case 1003: {
                        if (this.judge(vector.get(3))) {
                            this.scriptPointer = n5 + 1;
                            break block0;
                        }
                        ++this.scriptPointer;
                        break block0;
                    }
                    case 1004: {
                        this.setVariable(vector.get(4));
                        if (this.judge(vector.get(3))) {
                            this.scriptPointer = n5 + 1;
                            break block0;
                        }
                        ++this.scriptPointer;
                        break block0;
                    }
                    case 1001: {
                        if (this.scriptCode.get(this.scriptPointer + 1)[0] == 1002) {
                            Vector<String> vector5 = this.scriptParams.get(this.scriptPointer + 2);
                            this.scriptPointer = Integer.parseInt(vector5.get(1)) + 1;
                            break block0;
                        }
                        ++this.scriptPointer;
                        break block0;
                    }
                }
                ++this.scriptPointer;
                break;
            }
            case 2033: {
                this.debug = this.debug == 0 ? 1 : 0;
                ++this.scriptPointer;
                break;
            }
            case 2015: {
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                int n7 = this.Calc(vector.get(1));
                if (this.dmng == null) {
                    this.waitMiliSec(n7);
                } else {
                    this.dmng.waitMiliSec(n7);
                }
                ++this.scriptPointer;
                break;
            }
            case 2037: {
                String string;
                if (vector.size() != 3) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (!this.isIntVar(string = vector.get(1))) {
                    this.Error(8, string + "\u306f\u6574\u6570\u578b\u306e\u5909\u6570\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
                }
                int n8 = this.Calc(vector.get(2));
                int n9 = (int)(Math.random() * (double)n8);
                this.setVarIntValue(string, n9);
                ++this.scriptPointer;
                break;
            }
            case 2038: {
                String string;
                if (vector.size() != 3) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (!this.isIntVar(string = vector.get(1))) {
                    this.Error(8, string + "\u306f\u6574\u6570\u578b\u306e\u5909\u6570\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
                }
                int n10 = this.Calc(string);
                int n11 = Math.abs(n10);
                this.setVarIntValue(string, n11);
                ++this.scriptPointer;
                break;
            }
            case 2035: {
                if (vector.size() < 3) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.saveVariable(vector);
                ++this.scriptPointer;
                break;
            }
            case 2036: {
                if (vector.size() < 3) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.loadVariable(vector);
                ++this.scriptPointer;
                break;
            }
            case 2001: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                int n12 = this.Calc(vector.get(1));
                this.dmng.setCellNumber(n12);
                ++this.scriptPointer;
                break;
            }
            case 2006: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 2) {
                    String string = this.getStrValue(vector.get(1));
                    this.dmng.setCellView(string);
                } else if (vector.size() == 3) {
                    int n13 = this.Calc(vector.get(1));
                    int n14 = this.Calc(vector.get(2));
                    this.dmng.setCellView(n13, n14);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2003: {
                if (vector.size() == 4) {
                    int n15;
                    int n16 = this.Calc(vector.get(1));
                    String string = vector.get(2).trim();
                    int n17 = this.dmng.getPositionCode(string);
                    if (n17 == 0) {
                        n17 = this.Calc(vector.get(2));
                    }
                    if ((n15 = this.dmng.getPositionCode(string = vector.get(3).trim())) == 0) {
                        n15 = this.Calc(vector.get(3));
                    }
                    this.dmng.setCellPosition(n16, n17, n15);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2004: {
                if (vector.size() == 4) {
                    int n18 = this.Calc(vector.get(1));
                    int n19 = this.Calc(vector.get(2));
                    int n20 = this.Calc(vector.get(3));
                    this.dmng.setCellSize(n18, n19, n20);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2002: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 3) {
                    String string;
                    int n21 = this.Calc(vector.get(1));
                    boolean bl = this.dmng.setCellImage(n21, string = this.getStrValue(vector.get(2)));
                    if (!bl) {
                        this.Error(8, "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb" + string + "\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
                    }
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2007: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 5) {
                    int n22 = this.Calc(vector.get(1));
                    int n23 = this.Calc(vector.get(2));
                    int n24 = this.Calc(vector.get(3));
                    int n25 = this.Calc(vector.get(4));
                    this.dmng.setCellCanvas(n22, n23, n24, n25);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2008: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 6) {
                    int n26 = this.Calc(vector.get(1));
                    String string = this.getStrValue(vector.get(2));
                    String string3 = this.getStrValue(vector.get(3));
                    int n27 = this.Calc(vector.get(4));
                    int n28 = this.Calc(vector.get(5));
                    this.dmng.setCellTextParameter(n26, string, string3, n27, n28);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2009: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 3) {
                    int n29 = this.Calc(vector.get(1));
                    String string = this.getStrValue(vector.get(2));
                    this.dmng.setCellText(n29, string);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2010: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 2) {
                    int n30 = this.Calc(vector.get(1));
                    this.dmng.setShiftView(n30);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2011: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 2) {
                    int n31 = this.Calc(vector.get(1));
                    this.dmng.setShiftHide(n31);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2012: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 1) {
                    this.dmng.viewDisplay();
                } else if (vector.size() == 2) {
                    String string = this.getStrValue(vector.get(1));
                    this.dmng.viewDisplay(string);
                } else if (vector.size() == 3) {
                    String string = this.getStrValue(vector.get(1));
                    String string4 = this.getStrValue(vector.get(2));
                    this.dmng.transitionDisplay(string, string4);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.waitDisplayExec();
                ++this.scriptPointer;
                break;
            }
            case 2013: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 2) {
                    String string = this.getStrValue(vector.get(1));
                    this.dmng.transitionDisplay(string);
                } else if (vector.size() == 3) {
                    String string = this.getStrValue(vector.get(1));
                    String string5 = this.getStrValue(vector.get(2));
                    this.dmng.transitionDisplay(string, string5);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.waitDisplayExec();
                ++this.scriptPointer;
                break;
            }
            case 2005: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 3) {
                    int n32 = this.Calc(vector.get(1));
                    int n33 = this.Calc(vector.get(2));
                    this.dmng.setTransColor(n32, n33);
                } else if (vector.size() == 4) {
                    int n34 = this.Calc(vector.get(1));
                    int n35 = this.Calc(vector.get(2));
                    int n36 = this.Calc(vector.get(3));
                    this.dmng.setTransColor(n34, n35, n36);
                } else if (vector.size() == 5) {
                    int n37 = this.Calc(vector.get(1));
                    int n38 = this.Calc(vector.get(2));
                    int n39 = this.Calc(vector.get(3));
                    int n40 = this.Calc(vector.get(4));
                    this.dmng.setTransColor(n37, n38, n39, n40);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2032: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.cellClick(vector);
                ++this.scriptPointer;
                break;
            }
            case 2014: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 3) {
                    int n41 = this.Calc(vector.get(1));
                    int n42 = this.Calc(vector.get(2));
                    this.dmng.createDisplay(n41, n42);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2016: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 2) {
                    int n43 = this.Calc(vector.get(1));
                    this.dmng.setFontColor(n43, this.anotherColor(n43));
                } else if (vector.size() == 3) {
                    int n44 = this.Calc(vector.get(1));
                    int n45 = this.Calc(vector.get(2));
                    this.dmng.setFontColor(n44, n45);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2017: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 4) {
                    String string = this.getStrValue(vector.get(1));
                    String string6 = this.getStrValue(vector.get(2));
                    int n46 = this.Calc(vector.get(3));
                    this.dmng.setTextFont(string, string6, n46);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2019: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 3) {
                    int n47 = this.Calc(vector.get(1));
                    int n48 = this.Calc(vector.get(2));
                    this.dmng.setTextInterval(n47, n48);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2018: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 5) {
                    int n49 = this.Calc(vector.get(1));
                    int n50 = this.Calc(vector.get(2));
                    int n51 = this.Calc(vector.get(3));
                    int n52 = this.Calc(vector.get(4));
                    this.dmng.setTextArea(n49, n50, n51, n52);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2021: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 5) {
                    int n53 = this.Calc(vector.get(1));
                    int n54 = this.Calc(vector.get(2));
                    int n55 = this.Calc(vector.get(3));
                    int n56 = this.Calc(vector.get(4));
                    this.dmng.setSelectArea(n53, n54, n55, n56);
                } else if (vector.size() == 7) {
                    int n57 = this.Calc(vector.get(1));
                    int n58 = this.Calc(vector.get(2));
                    int n59 = this.Calc(vector.get(3));
                    int n60 = this.Calc(vector.get(4));
                    int n61 = this.Calc(vector.get(5));
                    int n62 = this.Calc(vector.get(6));
                    this.dmng.setSelectArea(n57, n58, n59, n60, n61, n62);
                } else if (vector.size() == 9) {
                    int n63 = this.Calc(vector.get(1));
                    int n64 = this.Calc(vector.get(2));
                    int n65 = this.Calc(vector.get(3));
                    int n66 = this.Calc(vector.get(4));
                    int n67 = this.Calc(vector.get(5));
                    int n68 = this.Calc(vector.get(6));
                    int n69 = this.Calc(vector.get(7));
                    int n70 = this.Calc(vector.get(8));
                    this.dmng.setSelectArea(n63, n64, n65, n66, n67, n68, n69, n70);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2022: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() == 5) {
                    int n71 = this.Calc(vector.get(1));
                    int n72 = this.Calc(vector.get(2));
                    int n73 = this.Calc(vector.get(3));
                    int n74 = this.Calc(vector.get(4));
                    this.dmng.setSelectColor(n71, n72, n73, n74);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2020: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (vector.size() < 3) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.buttonSelect(vector);
                ++this.scriptPointer;
                break;
            }
            case 2024: {
                String string;
                int n75;
                if (vector.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if ((n75 = this.sound.MIDIload(string = this.getStrValue(vector.get(1)))) > 0) {
                    this.Error(8, "\u3053\u306eMIDI [" + string + "] \u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002(" + n75 + ")");
                }
                ++this.scriptPointer;
                break;
            }
            case 2023: {
                int n76 = this.sound.Midiplay();
                if (n76 > 0) {
                    this.Error(8, "\u3053\u306eMIDI\u3092\u6f14\u594f\u3067\u304d\u307e\u305b\u3093\u3002");
                }
                this.th_wtime = 30;
                ++this.scriptPointer;
                break;
            }
            case 2025: {
                this.sound.MIDIstop();
                this.th_wtime = 0;
                ++this.scriptPointer;
                break;
            }
            case 2027: {
                String string;
                int n77;
                if (vector.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if ((n77 = this.sound.AUDIOLoop(string = this.getStrValue(vector.get(1)))) > 0) {
                    this.Error(8, "\u3053\u306e\u30aa\u30fc\u30c7\u30a3\u30aa\u30d5\u30a1\u30a4\u30eb [" + string + "] \u3092\u6f14\u594f\u3067\u304d\u307e\u305b\u3093\u3002(" + n77 + ")");
                }
                ++this.scriptPointer;
                break;
            }
            case 2026: {
                String string;
                int n78;
                if (vector.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if ((n78 = this.sound.AUDIOPlay(string = this.getStrValue(vector.get(1)))) > 0) {
                    this.Error(8, "\u3053\u306e\u30aa\u30fc\u30c7\u30a3\u30aa\u30d5\u30a1\u30a4\u30eb [" + string + "] \u3092\u6f14\u594f\u3067\u304d\u307e\u305b\u3093\u3002(" + n78 + ")");
                }
                ++this.scriptPointer;
                break;
            }
            case 2028: {
                if (vector.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                String string = this.getStrValue(vector.get(1));
                this.sound.AUDIOStop(string);
                ++this.scriptPointer;
                break;
            }
            case 2029: {
                String string;
                int n79;
                if (vector.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if ((n79 = this.sound.CLIPLoop(string = this.getStrValue(vector.get(1)))) > 0) {
                    this.Error(8, "\u3053\u306e\u30aa\u30fc\u30c7\u30a3\u30aa\u30d5\u30a1\u30a4\u30eb [" + string + "] \u3092\u6f14\u594f\u3067\u304d\u307e\u305b\u3093\u3002(" + n79 + ")");
                }
                ++this.scriptPointer;
                break;
            }
            case 2030: {
                if (vector.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                String string = this.getStrValue(vector.get(1));
                this.sound.CLIPStop(string);
                ++this.scriptPointer;
                break;
            }
            case 2031: {
                if (vector.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.th_wtime = this.Calc(vector.get(1));
                ++this.scriptPointer;
                break;
            }
            default: {
                ++this.scriptPointer;
            }
        }
    }

    private int anotherColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        n2 = n2 > 127 ? (n2 /= 2) : (n2 + 127) / 2;
        n3 = n3 > 127 ? (n3 /= 2) : (n3 + 127) / 2;
        n4 = n4 > 127 ? (n4 /= 2) : (n4 + 127) / 2;
        int n5 = 0xFF000000 | n2 << 16 | n3 << 8 | n4;
        return n5;
    }

    private void Error(int n, String string) {
        if (this.scriptPointer == 0 || this.scriptParams == null) {
            System.err.print("JONGS-Error:" + string);
        } else {
            System.err.print("JONGS-Error:" + string + ":" + this.scriptParams.get(this.scriptPointer));
        }
        switch (n) {
            case 0: {
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.sound.MIDIclose();
                if (this.dmng != null) {
                    this.dmng.dispose();
                }
                System.exit(n);
                break;
            }
            default: {
                this.sound.MIDIclose();
                if (this.dmng != null) {
                    this.dmng.dispose();
                }
                System.exit(n);
            }
        }
    }

    @Override
    public void run() {
        while (this.scriptPointer < this.scriptCode.size()) {
            if (this.debug > 0) {
                System.out.println("JONGS Line:" + this.scriptParams.get(this.scriptPointer).toString());
            }
            this.oneLineExec();
            if (this.th_wtime <= 0) continue;
            this.waitMiliSec(this.th_wtime);
        }
        this.sound.MIDIclose();
        if (this.dmng != null) {
            this.dmng.dispose();
        }
    }

    public static void main(String[] stringArray) {
        JongScripter jongScripter = new JongScripter();
        if (stringArray.length > 0) {
            if (stringArray.length >= 2) {
                jongScripter.getScript(stringArray[0], stringArray[1]);
            } else {
                jongScripter.getScript(stringArray[0], "EUC_JP");
            }
            jongScripter.start();
        }
    }
}

