/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import jongs.jongsDisplay;
import jongs.jongsImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jongsDisplayManagement {
    public static final int POS_UPPER = Integer.MAX_VALUE;
    public static final int POS_LOWER = 0x7FFFFFFE;
    public static final int POS_MIDDLE = 0x7FFFFFFD;
    public static final int POS_LEFT = 0x7FFFFFFC;
    public static final int POS_RIGHT = 0x7FFFFFFB;
    public static final int POS_CENTER = 0x7FFFFFFA;
    HashMap<String, int[]> positionMap;
    jongsImage[] cellImages;
    BufferedImage disp_buf00 = null;
    Graphics gdb00;
    Frame dispFrame;
    jongsDisplay disp;
    Thread dispThread;
    String Text;
    Rectangle selectArea00;
    int[] selectColor00;
    Font selectFont00;

    public jongsDisplayManagement() {
        this.initJDM(800, 600);
    }

    public jongsDisplayManagement(int w, int h) {
        this.initJDM(w, h);
    }

    private void initJDM(int w, int h) {
        this.initPositionCode();
        this.createDisplay(w, h);
        this.selectArea00 = new Rectangle(w / 10, h / 2, w * 8 / 10, h / 5);
        this.selectColor00 = new int[]{0xFFFFFF, 0xAAAAFF, 0xFFFFCC, 68};
        this.selectFont00 = new Font("Dialog", 1, 8);
    }

    private void initPositionCode() {
        this.positionMap = new HashMap();
        this.positionMap.put("_upper", this.getIntArray(Integer.MAX_VALUE));
        this.positionMap.put("_lower", this.getIntArray(0x7FFFFFFE));
        this.positionMap.put("_top", this.getIntArray(Integer.MAX_VALUE));
        this.positionMap.put("_bottom", this.getIntArray(0x7FFFFFFE));
        this.positionMap.put("_middle", this.getIntArray(0x7FFFFFFD));
        this.positionMap.put("_left", this.getIntArray(0x7FFFFFFC));
        this.positionMap.put("_right", this.getIntArray(0x7FFFFFFB));
        this.positionMap.put("_center", this.getIntArray(0x7FFFFFFA));
    }

    public int[] getIntArray(int i) {
        int[] a = new int[]{i};
        return a;
    }

    public void waitMiliSec(int w) {
        if (w == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        long wtime = w;
        while (wtime < System.currentTimeMillis() - start) {
        }
    }

    public BufferedImage loadImage(String filename, ImageObserver iob) {
        BufferedImage bimg;
        try {
            bimg = ImageIO.read(new File("./" + filename));
        }
        catch (IOException ioe) {
            return null;
        }
        return bimg;
    }

    public int checkCellClick(int zx, int zy) {
        int n = this.cellImages.length - 1;
        while (n >= 0) {
            if (this.cellImages[n] != null && this.cellImages[n].checkImageClick(zx, zy)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public boolean diaplayBusy() {
        boolean busy = this.disp.commandCode != 0 || this.disp.busy;
        return busy;
    }

    public int visibleCellNum() {
        int v = 0;
        int n = 0;
        while (n < this.cellImages.length) {
            if (this.cellImages[n] != null && this.cellImages[n].view) {
                ++v;
            }
            ++n;
        }
        return v;
    }

    public void createDisplay(int w, int h) {
        this.dispFrame = new Frame();
        this.dispFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.dispFrame.setSize(w + 6, h + 20);
        this.disp = new jongsDisplay(w, h);
        this.dispFrame.add(this.disp);
        this.dispThread = new Thread(this.disp);
        this.dispFrame.setVisible(true);
        this.disp_buf00 = new BufferedImage(w, h, 4);
        this.gdb00 = this.disp_buf00.getGraphics();
        this.dispThread.start();
    }

    public void dispose() {
        this.dispFrame.dispose();
    }

    public void drawImageBuf() {
        Graphics dbg = this.gdb00;
        dbg.setColor(Color.black);
        dbg.fillRect(0, 0, this.disp_buf00.getWidth(), this.disp_buf00.getHeight());
        int n = 0;
        while (n < this.cellImages.length) {
            if (this.cellImages[n] != null && this.cellImages[n].view) {
                jongsImage ji = this.cellImages[n];
                dbg.drawImage(ji.image, ji.getX(), ji.getY(), ji.getWidth(), ji.getHeight(), this.disp);
            }
            ++n;
        }
    }

    public int getPositionCode(String tr) {
        String tstr = tr.trim().toLowerCase();
        if (this.positionMap.containsKey(tstr)) {
            return this.positionMap.get(tstr)[0];
        }
        return 0;
    }

    public Point changePosition(int cell, int x, int y) {
        switch (x) {
            case 0x7FFFFFFC: {
                x = 0;
                break;
            }
            case 0x7FFFFFFB: {
                int w = this.cellImages[cell].getWidth();
                x = this.disp.width - w;
                break;
            }
            case 0x7FFFFFFA: {
                int w = this.cellImages[cell].getWidth();
                x = (this.disp.width - w) / 2;
            }
        }
        switch (y) {
            case 0x7FFFFFFF: {
                y = 0;
                break;
            }
            case 0x7FFFFFFE: {
                int h = this.cellImages[cell].getHeight();
                y = this.disp.height - h;
                break;
            }
            case 0x7FFFFFFD: {
                int h = this.cellImages[cell].getHeight();
                y = (this.disp.height - h) / 2;
            }
        }
        Point pt = new Point(x, y);
        return pt;
    }

    public void setCellNumber(int cn) {
        this.cellImages = new jongsImage[cn];
    }

    public boolean setCellImage(int cell, String filename) {
        BufferedImage bimg;
        if (this.cellImages[cell] == null) {
            this.cellImages[cell] = new jongsImage();
            this.cellImages[cell].setPoint(0, 0);
        }
        if ((bimg = this.loadImage(filename, this.disp)) == null) {
            return false;
        }
        this.cellImages[cell].setImage(bimg, this.disp);
        this.cellImages[cell].setFileName(filename);
        return true;
    }

    public void setTransColor(int cell, int tc) {
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].setTransColor(tc);
        }
    }

    public void setTransColor(int cell, int col, int alpha) {
        if (this.cellImages[cell] != null) {
            int tc = alpha << 24 | col & 0xFFFFFF;
            this.cellImages[cell].setTransColor(tc);
        }
    }

    public void setTransColor(int cell, int x, int y, int alpha) {
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].setTransColor(x, y, alpha);
        }
    }

    public void setCellPosition(int cell, int x, int y) {
        if (this.cellImages[cell] != null) {
            Point pt = this.changePosition(cell, x, y);
            this.cellImages[cell].setPoint(pt);
        }
    }

    public void setCellSize(int cell, int w, int h) {
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].setSize(w, h);
        }
    }

    public void setCellView(String flagStr) {
        int n = 0;
        while (n < flagStr.length() && n < this.cellImages.length) {
            char c = flagStr.charAt(n);
            if (this.cellImages[n] != null) {
                if (c == '0') {
                    this.cellImages[n].setView(false);
                } else if (c == '1') {
                    this.cellImages[n].setView(true);
                }
            }
            ++n;
        }
    }

    public void setCellView(int flag) {
        int flagHex = flag;
        int n = 0;
        while (n < 32 && n < this.cellImages.length) {
            int c = flagHex & 1;
            if (this.cellImages[n] != null) {
                if (c == 0) {
                    this.cellImages[n].setView(false);
                } else if (c == 1) {
                    this.cellImages[n].setView(true);
                }
            }
            flagHex >>= 1;
            ++n;
        }
    }

    public void setCellView(int cell, int val) {
        if (cell < this.cellImages.length && this.cellImages[cell] != null) {
            if (val == 0) {
                this.cellImages[cell].setView(false);
            } else if (val == 1) {
                this.cellImages[cell].setView(true);
            }
        }
    }

    public void setCellView(int cell, String val) {
        if (cell < this.cellImages.length && this.cellImages[cell] != null) {
            if (val.trim().toLowerCase().equals("false")) {
                this.cellImages[cell].setView(false);
            } else if (val.trim().toLowerCase().equals("true")) {
                this.cellImages[cell].setView(true);
            }
        }
    }

    public void viewDisplay() {
        this.drawImageBuf();
        this.disp.viewDisplay(this.disp_buf00);
    }

    public void viewDisplay(String flagStr) {
        this.setCellView(flagStr);
        this.drawImageBuf();
        this.disp.viewDisplay(this.disp_buf00);
    }

    public void setDisplaySize(int w, int h) {
        this.createDisplay(w, h);
    }

    public void transitionDisplay(String tstr) {
        this.drawImageBuf();
        this.disp.transitionDisplay(this.disp_buf00, tstr);
    }

    public void transitionDisplay(String flagStr, String tstr) {
        this.setCellView(flagStr);
        this.drawImageBuf();
        this.disp.transitionDisplay(this.disp_buf00, tstr);
    }

    public int getTransitionCode(String tr) {
        return this.disp.getTransitionCode(tr);
    }

    public void setFontColor(int fc1, int fc2) {
        this.disp.setFontColor(fc1, fc2);
    }

    public void setTextFont(String n, String s, int sz) {
        String name = n.trim();
        String stl = s.trim().toLowerCase();
        int style = 0;
        int size = sz;
        if (name.length() == 0) {
            name = this.disp.textFont.getFontName();
        }
        style = stl.length() == 0 ? this.disp.textFont.getStyle() : (stl.equals("plain") ? 0 : (stl.equals("italic") ? 2 : (stl.equals("bold") ? 1 : 0)));
        if (size == 0) {
            size = this.disp.textFont.getSize();
        }
        this.disp.setTextFont(new Font(name, style, size));
    }

    public void setTextArea(int x, int y, int w, int h) {
        this.disp.setTextArea(x, y, w, h);
    }

    public void setTextInterval(int ls, int lh) {
        this.disp.setTextInterval(ls, lh);
    }

    public void calcSelectButton(Rectangle Area, int xnum, int ynum, int xspan, int yspan) {
        int bnum = xnum * ynum;
        int bwid = (Area.width - xspan * (xnum - 1)) / xnum;
        int bhei = (Area.height - yspan * (ynum - 1)) / ynum;
        if (bwid < 0) {
            bwid = Area.width / xnum;
            xspan = 0;
        }
        if (bhei < 0) {
            bhei = Area.height / ynum;
            yspan = 0;
        }
        Rectangle[] button = new Rectangle[bnum];
        int bn = 0;
        int bpy = Area.y;
        int by = 0;
        while (by < ynum) {
            int bpx = Area.x;
            int bx = 0;
            while (bx < xnum) {
                button[bn] = new Rectangle(bpx, bpy, bwid, bhei);
                ++bn;
                ++bx;
                bpx += bwid + xspan;
            }
            ++by;
            bpy += bhei + yspan;
        }
        this.disp.setSelectButton(button);
    }

    public void setSelectParam(Vector<String> vct, int bw, int bh, boolean mode) {
        int n = vct.size();
        this.disp.setSelectArea(this.selectArea00);
        this.disp.setSelectColor(this.selectColor00);
        this.disp.setSelectText(vct, 2, vct.size() - 2);
        if (mode) {
            if (n < 5) {
                this.calcSelectButton(this.selectArea00, vct.size(), 1, bw, bh);
            } else if (n % 5 == 0) {
                this.calcSelectButton(this.selectArea00, 5, n / 5, bw, bh);
            } else if (n % 4 == 0) {
                this.calcSelectButton(this.selectArea00, 4, n / 4, bw, bh);
            } else if (n % 3 == 0) {
                this.calcSelectButton(this.selectArea00, 3, n / 3, bw, bh);
            } else {
                this.calcSelectButton(this.selectArea00, 5, n / 5 + 1, bw, bh);
            }
        } else if (n < 5) {
            this.calcSelectButton(this.selectArea00, 1, vct.size(), bw, bh);
        } else if (n % 5 == 0) {
            this.calcSelectButton(this.selectArea00, n / 5, 5, bw, bh);
        } else if (n % 4 == 0) {
            this.calcSelectButton(this.selectArea00, n / 4, 4, bw, bh);
        } else if (n % 3 == 0) {
            this.calcSelectButton(this.selectArea00, n / 3, 3, bw, bh);
        } else {
            this.calcSelectButton(this.selectArea00, n / 5 + 1, 5, bw, bh);
        }
        this.disp.selectClick();
    }

    public void setSelectParam(Vector<String> vct, int bb, boolean mode) {
        this.setSelectParam(vct, bb, bb, mode);
    }

    public void setSelectParam(Vector<String> vct, int bw, int bh) {
        this.setSelectParam(vct, bw, bh, true);
    }

    public void setSelectParam(Vector<String> vct, int bb) {
        this.setSelectParam(vct, bb, bb, true);
    }

    public void setSelectParam(Vector<String> vct, boolean mode) {
        this.setSelectParam(vct, 0, 0, mode);
    }

    public void setSelectParam(Vector<String> vct) {
        this.setSelectParam(vct, 0, 0, true);
    }

    public void setSelectArea(int x, int y, int w, int h) {
        this.selectArea00 = new Rectangle(x, y, w, h);
    }

    public void setSelectColor(int c1, int c2, int c3, int c4) {
        this.selectColor00 = new int[4];
        this.selectColor00[0] = c1;
        this.selectColor00[1] = c2;
        this.selectColor00[2] = c3;
        this.selectColor00[3] = c4;
    }

    public void drawText(String txt) {
        this.disp.drawText(txt);
    }

    public void drawWaitText(String txt, int time) {
        this.disp.drawWaitText(txt, time);
    }

    public int getSelectButton() {
        return this.disp.selectButton;
    }

    public String getSelectText() {
        return this.disp.selectText;
    }

    public void cellClick() {
        this.disp.cellClick();
    }

    public int getSelectCell() {
        int press;
        int cellvalue = this.checkCellClick(this.disp.releasex, this.disp.releasey);
        if (cellvalue != (press = this.checkCellClick(this.disp.pressx, this.disp.pressy))) {
            this.disp.cellClick();
            cellvalue = -1;
        }
        return cellvalue;
    }
}

