/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jongsDisplay
extends Canvas
implements Runnable {
    public static final int EFE_NOEFFECT = 2000;
    public static final int EFE_ZOOMIN = 2001;
    public static final int EFE_MOSAIC = 2002;
    public static final int EFE_FADEIN = 2003;
    public static final int EFE_WIPE = 2004;
    public static final int EFE_HASH = 2005;
    public static final int EFE_BOOK_LEFT = 2006;
    public static final int EFE_BOOK_RIGHT = 2007;
    static final long serialVersionUID = 0x100001L;
    BufferedImage disp_buf00 = null;
    BufferedImage disp_buf01 = null;
    Graphics gdb01;
    int width;
    int height;
    Font textFont;
    int fontCol1;
    int fontCol2;
    Color fontColor1;
    Color fontColor2;
    String text;
    Rectangle txtArea;
    boolean letterWriteMode;
    int letter_spacing;
    int line_height;
    int textWaittime;
    int textPosition;
    char presskey;
    int pressx;
    int pressy;
    int releasex;
    int releasey;
    int mouseX;
    int mouseY;
    Rectangle selectArea;
    int[] selectColor;
    Rectangle[] selectbtn;
    Font selectFont;
    Vector<String> selectTexts;
    String selectText;
    int buttonNum;
    int buttonT1st;
    int selectButton;
    int cellvalue;
    int pressed;
    int nowSelect;
    HashMap<String, int[]> transitionMap;
    int transCode;
    int commandCode;
    int transition_wtime;
    boolean busy;

    public jongsDisplay() {
        this.initJongsDisplay(800, 600);
    }

    public jongsDisplay(int w, int h) {
        this.initJongsDisplay(w, h);
    }

    public void initJongsDisplay(int dispw, int disph) {
        this.addKeyListener(this.getKeyListener());
        this.addMouseListener(this.getMouseListener());
        this.addMouseMotionListener(this.getMouseMotionListener());
        this.setBounds(dispw, disph);
        this.setTextFont(new Font("Selif", 0, 14));
        this.setFontColor(0xFFFFFF, 0xAAAAAA);
        this.setTextArea(dispw / 10, disph / 10, dispw * 8 / 10, disph * 8 / 10);
        this.text = "";
        this.letter_spacing = 3;
        this.line_height = 0;
        this.setSelectArea(50, disph / 2, dispw - 100, 50);
        this.setSelectFont(new Font("Selif", 1, 8));
        this.setSelectColor(0xFFFFFF, 0xBBBBFF, 0xFFAAAA, 0);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.initTransitionCode();
        this.commandCode = 0;
        this.busy = false;
        this.mouseY = -1;
        this.mouseX = -1;
    }

    private MouseListener getMouseListener() {
        MouseListener ml = new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                if (jongsDisplay.this.commandCode == 1011) {
                    if (jongsDisplay.this.letterWriteMode) {
                        jongsDisplay.this.letterWriteMode = false;
                    } else {
                        jongsDisplay.this.presskey = (char)32;
                        jongsDisplay.this.commandCode = 0;
                    }
                }
                if (jongsDisplay.this.busy) {
                    return;
                }
                jongsDisplay.this.mouseX = jongsDisplay.this.calcPositionX(e.getX());
                jongsDisplay.this.mouseY = jongsDisplay.this.calcPositionY(e.getY());
                if (jongsDisplay.this.commandCode == 2015) {
                    jongsDisplay.this.selectButton = jongsDisplay.this.checkSelectButton(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.selectButton != -1) {
                        if (jongsDisplay.this.selectButton == jongsDisplay.this.pressed) {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.selectButton, 2);
                            jongsDisplay.this.selectText = jongsDisplay.this.selectTexts.get(jongsDisplay.this.buttonT1st + jongsDisplay.this.selectButton);
                            jongsDisplay.this.commandCode = 0;
                        } else {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.pressed, 0);
                            jongsDisplay.this.selectButton = -1;
                            jongsDisplay.this.pressed = -1;
                        }
                    } else {
                        jongsDisplay.this.nowSelect = jongsDisplay.this.pressed;
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.pressed, 1);
                        jongsDisplay.this.pressed = -1;
                    }
                    jongsDisplay.this.drawDisplay();
                } else if (jongsDisplay.this.commandCode == 2027) {
                    jongsDisplay.this.releasex = jongsDisplay.this.mouseX;
                    jongsDisplay.this.releasey = jongsDisplay.this.mouseY;
                    jongsDisplay.this.commandCode = 0;
                }
            }

            public void mousePressed(MouseEvent e) {
                if (jongsDisplay.this.busy) {
                    return;
                }
                jongsDisplay.this.mouseX = jongsDisplay.this.calcPositionX(e.getX());
                jongsDisplay.this.mouseY = jongsDisplay.this.calcPositionY(e.getY());
                if (jongsDisplay.this.commandCode == 2015) {
                    jongsDisplay.this.pressed = jongsDisplay.this.checkSelectButton(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.pressed != -1) {
                        if (jongsDisplay.this.nowSelect != -1) {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 0);
                        }
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.pressed, 2);
                        jongsDisplay.this.nowSelect = jongsDisplay.this.pressed;
                    }
                    jongsDisplay.this.drawDisplay();
                } else if (jongsDisplay.this.commandCode == 2027) {
                    jongsDisplay.this.pressx = jongsDisplay.this.mouseX;
                    jongsDisplay.this.pressy = jongsDisplay.this.mouseY;
                }
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }
        };
        return ml;
    }

    private KeyListener getKeyListener() {
        KeyListener kl = new KeyListener(){

            public void keyReleased(KeyEvent ke) {
                if (jongsDisplay.this.busy) {
                    return;
                }
                if (jongsDisplay.this.commandCode == 2015) {
                    if (ke.getKeyCode() == 39) {
                        if (jongsDisplay.this.nowSelect == -1) {
                            jongsDisplay.this.nowSelect = 0;
                        } else {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 0);
                            ++jongsDisplay.this.nowSelect;
                            if (jongsDisplay.this.nowSelect >= jongsDisplay.this.buttonNum) {
                                jongsDisplay.this.nowSelect = 0;
                            }
                        }
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 1);
                        jongsDisplay.this.pressed = -1;
                        jongsDisplay.this.selectButton = -1;
                        jongsDisplay.this.drawDisplay();
                    } else if (ke.getKeyCode() == 37) {
                        if (jongsDisplay.this.nowSelect == -1) {
                            jongsDisplay.this.nowSelect = 0;
                        } else {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 0);
                            --jongsDisplay.this.nowSelect;
                            if (jongsDisplay.this.nowSelect < 0) {
                                jongsDisplay.this.nowSelect = jongsDisplay.this.buttonNum - 1;
                            }
                        }
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 1);
                        jongsDisplay.this.pressed = -1;
                        jongsDisplay.this.selectButton = -1;
                        jongsDisplay.this.drawDisplay();
                    } else if (ke.getKeyCode() == 10) {
                        if (jongsDisplay.this.nowSelect < 0) {
                            jongsDisplay.this.nowSelect = 0;
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 1);
                            jongsDisplay.this.drawDisplay();
                        } else {
                            jongsDisplay.this.selectButton = jongsDisplay.this.nowSelect;
                            jongsDisplay.this.selectText = jongsDisplay.this.selectTexts.get(jongsDisplay.this.buttonT1st + jongsDisplay.this.selectButton);
                            jongsDisplay.this.commandCode = 0;
                            jongsDisplay.this.pressed = -1;
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.selectButton, 2);
                            jongsDisplay.this.drawDisplay();
                        }
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent ke) {
                if (jongsDisplay.this.commandCode == 1011) {
                    if (jongsDisplay.this.letterWriteMode) {
                        jongsDisplay.this.letterWriteMode = false;
                    } else {
                        jongsDisplay.this.presskey = ke.getKeyChar();
                        jongsDisplay.this.commandCode = 0;
                    }
                }
            }
        };
        return kl;
    }

    private MouseMotionListener getMouseMotionListener() {
        MouseMotionListener mml = new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                if (jongsDisplay.this.busy) {
                    return;
                }
                if (jongsDisplay.this.commandCode == 2015) {
                    int ns;
                    jongsDisplay.this.mouseX = jongsDisplay.this.calcPositionX(e.getX());
                    jongsDisplay.this.mouseY = jongsDisplay.this.calcPositionY(e.getY());
                    if (jongsDisplay.this.selectArea.contains(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY) && (ns = jongsDisplay.this.checkSelectButton(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY)) != -1) {
                        if (jongsDisplay.this.nowSelect != -1) {
                            jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, jongsDisplay.this.nowSelect, 0);
                        }
                        jongsDisplay.this.drawSelectButton(jongsDisplay.this.gdb01, ns, 1);
                        jongsDisplay.this.nowSelect = ns;
                        jongsDisplay.this.drawDisplay();
                    }
                }
            }

            public void mouseDragged(MouseEvent e) {
            }
        };
        return mml;
    }

    private int calcPositionX(int zx) {
        return zx * this.width / this.getWidth();
    }

    private int calcPositionY(int zy) {
        return zy * this.height / this.getHeight();
    }

    private void initTransitionCode() {
        this.transitionMap = new HashMap();
        this.transitionMap.put("_noeffect", this.getIntArray(2000));
        this.transitionMap.put("_zoomin", this.getIntArray(2001));
        this.transitionMap.put("_mosaic", this.getIntArray(2002));
        this.transitionMap.put("_fadein", this.getIntArray(2003));
        this.transitionMap.put("_wipe", this.getIntArray(2004));
        this.transitionMap.put("_hash", this.getIntArray(2005));
        this.transitionMap.put("_bookleft", this.getIntArray(2006));
        this.transitionMap.put("_bookright", this.getIntArray(2007));
    }

    public int getTransitionCode(String tr) {
        String tstr = tr.trim().toLowerCase();
        if (this.transitionMap.containsKey(tstr)) {
            return this.transitionMap.get(tstr)[0];
        }
        return 0;
    }

    private int[] getIntArray(int cd) {
        int[] code = new int[]{cd};
        return code;
    }

    public void setBounds(int w, int h) {
        this.setVisible(false);
        this.setBounds(0, 0, w, h);
        this.disp_buf01 = new BufferedImage(w, h, 4);
        this.gdb01 = this.disp_buf01.getGraphics();
        this.setVisible(true);
        this.setTextArea(10, 30, w - 20, h - 60);
    }

    public void setTextArea(int x, int y, int w, int h) {
        this.txtArea = new Rectangle(x, y, w, h);
    }

    public void setTextInterval(int ls, int lh) {
        this.letter_spacing = ls;
        this.line_height = lh;
    }

    public void setFontColor(int fc1, int fc2) {
        this.fontColor1 = new Color(fc1);
        this.fontColor2 = new Color(fc2);
        this.fontCol1 = fc1;
        this.fontCol2 = fc2;
    }

    public void setTextFont(Font fnt) {
        this.textFont = fnt;
    }

    public void cellClick() {
        this.nowSelect = -1;
        this.pressed = -1;
        this.cellvalue = -1;
        this.commandCode = 2027;
    }

    public void selectClick() {
        this.commandCode = 2015;
        this.nowSelect = -1;
        this.pressed = -1;
        this.selectButton = -1;
        this.buttonsWrite();
    }

    public void buttonsWrite() {
        Graphics disp_g = this.getGraphics();
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        this.textWrite(this.gdb01);
        this.drawSelectButtons(this.gdb01);
        disp_g.drawImage(this.disp_buf01, 0, 0, this.getWidth(), this.getHeight(), this);
        disp_g.dispose();
    }

    public void setSelectArea(int x, int y, int w, int h) {
        this.selectArea = new Rectangle(x, y, w, h);
    }

    public void setSelectArea(Rectangle area) {
        this.selectArea = area;
    }

    public void setSelectButton(Rectangle[] btn) {
        this.selectbtn = btn;
    }

    public void setSelectText(Vector<String> vct, int stt, int num) {
        this.selectTexts = vct;
        this.buttonT1st = stt;
        this.buttonNum = num;
    }

    public void setSelectFont(Font fnt) {
        this.selectFont = fnt;
    }

    public void setSelectColor(int c1, int c2, int c3, int c4) {
        this.selectColor = new int[4];
        this.selectColor[0] = c1;
        this.selectColor[1] = c2;
        this.selectColor[2] = c3;
        this.selectColor[3] = c4;
    }

    public void setSelectColor(int[] bc) {
        this.selectColor = bc;
    }

    public void drawSelectButtons(Graphics gp) {
        FontMetrics fm = gp.getFontMetrics(this.selectFont);
        if (this.commandCode == 2015) {
            if (this.selectbtn == null) {
                return;
            }
            int n = 0;
            while (n < this.buttonNum) {
                if (this.selectButton == n) {
                    this.drawSelectButton(gp, n, 2, fm);
                } else if (this.pressed == n) {
                    this.drawSelectButton(gp, n, 2, fm);
                } else if (this.nowSelect == n) {
                    this.drawSelectButton(gp, n, 1, fm);
                } else {
                    this.drawSelectButton(gp, n, 0, fm);
                }
                ++n;
            }
        }
    }

    public void drawSelectButton(Graphics g, int bnum, int stt) {
        FontMetrics fm = g.getFontMetrics(this.selectFont);
        this.drawSelectButton(g, bnum, stt, fm);
    }

    public void drawSelectButton(Graphics g, int bnum, int stt, FontMetrics fm) {
        boolean flag;
        int fc;
        if (bnum < 0 || bnum > this.buttonNum) {
            return;
        }
        Rectangle ra = this.selectbtn[bnum];
        String t = this.selectTexts.get(bnum + this.buttonT1st);
        int x = ra.x;
        int y = ra.y;
        int w = ra.width;
        int h = ra.height;
        switch (stt) {
            case 0: {
                fc = this.selectColor[0];
                flag = true;
                break;
            }
            case 1: {
                fc = this.selectColor[1];
                flag = true;
                break;
            }
            case 2: {
                fc = this.selectColor[2];
                flag = false;
                break;
            }
            default: {
                return;
            }
        }
        g.setColor(new Color(fc));
        g.fill3DRect(x, y, w, h, flag);
        g.draw3DRect(x + 1, y + 1, w - 2, h - 2, flag);
        g.draw3DRect(x + 2, y + 2, w - 4, h - 4, flag);
        g.setColor(new Color(this.selectColor[3]));
        int fh = fm.getHeight();
        int fy = y + fh + (h - fh) / 2;
        int fw = fm.stringWidth(t);
        int fx = x + (w - fw) / 2;
        g.drawString(t, fx, fy);
    }

    public int checkSelectButton(int zx, int zy) {
        int n = 0;
        while (n < this.buttonNum) {
            if (this.selectbtn[n] != null && this.selectbtn[n].contains(zx, zy)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void drawText(String txt) {
        if (txt.charAt(0) == '+') {
            this.textPosition = this.text.length();
            this.text = String.valueOf(this.text) + txt.substring(1);
        } else {
            this.textPosition = 0;
            this.text = txt;
        }
        this.commandCode = 1011;
        this.drawText();
    }

    public void drawWaitText(String txt, int wtime) {
        if (txt.charAt(0) == '+') {
            this.textPosition = this.text.length();
            this.text = String.valueOf(this.text) + txt.substring(1);
        } else {
            this.textPosition = 0;
            this.text = txt;
        }
        this.textWaittime = wtime;
        this.commandCode = 1022;
        this.drawText();
        this.waitMiliSec(this.textWaittime);
        this.commandCode = 0;
    }

    public void clearText() {
        this.text = "";
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        this.commandCode = 0;
    }

    public void drawText() {
        this.busy = true;
        VolatileImage buf = this.createVolatileImage(this.width, this.height);
        Graphics2D bfg = (Graphics2D)buf.getGraphics();
        Graphics disp_g = this.getGraphics();
        if (this.textPosition == 0) {
            this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
            bfg.drawImage((Image)this.disp_buf00, 0, 0, this);
        } else {
            bfg.drawImage((Image)this.disp_buf01, 0, 0, this);
        }
        this.letterWriteMode = true;
        this.textLetterWrite(disp_g, bfg, buf);
        this.letterWriteMode = false;
        bfg.dispose();
        buf.flush();
        this.textWrite(this.gdb01);
        disp_g.drawImage(this.disp_buf01, 0, 0, this.getWidth(), this.getHeight(), this);
        this.busy = false;
    }

    public void textWrite(Graphics gg) {
        int yz;
        Graphics2D sg = (Graphics2D)gg;
        String S = String.valueOf(this.text) + " ";
        sg.setFont(this.textFont);
        FontMetrics fm = sg.getFontMetrics(this.textFont);
        int fhei = fm.getHeight() + this.line_height;
        int sx = this.txtArea.x;
        int sy = this.txtArea.y;
        int sw = this.txtArea.width;
        sg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int c = 1;
        int e = 0;
        int b = 0;
        while (e < S.length()) {
            if (this.calcStringWidth(S, b, e + 1, fm) > sw || S.charAt(e) == '\\' && S.charAt(e + 1) == 'n') {
                yz = c * fhei;
                if (e >= this.textPosition) {
                    this.drawTextString(sg, S.substring(b, e), sx, sy + yz, fm);
                }
                if (S.charAt(e) == '\\' && S.charAt(e + 1) == 'n') {
                    e = b = e + 2;
                } else {
                    b = e;
                }
                ++c;
            }
            ++e;
        }
        yz = c * fhei;
        this.drawTextString(sg, S.substring(b), sx, sy + yz, fm);
    }

    public void textLetterWrite(Graphics dg, Graphics2D bufg, VolatileImage buf) {
        int yz;
        String S = String.valueOf(this.text) + " ";
        bufg.setFont(this.textFont);
        FontMetrics fm = bufg.getFontMetrics(this.textFont);
        int fhei = fm.getHeight() + this.line_height;
        int sx = this.txtArea.x;
        int sy = this.txtArea.y;
        int sw = this.txtArea.width;
        bufg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int c = 1;
        int e = 0;
        int b = 0;
        while (e < S.length()) {
            if (this.calcStringWidth(S, b, e + 1, fm) > sw || S.charAt(e) == '\\' && S.charAt(e + 1) == 'n') {
                yz = c * fhei;
                if (e >= this.textPosition) {
                    this.drawTextString(dg, bufg, buf, S.substring(b, e), sx, sy + yz, fm, 10);
                }
                if (!this.letterWriteMode) {
                    return;
                }
                if (S.charAt(e) == '\\' && S.charAt(e + 1) == 'n') {
                    e = b = e + 2;
                } else {
                    b = e;
                }
                ++c;
            }
            ++e;
        }
        yz = c * fhei;
        this.drawTextString(dg, bufg, buf, S.substring(b), sx, sy + yz, fm, 20);
    }

    private int calcStringWidth(String str, int begin, int end, FontMetrics fm) {
        return fm.stringWidth(str.substring(begin, end)) + this.letter_spacing * (end - begin);
    }

    private void drawTextString(Graphics dg, Graphics2D bfg, VolatileImage buf, String str, int x, int y, FontMetrics fm, int wtime) {
        int p = 0;
        while (p < str.length()) {
            int sx = x + this.calcStringWidth(str, 0, p, fm);
            String letter = str.substring(p, p + 1);
            bfg.setColor(this.fontColor2);
            bfg.drawString(letter, sx - 1, y - 1);
            bfg.drawString(letter, sx + 1, y + 1);
            bfg.drawString(letter, sx - 1, y + 1);
            bfg.drawString(letter, sx + 1, y - 1);
            bfg.setColor(this.fontColor1);
            bfg.drawString(letter, sx, y);
            dg.drawImage(buf, 0, 0, this.getWidth(), this.getHeight(), this);
            if (!this.letterWriteMode) {
                return;
            }
            this.waitMiliSec(wtime);
            ++p;
        }
    }

    private void drawTextString(Graphics2D g, String str, int x, int y, FontMetrics fm) {
        int p = 0;
        while (p < str.length()) {
            int sx = x + this.calcStringWidth(str, 0, p, fm);
            String letter = str.substring(p, p + 1);
            g.setColor(this.fontColor2);
            g.drawString(letter, sx - 1, y - 1);
            g.drawString(letter, sx + 1, y + 1);
            g.drawString(letter, sx - 1, y + 1);
            g.drawString(letter, sx + 1, y - 1);
            g.setColor(this.fontColor1);
            g.drawString(letter, sx, y);
            ++p;
        }
    }

    public void viewDisplay(BufferedImage buf) {
        this.commandCode = 2007;
        this.disp_buf00 = buf;
        this.viewDisplay();
        this.commandCode = 0;
    }

    public void transitionDisplay(BufferedImage buf, String trstr) {
        this.commandCode = 2008;
        int tCode = this.getTransitionCode(trstr);
        if (tCode == 0) {
            this.viewDisplay(buf);
        } else {
            this.transitionDisplay(buf, tCode);
        }
    }

    public void transitionDisplay(BufferedImage buf, int tCode) {
        this.commandCode = 2008;
        this.transCode = tCode;
        this.disp_buf00 = buf;
        this.transitionDisplay();
        this.commandCode = 0;
    }

    private void viewDisplay() {
        Graphics disp_g = this.getGraphics();
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        disp_g.drawImage(this.disp_buf00, 0, 0, this.getWidth(), this.getHeight(), this);
        disp_g.dispose();
    }

    private void drawDisplay() {
        Graphics disp_g = this.getGraphics();
        disp_g.drawImage(this.disp_buf01, 0, 0, this.getWidth(), this.getHeight(), this);
        disp_g.dispose();
    }

    public void transitionDisplay() {
        Graphics disp_g = this.getGraphics();
        VolatileImage img1 = this.createVolatileImage(this.width, this.height);
        Graphics ig = img1.getGraphics();
        ig.drawImage(this.disp_buf01, 0, 0, this);
        VolatileImage img2 = this.createVolatileImage(this.width, this.height);
        ig = img2.getGraphics();
        ig.drawImage(this.disp_buf00, 0, 0, this);
        ig.dispose();
        this.busy = true;
        switch (this.transCode) {
            case 2003: {
                this.transition_wtime = 20;
                this.EffectFadein(disp_g, img1, img2);
                break;
            }
            case 2005: {
                this.transition_wtime = 10;
                this.EffectHash(disp_g, img1, img2);
                break;
            }
            case 2002: {
                this.transition_wtime = 20;
                this.EffectMosaic(disp_g, img1, img2);
                break;
            }
            case 2004: {
                this.transition_wtime = 5;
                this.EffectWipe(disp_g, img1, img2, 50);
                break;
            }
            case 2001: {
                this.transition_wtime = 20;
                this.EffectZoomin(disp_g, img1, img2, 100);
                break;
            }
            case 2007: {
                this.transition_wtime = 5;
                this.EffectBook(disp_g, img1, img2, 0, 50);
                break;
            }
            case 2006: {
                this.transition_wtime = 5;
                this.EffectBook(disp_g, img1, img2, 1, 50);
                break;
            }
        }
        this.gdb01.drawImage(img2, 0, 0, this);
        disp_g.drawImage(img2, 0, 0, this.getWidth(), this.getHeight(), this);
        disp_g.dispose();
        img1.flush();
        img2.flush();
        this.transCode = -1;
        this.busy = false;
    }

    private void EffectFadein(Graphics g, Image img1, Image img2) {
        int iw = this.width;
        int ih = this.height;
        VolatileImage fbuf = this.createVolatileImage(iw, ih * 2);
        Graphics fg = fbuf.getGraphics();
        VolatileImage bbuf = this.createVolatileImage(iw, ih);
        Graphics bg = bbuf.getGraphics();
        fg.drawImage(img1, 0, 0, iw, ih, this);
        fg.drawImage(img2, 0, ih, iw, ih, this);
        int bkw = 5;
        int i = 0;
        while (i < bkw) {
            int x = i;
            while (x < iw) {
                fg.copyArea(x, 0 + ih, 1, ih, 0, -ih);
                x += bkw;
            }
            bg.drawImage(fbuf, 0, 0, iw, ih * 2, this);
            g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
            int y = bkw - 1 - i;
            while (y < ih) {
                fg.copyArea(0, y + ih, iw, 1, 0, -ih);
                y += bkw;
            }
            bg.drawImage(fbuf, 0, 0, iw, ih * 2, this);
            g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
            x = bkw - 1 - i;
            while (x < iw) {
                fg.copyArea(x, 0 + ih, 1, ih, 0, -ih);
                x += bkw;
            }
            bg.drawImage(fbuf, 0, 0, iw, ih * 2, this);
            g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
            y = i;
            while (y < ih) {
                fg.copyArea(0, y + ih, iw, 1, 0, -ih);
                y += bkw;
            }
            bg.drawImage(fbuf, 0, 0, iw, ih * 2, this);
            g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
            ++i;
        }
        g.drawImage(img2, 0, 0, this.getWidth(), this.getHeight(), this);
        bbuf.flush();
    }

    private void EffectHash(Graphics g, Image img1, Image img2) {
        int iw = this.width;
        int ih = this.height;
        int w = 20;
        int mw = iw / w;
        int wmw = w + mw;
        VolatileImage wbuf = this.createVolatileImage(iw, ih * 2);
        Graphics wg = wbuf.getGraphics();
        VolatileImage bbuf = this.createVolatileImage(iw, ih);
        Graphics bg = bbuf.getGraphics();
        wg.drawImage(img1, 0, 0, iw, ih, this);
        wg.drawImage(img2, 0, ih, iw, ih, this);
        wg.copyArea(0, iw, 1, ih, 0, -ih);
        int x1 = 0;
        while (x1 < wmw) {
            int x2 = 0;
            int x3 = x1;
            while (x2 < x1) {
                int x = mw * (x1 - x3) + x3;
                wg.copyArea(x, ih, 1, ih, 0, -ih);
                ++x2;
                --x3;
            }
            bg.drawImage(wbuf, 0, 0, this);
            g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
            this.waitMiliSec(this.transition_wtime);
            ++x1;
        }
        wbuf.flush();
        wg.dispose();
        bbuf.flush();
        bg.dispose();
        g.drawImage(img2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void EffectMosaic(Graphics g, Image img1, Image img2) {
        Graphics wg;
        VolatileImage wimg;
        int fh;
        int fw;
        int iw = this.width;
        int ih = this.height;
        int f = 2;
        while (f <= 64) {
            fw = iw / f;
            fh = iw / f;
            wimg = this.createVolatileImage(fw, fh);
            wg = wimg.getGraphics();
            wg.drawImage(img1, 0, 0, fw, fh, this);
            g.drawImage(wimg, 0, 0, this.getWidth(), this.getHeight(), this);
            wimg.flush();
            wg.dispose();
            this.waitMiliSec(this.transition_wtime);
            f *= 2;
        }
        f = 64;
        while (f > 1) {
            fw = iw / f;
            fh = ih / f;
            wimg = this.createVolatileImage(fw, fh);
            wg = wimg.getGraphics();
            wg.drawImage(img2, 0, 0, fw, fh, this);
            g.drawImage(wimg, 0, 0, this.getWidth(), this.getHeight(), this);
            wimg.flush();
            wg.dispose();
            this.waitMiliSec(this.transition_wtime);
            f /= 2;
        }
        g.drawImage(img2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void EffectWipe(Graphics g, Image img1, Image img2, int STEP) {
        int iw = this.width;
        int ih = this.height;
        VolatileImage bbuf = this.createVolatileImage(iw, ih);
        Graphics bg = bbuf.getGraphics();
        int p = iw / STEP;
        Image bbuf2 = this.createImage(iw, ih);
        Graphics bg2 = bbuf2.getGraphics();
        bg2.drawImage(img1, 0, 0, this);
        int i = 0;
        while (i < iw) {
            bg.drawImage(img2, 0, 0, this);
            bg.drawImage(bbuf2, i, 0, this);
            g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
            bg2.copyArea(p, 0, iw - i, ih, -p, 0);
            this.waitMiliSec(this.transition_wtime);
            i += p;
        }
        bbuf.flush();
        bg.dispose();
        g.drawImage(img2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void EffectZoomin(Graphics g, Image img1, Image img2, int STEP) {
        int iw = this.getWidth();
        int ih = this.getHeight();
        int i = 0;
        while (i < STEP) {
            int w = iw * i / STEP;
            int h = ih * i / STEP;
            int x = (iw - w) / 2;
            int y = (ih - h) / 2;
            g.drawImage(img2, x, y, w, h, this);
            this.waitMiliSec(this.transition_wtime);
            i += i / 10 + 1;
        }
        g.drawImage(img2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void EffectBook(Graphics g, Image img1, Image img2, int mode, int STEP) {
        int iw = this.width;
        int ih = this.height;
        int hw = iw / 2;
        int dx = iw / STEP;
        VolatileImage bbuf = this.createVolatileImage(iw, ih);
        Graphics bg = bbuf.getGraphics();
        VolatileImage left1 = this.createVolatileImage(hw, ih);
        Graphics bk = left1.getGraphics();
        bk.drawImage(img1, 0, 0, this);
        VolatileImage right1 = this.createVolatileImage(hw, ih);
        bk = right1.getGraphics();
        bk.drawImage(img1, -hw, 0, this);
        VolatileImage left2 = this.createVolatileImage(hw, ih);
        bk = left2.getGraphics();
        bk.drawImage(img2, 0, 0, this);
        VolatileImage right2 = this.createVolatileImage(hw, ih);
        bk = right2.getGraphics();
        bk.drawImage(img2, -hw, 0, this);
        bk.dispose();
        if (mode == 0) {
            int x = 0;
            while (x < hw) {
                bg.drawImage(left1, 0, 0, this);
                bg.drawImage(right2, hw, 0, this);
                bg.drawImage(right1, hw, 0, hw - x, ih, this);
                g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
                this.waitMiliSec(this.transition_wtime);
                x += dx;
            }
            x = 0;
            while (x < hw) {
                bg.drawImage(left1, 0, 0, this);
                bg.drawImage(right2, hw, 0, this);
                bg.drawImage(left2, hw - x, 0, x, ih, this);
                g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
                this.waitMiliSec(this.transition_wtime);
                x += dx;
            }
        } else {
            int x = hw;
            while (x > 0) {
                bg.drawImage(left2, 0, 0, this);
                bg.drawImage(right1, hw, 0, this);
                bg.drawImage(left1, hw - x, 0, x, ih, this);
                g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
                this.waitMiliSec(this.transition_wtime);
                x -= dx;
            }
            x = hw;
            while (x > 0) {
                bg.drawImage(left2, 0, 0, this);
                bg.drawImage(right1, hw, 0, this);
                bg.drawImage(right2, hw, 0, hw - x, ih, this);
                g.drawImage(bbuf, 0, 0, this.getWidth(), this.getHeight(), this);
                this.waitMiliSec(this.transition_wtime);
                x -= dx;
            }
        }
        left1.flush();
        left2.flush();
        right1.flush();
        right2.flush();
        bbuf.flush();
        bg.dispose();
        g.drawImage(img2, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    @Override
    public void run() {
        this.waitMiliSec(100);
    }

    public void waitMiliSec(int w) {
        try {
            Thread.sleep(w);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.busy) {
            return;
        }
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.disp_buf01, 0, 0, this.getWidth(), this.getHeight(), this);
    }
}

