/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.hibernate.logger;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.type.Type;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.hibernate.logger.LogCriteria;
import org.asyrinx.brownie.hibernate.logger.LogQuery;
import org.asyrinx.brownie.hibernate.logger.LogSessionFactory;
import org.asyrinx.brownie.hibernate.logger.LogTransaction;
import org.asyrinx.brownie.hibernate.wrapper.SessionWrapper;

public class LogSession
extends SessionWrapper {
    protected final CascadeNamedLog log;

    public LogSession(Session wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(wrapped);
    }

    public Transaction beginTransaction() throws HibernateException {
        this.log.log("beginTransaction()");
        return new LogTransaction(super.beginTransaction(), this.log);
    }

    public void cancelQuery() throws HibernateException {
        this.log.log("cancelQuery()");
        super.cancelQuery();
    }

    public void clear() {
        this.log.log("clear()");
        super.clear();
    }

    public Connection close() throws HibernateException {
        this.log.log("close()");
        return super.close();
    }

    public Connection connection() throws HibernateException {
        this.log.log("connection()");
        return super.connection();
    }

    public boolean contains(Object object) {
        this.log.log("contains(" + object + ")");
        return super.contains(object);
    }

    public Criteria createCriteria(Class persistentClass) {
        this.log.log("createCriteria(" + persistentClass + ")");
        return new LogCriteria(super.createCriteria(persistentClass), this.log);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        this.log.log("createFilter(" + collection + ", " + queryString + ")");
        return new LogQuery(super.createFilter(collection, queryString), this.log);
    }

    public Query createQuery(String queryString) throws HibernateException {
        this.log.log("createQuery(" + queryString + ")");
        return new LogQuery(super.createQuery(queryString), this.log);
    }

    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        this.log.log("createQuery(" + sql + ", " + returnAlias + ", " + returnClass.getName() + ", " + ")");
        return new LogQuery(super.createSQLQuery(sql, returnAlias, returnClass), this.log);
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        this.log.log("createQuery(" + sql + ", " + returnAliases + ", " + returnClasses + ", " + ")");
        return new LogQuery(super.createSQLQuery(sql, returnAliases, returnClasses), this.log);
    }

    public void delete(Object object) throws HibernateException {
        this.log.log("delete(" + object + ")");
        super.delete(object);
    }

    public int delete(String query, Object value, Type type) throws HibernateException {
        this.log.log("delete(" + query + ", " + value + ", " + type + ")");
        return super.delete(query, value, type);
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        this.log.log("delete(" + query + ", " + values + ", " + types + ")");
        return super.delete(query, values, types);
    }

    public int delete(String query) throws HibernateException {
        this.log.log("delete(" + query + ")");
        return super.delete(query);
    }

    public Connection disconnect() throws HibernateException {
        this.log.log("disconnect()");
        return super.disconnect();
    }

    public void evict(Object object) throws HibernateException {
        this.log.log("evict(" + object + ")");
        super.evict(object);
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        this.log.log("filter(" + collection + ", " + filter + ", " + value + ", " + type + ")");
        return super.filter(collection, filter, value, type);
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        this.log.log("filter(" + collection + ", " + filter + ", " + values + ", " + types + ")");
        return super.filter(collection, filter, values, types);
    }

    public Collection filter(Object collection, String filter) throws HibernateException {
        this.log.log("filter(" + collection + ", " + filter + ")");
        return super.filter(collection, filter);
    }

    public List find(String query, Object value, Type type) throws HibernateException {
        this.log.log("find(" + query + ", " + value + ", " + type + ")");
        return super.find(query, value, type);
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        this.log.log("find(" + query + ", " + values + ", " + types + ")");
        return super.find(query, values, types);
    }

    public List find(String query) throws HibernateException {
        this.log.log("find(" + query + ")");
        return super.find(query);
    }

    public void flush() throws HibernateException {
        this.log.log("flush()");
        super.flush();
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        this.log.log("get(" + clazz + "," + id + "," + lockMode + ")");
        return super.get(clazz, id, lockMode);
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        this.log.log("get(" + clazz + "," + id + ")");
        return super.get(clazz, id);
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return super.getCurrentLockMode(object);
    }

    public FlushMode getFlushMode() {
        return super.getFlushMode();
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        this.log.log("getIdentifier(" + object + ")");
        return super.getIdentifier(object);
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        this.log.log("getNamedQuery(" + queryName + ")");
        return new LogQuery(super.getNamedQuery(queryName), this.log);
    }

    public SessionFactory getSessionFactory() {
        this.log.log("getSessionFactory()");
        return new LogSessionFactory(super.getSessionFactory(), this.log);
    }

    public boolean isConnected() {
        return super.isConnected();
    }

    public boolean isOpen() {
        return super.isOpen();
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        return super.iterate(query, value, type);
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        return super.iterate(query, values, types);
    }

    public Iterator iterate(String query) throws HibernateException {
        return super.iterate(query);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        this.log.log("load(" + theClass + ", " + id + ", " + lockMode + ")");
        return super.load(theClass, id, lockMode);
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        this.log.log("load(" + theClass + ", " + id + ")");
        return super.load(theClass, id);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        this.log.log("load(" + object + ", " + id + ")");
        super.load(object, id);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.log.log("lock(" + object + ", " + lockMode + ")");
        super.lock(object, lockMode);
    }

    public void reconnect() throws HibernateException {
        this.log.log("reconnect()");
        super.reconnect();
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.log.log("reconnect(" + connection + ")");
        super.reconnect(connection);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.log.log("refresh(" + object + ", " + lockMode + ")");
        super.refresh(object, lockMode);
    }

    public void refresh(Object object) throws HibernateException {
        this.log.log("refresh(" + object + ")");
        super.refresh(object);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.log.log("replicate(" + object + ", " + replicationMode + ")");
        super.replicate(object, replicationMode);
    }

    public void save(Object object, Serializable id) throws HibernateException {
        this.log.log("save(" + object + ", " + id + ")");
        super.save(object, id);
    }

    public Serializable save(Object object) throws HibernateException {
        this.log.log("save(" + object + ")");
        return super.save(object);
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.log.log("saveOrUpdate(" + object + ")");
        super.saveOrUpdate(object);
    }

    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        this.log.log("saveOrUpdateCopy(" + object + ", " + id + ")");
        return super.saveOrUpdateCopy(object, id);
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        this.log.log("saveOrUpdateCopy(" + object + ")");
        return super.saveOrUpdateCopy(object);
    }

    public void setFlushMode(FlushMode flushMode) {
        this.log.log("setFlushMode(" + flushMode + ")");
        super.setFlushMode(flushMode);
    }

    public void update(Object object, Serializable id) throws HibernateException {
        this.log.log("update(" + object + ", " + id + ")");
        super.update(object, id);
    }

    public void update(Object object) throws HibernateException {
        this.log.log("update(" + object + ")");
        super.update(object);
    }
}

