/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util.jp;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.util.Era;
import org.asyrinx.brownie.core.util.SimpleDate;
import org.asyrinx.brownie.core.util.jp.JpEra;
import org.asyrinx.brownie.core.util.jp.JpEraPattern;
import org.asyrinx.brownie.core.util.jp.JpPattern;

public class JpDateFormat
extends DateFormat {
    private String pattern;
    private DateFormatSymbols dateFormatSymbols;
    public static final JpEraPattern ERA_ALPH_SHORT = new JpEraPattern("je"){

        public boolean needSingleQuote() {
            return true;
        }

        protected String toEraStr(Era era) {
            return era.getFirstLetter();
        }
    };
    public static final JpEraPattern ERA_KANJI_SHORT = new JpEraPattern("jE"){

        public boolean needSingleQuote() {
            return true;
        }

        protected String toEraStr(Era era) {
            return era.getCaptionShort();
        }
    };
    public static final JpEraPattern ERA_KANJI_LONG = new JpEraPattern("jEE"){

        public boolean needSingleQuote() {
            return true;
        }

        protected String toEraStr(Era era) {
            return era.getCaption();
        }
    };
    public static final JpPattern YEAR_NUMERIC = new JpPattern("jyy"){

        public String newString(Era era, Date d) {
            return String.valueOf(JpEra.ERA_GROUP.getEraYear(new SimpleDate(d)));
        }

        public boolean needSingleQuote() {
            return false;
        }
    };
    private static JpPattern[] PATTERNS = new JpPattern[]{ERA_ALPH_SHORT, ERA_KANJI_LONG, ERA_KANJI_SHORT, YEAR_NUMERIC};
    private static JpEraPattern[] PATTERNS_ERA = new JpEraPattern[]{ERA_ALPH_SHORT, ERA_KANJI_LONG, ERA_KANJI_SHORT};
    private static JpPattern[] PATTERNS_YEAR = new JpPattern[]{YEAR_NUMERIC};

    public JpDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public JpDateFormat(String pattern, Locale locale) {
        this(pattern, new DateFormatSymbols(locale));
    }

    public JpDateFormat(String pattern, DateFormatSymbols dateFormatSymbols) {
        this.pattern = pattern;
        this.dateFormatSymbols = dateFormatSymbols;
    }

    public String toPattern() {
        return this.pattern;
    }

    public void applyPattern(String pattern) {
        this.pattern = pattern;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.dateFormatSymbols;
    }

    public void setDateFormatSymbols(DateFormatSymbols symbols) {
        this.dateFormatSymbols = symbols;
    }

    private DateFormat newDateFormat(String pattern) {
        return new SimpleDateFormat(pattern, this.dateFormatSymbols);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        if (date == null) {
            throw new NullPointerException("failed to format. date was null.");
        }
        Era era = JpEra.ERA_GROUP.getEra(new SimpleDate(date));
        StringBuffer patternBuf = new StringBuffer(this.toPattern());
        int i = 0;
        while (i < PATTERNS.length) {
            JpPattern jpPattern = PATTERNS[i];
            if (jpPattern.contained(patternBuf.toString())) {
                jpPattern.format(patternBuf, era, date);
            }
            ++i;
        }
        DateFormat innerFormat = this.newDateFormat(patternBuf.toString());
        return innerFormat.format(date, toAppendTo, pos);
    }

    public Date parse(String text, ParsePosition pos) {
        StringBuffer patternBuf = new StringBuffer(this.toPattern());
        StringBuffer textBuf = new StringBuffer(text);
        JpEraPattern eraPattern = this.findEraPattern(this.toPattern(), pos.getIndex());
        Era era = eraPattern == null ? null : eraPattern.findEra(textBuf, patternBuf, pos.getIndex());
        int i = 0;
        while (i < PATTERNS_YEAR.length) {
            StringUtils.replace(patternBuf, JpDateFormat.PATTERNS_YEAR[i].pattern, "yyyy");
            ++i;
        }
        DateFormat innerFormat = this.newDateFormat(patternBuf.toString());
        Calendar cal = Calendar.getInstance();
        cal.set(1, 0);
        Date superResult = innerFormat.parse(textBuf.toString(), pos);
        if (superResult != null) {
            cal.setTime(superResult);
        }
        if (era != null) {
            cal.set(1, era.toAnnoDomini(cal.get(1)));
        }
        return cal.getTime();
    }

    private JpEraPattern findEraPattern(String text, int position) {
        int i = 0;
        while (i < PATTERNS_ERA.length) {
            JpEraPattern pattern = PATTERNS_ERA[i];
            int pos = text.indexOf(pattern.pattern, position);
            if (pos > -1) {
                return PATTERNS_ERA[i];
            }
            ++i;
        }
        return null;
    }
}

