/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.collection.CollectionSqueezer;
import org.asyrinx.brownie.core.util.Era;
import org.asyrinx.brownie.core.util.LocaleDateFilter;
import org.asyrinx.brownie.core.util.LocaleFilter;
import org.asyrinx.brownie.core.util.SimpleDate;

public class EraGroup {
    private final Set eras = new HashSet();

    public boolean add(Era era) {
        return this.eras.add(era);
    }

    public void clear() {
        this.eras.clear();
    }

    public boolean contains(Era era) {
        return this.eras.contains(era);
    }

    public boolean containsAll(Collection c) {
        return this.eras.containsAll(c);
    }

    public boolean isEmpty() {
        return this.eras.isEmpty();
    }

    public Iterator iterator() {
        return this.eras.iterator();
    }

    public boolean remove(Era era) {
        return this.eras.remove(era);
    }

    public int size() {
        return this.eras.size();
    }

    public String toString() {
        return this.eras.toString();
    }

    public Era getEra(SimpleDate d) {
        return this.getEra(Locale.getDefault(), d);
    }

    public Era findByCaptions(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        Iterator iterator = this.eras.iterator();
        while (iterator.hasNext()) {
            Era era = (Era)iterator.next();
            if (!era.equals(str)) continue;
            return era;
        }
        return null;
    }

    public Era getEra(Locale locale, SimpleDate d) {
        if (d == null) {
            return null;
        }
        Iterator iterator = this.eras.iterator();
        LocaleDateFilter filter = new LocaleDateFilter(locale, d);
        while (iterator.hasNext()) {
            Era era = (Era)iterator.next();
            if (!filter.evaluate(era)) continue;
            return era;
        }
        return null;
    }

    public Set getEras(Locale locale) {
        HashSet result = new HashSet();
        CollectionSqueezer squeezer = new CollectionSqueezer(new LocaleFilter(locale));
        squeezer.execute(this.eras.iterator(), result);
        return result;
    }

    public int getEraYear(SimpleDate d) {
        Era era = this.getEra(d);
        return era == null ? d.getYear() : era.getYearAt(d);
    }

    public int getEraYear(Locale locale, SimpleDate d) {
        Era era = this.getEra(locale, d);
        return era == null ? d.getYear() : era.getYearAt(d);
    }
}

