/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class TorqueSQLExec
extends Task {
    private int goodSql = 0;
    private int totalSql = 0;
    private Path classpath;
    private AntClassLoader loader;
    private Connection conn = null;
    private boolean autocommit = false;
    private Statement statement = null;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private String sqlCommand = "";
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private File output = null;
    private String rdbms = null;
    private String version = null;
    private String onError = "abort";
    private String encoding = null;
    private String srcDir;
    private File sqldbmap;

    public void setSqlDbMap(String sqldbmap) {
        this.sqldbmap = ((ProjectComponent)this).project.resolveFile(sqldbmap);
    }

    public File getSqlDbMap() {
        return this.sqldbmap;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = ((ProjectComponent)this).project.resolveFile(srcDir).toString();
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand + sql;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserid(String userId) {
        this.userId = userId;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setShowheaders(boolean showheaders) {
        this.showheaders = showheaders;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setRdbms(String vendor) {
        this.rdbms = vendor.toLowerCase();
    }

    public void setVersion(String version) {
        this.version = version.toLowerCase();
    }

    public void setOnerror(OnError action) {
        this.onError = action.getValue();
    }

    public void execute() throws BuildException {
        this.sqlCommand = this.sqlCommand.trim();
        if (this.sqldbmap == null || !this.getSqlDbMap().exists()) {
            throw new BuildException("You haven't provided an sqldbmap, or the one you specified doesn't exist: " + this.sqldbmap);
        }
        if (this.driver == null) {
            throw new BuildException("Driver attribute must be set!", this.location);
        }
        if (this.userId == null) {
            throw new BuildException("User Id attribute must be set!", this.location);
        }
        if (this.password == null) {
            throw new BuildException("Password attribute must be set!", this.location);
        }
        if (this.url == null) {
            throw new BuildException("Url attribute must be set!", this.location);
        }
        Properties map = new Properties();
        try {
            FileInputStream fis = new FileInputStream(this.getSqlDbMap());
            map.load(fis);
            fis.close();
        }
        catch (IOException ioe) {
            throw new BuildException("Cannot open and process the sqldbmap!");
        }
        HashMap databases = new HashMap();
        Iterator<Object> eachFileName = ((Hashtable)map).keySet().iterator();
        while (eachFileName.hasNext()) {
            String sqlfile = (String)eachFileName.next();
            String database = map.getProperty(sqlfile);
            ArrayList<String> files = (ArrayList<String>)databases.get(database);
            if (files == null) {
                files = new ArrayList<String>();
                databases.put(database, files);
            }
            if (sqlfile.indexOf("schema.sql") != -1) {
                files.add(0, sqlfile);
                continue;
            }
            files.add(sqlfile);
        }
        Iterator eachDatabase = databases.keySet().iterator();
        while (eachDatabase.hasNext()) {
            String db = (String)eachDatabase.next();
            ArrayList<Transaction> transactions = new ArrayList<Transaction>();
            eachFileName = ((List)databases.get(db)).iterator();
            while (eachFileName.hasNext()) {
                String fileName = (String)eachFileName.next();
                File file = new File(this.srcDir, fileName);
                if (file.exists()) {
                    Transaction transaction = new Transaction();
                    transaction.setSrc(file);
                    transactions.add(transaction);
                    continue;
                }
                super.log("File '" + fileName + "' in sqldbmap does not exist, so skipping it.");
            }
            this.insertDatabaseSqlFiles(this.url, db, transactions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertDatabaseSqlFiles(String url, String database, List transactions) {
        block31: {
            block30: {
                url = StringUtils.replace((String)url, (String)"@DB@", (String)database);
                System.out.println("Our new url -> " + url);
                driverInstance = null;
                try {
                    if (this.classpath != null) {
                        this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                        this.loader = new AntClassLoader(this.project, this.classpath);
                        dc = this.loader.loadClass(this.driver);
                    } else {
                        this.log("Loading " + this.driver + " using system loader.", 3);
                        dc = Class.forName(this.driver);
                    }
                    driverInstance = (Driver)dc.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                catch (IllegalAccessException e) {
                    throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                catch (InstantiationException e) {
                    throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                try {
                    try {
                        this.log("connecting to " + url, 3);
                        info = new Properties();
                        info.put("user", this.userId);
                        info.put("password", this.password);
                        this.conn = driverInstance.connect(url, info);
                        if (this.conn == null) {
                            throw new SQLException("No suitable Driver for " + url);
                        }
                        if (!this.isValidRdbms(this.conn)) {
                            var11_11 = null;
                            break block30;
                        }
                        this.conn.setAutoCommit(this.autocommit);
                        this.statement = this.conn.createStatement();
                        out = System.out;
                        try {
                            if (this.output != null) {
                                this.log("Opening PrintStream to output file " + this.output, 3);
                                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output)));
                            }
                            it = transactions.iterator();
                            while (it.hasNext()) {
                                Transaction.access$000((Transaction)it.next(), out);
                                if (this.autocommit) continue;
                                this.log("Commiting transaction", 3);
                                this.conn.commit();
                            }
                            var9_21 = null;
                            if (out != null && out != System.out) {
                                out.close();
                            }
                            break block31;
                        }
                        catch (Throwable var8_23) {
                            var9_22 = null;
                            if (out == null) throw var8_23;
                            if (out == System.out) throw var8_23;
                            out.close();
                            throw var8_23;
                        }
                    }
                    catch (IOException e) {
                        if (this.autocommit != false) throw new BuildException((Throwable)e, this.location);
                        if (this.conn == null) throw new BuildException((Throwable)e, this.location);
                        if (this.onError.equals("abort") == false) throw new BuildException((Throwable)e, this.location);
                        try {
                            this.conn.rollback();
                            throw new BuildException((Throwable)e, this.location);
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        throw new BuildException((Throwable)e, this.location);
                    }
                    catch (SQLException e) {
                        if (this.autocommit != false) throw new BuildException((Throwable)e, this.location);
                        if (this.conn == null) throw new BuildException((Throwable)e, this.location);
                        if (this.onError.equals("abort") == false) throw new BuildException((Throwable)e, this.location);
                        try {
                            this.conn.rollback();
                            throw new BuildException((Throwable)e, this.location);
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        throw new BuildException((Throwable)e, this.location);
                    }
                }
                catch (Throwable var10_24) {
                    var11_13 = null;
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                        if (this.conn == null) throw var10_24;
                        this.conn.close();
                        throw var10_24;
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    throw var10_24;
                }
            }
            ** try [egrp 6[TRYBLOCK] [14 : 729->764)] { 
lbl94:
            // 1 sources

            if (this.statement != null) {
                this.statement.close();
            }
            if (this.conn == null) return;
            this.conn.close();
            return;
lbl99:
            // 1 sources

            catch (SQLException e) {
                // empty catch block
            }
            return;
        }
        var11_12 = null;
        try {}
        catch (SQLException e) {}
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
        this.log(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully");
    }

    protected void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        String sql = "";
        String line = "";
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            line = line.trim();
            if ((line = ProjectHelper.replaceProperties((Project)((ProjectComponent)this).project, (String)line, (Hashtable)((ProjectComponent)this).project.getProperties())).startsWith("//") || line.startsWith("--") || line.length() > 4 && line.substring(0, 4).equalsIgnoreCase("REM ")) continue;
            sql = sql + " " + line;
            sql = sql.trim();
            if (line.indexOf("--") >= 0) {
                sql = sql + "\n";
            }
            if ((!this.delimiterType.equals("normal") || !sql.endsWith(this.delimiter)) && (!this.delimiterType.equals("row") || !line.equals(this.delimiter))) continue;
            this.log("SQL: " + sql, 3);
            this.execSQL(sql.substring(0, sql.length() - this.delimiter.length()), out);
            sql = "";
        }
        if (!sql.equals("")) {
            this.execSQL(sql, out);
        }
    }

    protected boolean isValidRdbms(Connection conn) {
        if (this.rdbms == null && this.version == null) {
            return true;
        }
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            if (this.rdbms != null) {
                String theVendor = dmd.getDatabaseProductName().toLowerCase();
                this.log("RDBMS = " + theVendor, 3);
                if (theVendor == null || theVendor.indexOf(this.rdbms) < 0) {
                    this.log("Not the required RDBMS: " + this.rdbms, 3);
                    return false;
                }
            }
            if (this.version != null) {
                String theVersion = dmd.getDatabaseProductVersion().toLowerCase();
                this.log("Version = " + theVersion, 3);
                if (theVersion == null || !theVersion.startsWith(this.version) && theVersion.indexOf(" " + this.version) < 0) {
                    this.log("Not the required version: \"" + this.version + "\"", 3);
                    return false;
                }
            }
        }
        catch (SQLException e) {
            this.log("Failed to obtain required RDBMS information", 0);
            return false;
        }
        return true;
    }

    protected void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        try {
            ++this.totalSql;
            if (!this.statement.execute(sql)) {
                this.log(this.statement.getUpdateCount() + " rows affected", 3);
            } else if (this.print) {
                this.printResults(out);
            }
            for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.log(warning + " sql warning", 3);
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException e) {
            this.log("Failed to execute: " + sql, 0);
            if (!this.onError.equals("continue")) {
                throw e;
            }
            this.log(e.toString(), 0);
        }
    }

    protected void printResults(PrintStream out) throws SQLException {
        ResultSet rs = null;
        do {
            if ((rs = this.statement.getResultSet()) == null) continue;
            this.log("Processing new result set.", 3);
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            StringBuffer line = new StringBuffer();
            if (this.showheaders) {
                for (int col = 1; col < columnCount; ++col) {
                    line.append(md.getColumnName(col));
                    line.append(",");
                }
                line.append(md.getColumnName(columnCount));
                out.println(line);
                line.setLength(0);
            }
            while (rs.next()) {
                boolean first = true;
                for (int col = 1; col <= columnCount; ++col) {
                    String columnValue = rs.getString(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(",");
                    }
                    line.append(columnValue);
                }
                out.println(line);
                line.setLength(0);
            }
        } while (this.statement.getMoreResults());
        out.println();
    }

    public class Transaction {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        public void setSrc(File src) {
            this.tSrcFile = src;
        }

        public void addText(String sql) {
            this.tSqlCommand = this.tSqlCommand + sql;
        }

        private void runTransaction(PrintStream out) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                TorqueSQLExec.this.log("Executing commands", 2);
                TorqueSQLExec.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcFile != null) {
                TorqueSQLExec.this.log("Executing file: " + this.tSrcFile.getAbsolutePath(), 2);
                InputStreamReader reader = TorqueSQLExec.this.encoding == null ? new FileReader(this.tSrcFile) : new InputStreamReader((InputStream)new FileInputStream(this.tSrcFile), TorqueSQLExec.this.encoding);
                TorqueSQLExec.this.runStatements(reader, out);
                ((Reader)reader).close();
            }
        }

        static /* synthetic */ void access$000(Transaction x0, PrintStream x1) throws IOException, SQLException {
            x0.runTransaction(x1);
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }

    public static class DelimiterType
    extends EnumeratedAttribute {
        public static final String NORMAL = "normal";
        public static final String ROW = "row";

        public String[] getValues() {
            return new String[]{NORMAL, ROW};
        }
    }
}

