/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Table;
import org.xml.sax.Attributes;

public class ForeignKey {
    private String foreignTableName;
    private String name;
    private String onUpdate;
    private String onDelete;
    private Table parentTable;
    private List localColumns = new ArrayList(3);
    private List foreignColumns = new ArrayList(3);
    private static final String NONE = "NONE";
    private static final String SETNULL = "SETNULL";

    public void loadFromXML(Attributes attrib) {
        this.foreignTableName = attrib.getValue("foreignTable");
        this.name = attrib.getValue("name");
        this.onUpdate = attrib.getValue("onUpdate");
        this.onDelete = attrib.getValue("onDelete");
        this.onUpdate = this.normalizeFKey(this.onUpdate);
        this.onDelete = this.normalizeFKey(this.onDelete);
    }

    private String normalizeFKey(String attrib) {
        if (attrib == null) {
            attrib = NONE;
        }
        if ((attrib = attrib.toUpperCase()).equals(SETNULL)) {
            attrib = "SET NULL";
        }
        return attrib;
    }

    public boolean hasOnUpdate() {
        return !this.onUpdate.equals(NONE);
    }

    public boolean hasOnDelete() {
        return !this.onDelete.equals(NONE);
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    public void setOnDelete(String value) {
        this.onDelete = this.normalizeFKey(value);
    }

    public void setOnUpdate(String value) {
        this.onUpdate = this.normalizeFKey(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getForeignTableName() {
        return this.foreignTableName;
    }

    public void setForeignTableName(String tableName) {
        this.foreignTableName = tableName;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public void addReference(Attributes attrib) {
        this.addReference(attrib.getValue("local"), attrib.getValue("foreign"));
    }

    public void addReference(String local, String foreign) {
        this.localColumns.add(local);
        this.foreignColumns.add(foreign);
    }

    public String getLocalColumnNames() {
        return Column.makeList(this.getLocalColumns());
    }

    public String getForeignColumnNames() {
        return Column.makeList(this.getForeignColumns());
    }

    public List getLocalColumns() {
        return this.localColumns;
    }

    public Hashtable getLocalForeignMapping() {
        Hashtable h = new Hashtable();
        for (int i = 0; i < this.localColumns.size(); ++i) {
            h.put(this.localColumns.get(i), this.foreignColumns.get(i));
        }
        return h;
    }

    public List getForeignColumns() {
        return this.foreignColumns;
    }

    public Hashtable getForeignLocalMapping() {
        Hashtable h = new Hashtable();
        for (int i = 0; i < this.localColumns.size(); ++i) {
            h.put(this.foreignColumns.get(i), this.localColumns.get(i));
        }
        return h;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("    <foreign-key foreignTable=\"").append(this.getForeignTableName()).append("\" name=\"").append(this.getName()).append("\">\n");
        for (int i = 0; i < this.localColumns.size(); ++i) {
            result.append("        <reference local=\"").append(this.localColumns.get(i)).append("\" foreign=\"").append(this.foreignColumns.get(i)).append("\"/>\n");
        }
        result.append("    </foreign-key>\n");
        return result.toString();
    }
}

