/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Table;
import org.xml.sax.Attributes;

public class Database {
    private String databaseType = null;
    private List tableList = new ArrayList(100);
    private String name;
    private String pkg;
    private String baseClass;
    private String basePeer;
    private String defaultIdMethod;
    private String defaultJavaType;
    private String defaultJavaNamingMethod;
    private AppData dbParent;
    private Hashtable tablesByName = new Hashtable();
    private Hashtable tablesByJavaName = new Hashtable();
    private boolean heavyIndexing;

    public void loadFromXML(Attributes attrib) {
        this.setName(attrib.getValue("name"));
        this.pkg = attrib.getValue("package");
        this.baseClass = attrib.getValue("baseClass");
        this.basePeer = attrib.getValue("basePeer");
        this.defaultJavaType = attrib.getValue("defaultJavaType");
        this.defaultIdMethod = attrib.getValue("defaultIdMethod");
        this.defaultJavaNamingMethod = attrib.getValue("defaultJavaNamingMethod");
        if (this.defaultJavaNamingMethod == null) {
            this.defaultJavaNamingMethod = "underscore";
        }
        this.heavyIndexing = "true".equals(attrib.getValue("heavyIndexing"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "default" : name;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String v) {
        this.pkg = v;
    }

    public String getBaseClass() {
        if (this.baseClass == null) {
            return "BaseObject";
        }
        return this.baseClass;
    }

    public void setBaseClass(String v) {
        this.baseClass = v;
    }

    public String getBasePeer() {
        if (this.basePeer == null) {
            return "BasePeer";
        }
        return this.basePeer;
    }

    public void setBasePeer(String v) {
        this.basePeer = v;
    }

    public String getDefaultIdMethod() {
        return this.defaultIdMethod;
    }

    public void setDefaultIdMethod(String v) {
        this.defaultIdMethod = v;
    }

    public String getDefaultJavaType() {
        return this.defaultJavaType;
    }

    public String getDefaultJavaNamingMethod() {
        return this.defaultJavaNamingMethod;
    }

    public void setDefaultJavaNamingMethod(String v) {
        this.defaultJavaNamingMethod = v;
    }

    public boolean isHeavyIndexing() {
        return this.heavyIndexing;
    }

    public void setHeavyIndexing(boolean v) {
        this.heavyIndexing = v;
    }

    public Table[] getTables() {
        int size = this.tableList.size();
        Table[] tbls = new Table[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = (Table)this.tableList.get(i);
        }
        return tbls;
    }

    public Table getTable(String name) {
        return (Table)this.tablesByName.get(name);
    }

    public Table getTableByJavaName(String javaName) {
        return (Table)this.tablesByJavaName.get(javaName);
    }

    public Table addTable(Attributes attrib) {
        Table tbl = new Table();
        tbl.setDatabase(this);
        tbl.loadFromXML(attrib, this.getDefaultIdMethod());
        this.addTable(tbl);
        return tbl;
    }

    public void addTable(Table tbl) {
        tbl.setDatabase(this);
        this.tableList.add(tbl);
        this.tablesByName.put(tbl.getName(), tbl);
        this.tablesByJavaName.put(tbl.getJavaName(), tbl);
        tbl.setPackage(this.getPackage());
    }

    public void setAppData(AppData parent) {
        this.dbParent = parent;
    }

    public AppData getAppData() {
        return this.dbParent;
    }

    protected String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    protected String getProperty(String name) throws EngineException {
        Properties p = this.getAppData().getIdiosyncrasies(this.databaseType);
        return p == null ? null : p.getProperty(name);
    }

    public boolean requiresIdTable() {
        Table[] table = this.getTables();
        for (int i = 0; i < table.length; ++i) {
            if (!table[i].getIdMethod().equals("idbroker")) continue;
            return true;
        }
        return false;
    }

    public void doFinalInitialization() throws EngineException {
        Table[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table currTable = tables[i];
            if (currTable.getIdMethod().equals("autoincrement")) {
                Column[] columns = currTable.getColumns();
                boolean foundOne = false;
                for (int j = 0; j < columns.length && !foundOne; ++j) {
                    foundOne = columns[j].isAutoIncrement();
                }
                if (!foundOne) {
                    String errorMessage = "Table '" + currTable.getName() + "' is marked as autoincrement, but it does not " + "have a column which declared as the one to " + "auto increment (i.e. autoIncrement=\"true\")\n";
                    throw new EngineException("Error in XML schema: " + errorMessage);
                }
            }
            currTable.doFinalInitialization();
            ForeignKey[] fks = currTable.getForeignKeys();
            for (int j = 0; j < fks.length; ++j) {
                ForeignKey currFK = fks[j];
                Table foreignTable = this.getTable(currFK.getForeignTableName());
                if (foreignTable == null) {
                    throw new EngineException("Attempt to set foreign key to nonexistent table, " + currFK.getForeignTableName());
                }
                List referrers = foreignTable.getReferrers();
                if (referrers == null || !referrers.contains(currFK)) {
                    foreignTable.addReferrer(currFK);
                }
                Iterator localColumnNames = currFK.getLocalColumns().iterator();
                while (localColumnNames.hasNext()) {
                    Column local = currTable.getColumn((String)localColumnNames.next());
                    if (local == null) {
                        throw new EngineException("Attempt to define foreign key with nonexistent column in table, " + currTable.getName());
                    }
                    if (!local.isPrimaryKey()) continue;
                    currTable.setContainsForeignPK(true);
                }
                Iterator foreignColumnNames = currFK.getForeignColumns().iterator();
                while (foreignColumnNames.hasNext()) {
                    String foreignColumnName = (String)foreignColumnNames.next();
                    Column foreign = foreignTable.getColumn(foreignColumnName);
                    if (foreign == null) {
                        throw new EngineException("Attempt to set foreign key to nonexistent column: table=" + currTable.getName() + ", foreign column=" + foreignColumnName);
                    }
                    foreign.addReferrer(currFK);
                }
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<database name=\"").append(this.getName()).append('\"').append(" package=\"").append(this.getPackage()).append('\"').append(" defaultIdMethod=\"").append(this.getDefaultIdMethod()).append('\"').append(" baseClass=\"").append(this.getBaseClass()).append('\"').append(" basePeer=\"").append(this.getBasePeer()).append('\"').append(">\n");
        Iterator i = this.tableList.iterator();
        while (i.hasNext()) {
            result.append(i.next());
        }
        result.append("</database>");
        return result.toString();
    }
}

