/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.FileSet;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.transform.XmlToAppData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.ant.TexenTask;

public class BaseJoeyDataModelTask
extends TexenTask {
    protected String xmlFile;
    protected final List filesets = new ArrayList();
    protected final List dataModels = new ArrayList();
    protected Context context;
    protected Hashtable dataModelDbMap;
    protected Hashtable databaseNames;
    protected String sqldbmap;
    private String basePathToDbProps;
    private String targetDatabase;
    private String targetPackage;

    public void setSqlDbMap(String sqldbmap) {
        this.sqldbmap = ((ProjectComponent)this).project.resolveFile(sqldbmap).toString();
    }

    public String getSqlDbMap() {
        return this.sqldbmap;
    }

    public List getDataModels() {
        return this.dataModels;
    }

    public Hashtable getDataModelDbMap() {
        return this.dataModelDbMap;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.xmlFile = ((ProjectComponent)this).project.resolveFile(xmlFile).toString();
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public void setTargetDatabase(String v) {
        this.targetDatabase = v;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public void setTargetPackage(String v) {
        this.targetPackage = v;
    }

    public String getBasePathToDbProps() {
        return this.basePathToDbProps;
    }

    public void setBasePathToDbProps(String v) {
        this.basePathToDbProps = v;
    }

    public Context initControlContext() throws Exception {
        if (this.xmlFile == null && this.filesets.isEmpty()) {
            throw new BuildException("You must specify an XML schema or fileset of XML schemas!");
        }
        try {
            if (this.xmlFile != null) {
                this.addNewAppData(this.xmlFile);
            } else {
                int i = 0;
                while (i < this.filesets.size()) {
                    FileSet fs = (FileSet)this.filesets.get(i);
                    DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
                    File srcDir = fs.getDir(((ProjectComponent)this).project);
                    String[] dataModelFiles = ds.getIncludedFiles();
                    int j = 0;
                    while (j < dataModelFiles.length) {
                        File f = new File(srcDir, dataModelFiles[j]);
                        this.addNewAppData(f.toString());
                        ++j;
                    }
                    ++i;
                }
            }
            Iterator i = this.dataModels.iterator();
            this.databaseNames = new Hashtable();
            this.dataModelDbMap = new Hashtable();
            while (i.hasNext()) {
                AppData ad = (AppData)i.next();
                Database database = ad.getDatabase();
                this.databaseNames.put(database.getName(), database.getName());
                this.dataModelDbMap.put(ad.getName(), database.getName());
            }
        }
        catch (EngineException ee) {
            throw new BuildException((Throwable)ee);
        }
        this.context = new VelocityContext();
        this.context.put("dataModels", (Object)this.dataModels);
        this.context.put("databaseNames", (Object)this.databaseNames);
        this.context.put("targetDatabase", (Object)this.targetDatabase);
        this.context.put("targetPackage", (Object)this.targetPackage);
        return this.context;
    }

    protected void addNewAppData(String fileName) throws EngineException {
        XmlToAppData xmlParser = new XmlToAppData(this.getTargetDatabase(), this.getTargetPackage(), this.getBasePathToDbProps());
        AppData ad = xmlParser.parseFile(fileName);
        ad.setName(this.grokName(fileName));
        this.dataModels.add(ad);
    }

    protected final String grokName(String xmlFile) {
        String name = "data-model";
        int i = xmlFile.lastIndexOf(System.getProperty("file.separator"));
        if (i != -1) {
            int j = xmlFile.lastIndexOf(46);
            name = ++i < j ? xmlFile.substring(i, j) : xmlFile.substring(i);
        }
        return name;
    }

    public void setContextProperties(String file) {
        super.setContextProperties(file);
        Hashtable env = super.getProject().getProperties();
        this.convertProperties(env, "torque.");
        this.convertProperties(env, "joey.");
    }

    private void convertProperties(Hashtable env, String header) {
        Iterator i = env.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(header)) continue;
            String newKey = key.substring(header.length());
            int j = newKey.indexOf(".");
            while (j != -1) {
                newKey = String.valueOf(newKey.substring(0, j)) + StringUtils.capitalize((String)newKey.substring(j + 1));
                j = newKey.indexOf(".");
            }
            this.contextProperties.setProperty(newKey, env.get(key));
        }
    }
}

