/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.asyrinx.joey.gen.model.FieldTypeImpl;
import org.asyrinx.joey.gen.model.IElement;
import org.asyrinx.joey.gen.model.IFieldType;
import org.asyrinx.joey.gen.model.IProperty;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.TypeNameUtils;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmColumnFormat;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmTable;

public class WmProperty
implements Cloneable,
IProperty,
IFieldType,
IElement {
    private final FieldTypeImpl fieldTypeImpl = new FieldTypeImpl(this);
    private WmColumn column = null;
    private static final Map typeToTorqueType = WmProperty.newTypeToTorqueType();
    private String valueToGet = null;
    private String foreignProperty = null;
    private boolean visible = true;
    private boolean readonly = false;
    private String label = null;
    private String name;
    private String description;
    private String type;
    private WmColumnFormat format = null;

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public void finishLoad() {
    }

    public Object clone() throws CloneNotSupportedException {
        WmProperty result = (WmProperty)super.clone();
        if (this.format != null) {
            result.setFormat((WmColumnFormat)this.format.clone());
        }
        return result;
    }

    public boolean isEnumProperty() {
        return ((WmDatabase)this.getColumn().getTable().getDatabase()).findEnum(this.getJavaType()) != null;
    }

    public WmEnum getEnum() {
        return ((WmDatabase)this.getColumn().getTable().getDatabase()).findEnum(this.getJavaType());
    }

    private static Map newTypeToTorqueType() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("String", "VARCHAR");
        result.put("Date", "DATE");
        result.put("boolean", "BIT");
        result.put("byte", "TINYINT");
        result.put("short", "SMALLINT");
        result.put("int", "INTEGER");
        result.put("long", "BIGINT");
        result.put("float", "REAL");
        result.put("double", "DOUBLE");
        result.put("byte[]", "BLOB");
        return result;
    }

    public Object getTorqueType() {
        if (this.getEnum() != null) {
            return "custom enum(" + this.getEnum().getName() + ")";
        }
        return typeToTorqueType.get(this.type);
    }

    public List getBelongForeignKeys() {
        return this.column.getBelongForeignKeys();
    }

    public WmColumn getForeignColumn(WmForeignKey foreignKey) {
        if (StringUtils.isEmpty((String)this.foreignProperty)) {
            return null;
        }
        WmTable localTable = (WmTable)this.getColumn().getTable();
        Database database = localTable.getDatabase();
        Table foreignTable = database.getTable(foreignKey.getForeignTableName());
        return (WmColumn)foreignTable.getColumn(this.foreignProperty);
    }

    public boolean isPrimaryKey() {
        return false;
    }

    public String getJavaClass() {
        return TypeNameUtils.toClassName(this.getJavaType());
    }

    public String getLabel() {
        if (StringUtils.isEmpty((String)this.label)) {
            return this.getName();
        }
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getForeignProperty() {
        return this.foreignProperty;
    }

    public String getJavaName() {
        return this.name;
    }

    public String getJavaType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public String getValueToGet() {
        return this.valueToGet;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setForeignProperty(String string) {
        this.foreignProperty = string;
    }

    public void setJavaName(String string) {
        this.name = string;
    }

    public void setJavaType(String string) {
        this.type = string;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setReadonly(boolean b) {
        this.readonly = b;
    }

    public void setValueToGet(String string) {
        this.valueToGet = string;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public WmColumn getColumn() {
        return this.column;
    }

    public void setColumn(WmColumn column) {
        this.column = column;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public WmColumnFormat getFormat() {
        return this.format;
    }

    public void setFormat(WmColumnFormat format) {
        this.format = format;
    }

    public boolean isBooleanFieldType() {
        return this.fieldTypeImpl.isBooleanFieldType();
    }

    public boolean isDateFieldType() {
        return this.fieldTypeImpl.isDateFieldType();
    }

    public boolean isMemoFieldType() {
        return this.fieldTypeImpl.isMemoFieldType();
    }

    public boolean isNumberFieldType() {
        return this.fieldTypeImpl.isNumberFieldType();
    }

    public boolean isSelectFieldType() {
        return this.fieldTypeImpl.isSelectFieldType();
    }

    public boolean isTextFieldType() {
        return this.fieldTypeImpl.isTextFieldType();
    }
}

