/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.Iterator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.ForeignKey;
import org.asyrinx.joey.gen.model.IElement;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmTable;

public class WmForeignKey
extends ForeignKey
implements Cloneable,
IElement {
    protected static final String NONE = "NONE";
    protected static final String SETNULL = "SETNULL";
    private String label = null;
    private boolean navigatable = true;
    private boolean oneToOne = false;

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return ObjectUtils.identityToString((Object)this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void finishLoad() {
        this.setOnUpdate(this.normalizeFKey(this.getOnUpdate()));
        this.setOnDelete(this.normalizeFKey(this.getOnDelete()));
    }

    protected final String normalizeFKey(String attrib) {
        if (attrib == null) {
            attrib = NONE;
        }
        if ((attrib = attrib.toUpperCase()).equals(SETNULL)) {
            attrib = "SET NULL";
        }
        return attrib;
    }

    public boolean hasOnUpdate() {
        return !StringUtils.equals((String)this.getOnUpdate(), (String)NONE);
    }

    public boolean hasOnDelete() {
        return !StringUtils.equals((String)this.getOnDelete(), (String)NONE);
    }

    public WmTable getLocalTableObject() {
        return (WmTable)this.getTable();
    }

    public WmTable getForeignTableObject() {
        return (WmTable)this.getTable().getDatabase().getTable(this.getForeignTableName());
    }

    public String getPropertyNameInReferred(boolean plural) {
        String className = this.getTable().getJavaName();
        String relatedByCol = "";
        Iterator localColNameIter = this.getLocalColumns().iterator();
        while (localColNameIter.hasNext()) {
            String localColName = (String)localColNameIter.next();
            Column localCol = this.getTable().getColumn(localColName);
            if (!localCol.isMultipleFK()) continue;
            relatedByCol = String.valueOf(relatedByCol) + localCol.getJavaName();
        }
        if (StringUtils.isEmpty((String)relatedByCol)) {
            if (plural) {
                return StringUtils.uncapitalize((String)(String.valueOf(className) + "s"));
            }
            return StringUtils.uncapitalize((String)className);
        }
        if (plural) {
            return StringUtils.uncapitalize((String)(String.valueOf(className) + "sRelatedBy" + relatedByCol));
        }
        return StringUtils.uncapitalize((String)(String.valueOf(className) + "RelatedBy" + relatedByCol));
    }

    public String getPropertyNameInReferred() {
        return this.getPropertyNameInReferred(true);
    }

    public String getPropertyNameInLocal() {
        WmTable foreignTable = this.getForeignTableObject();
        String className = foreignTable.getJavaName();
        String relCol = "";
        Iterator localColNameIter = this.getLocalColumns().iterator();
        while (localColNameIter.hasNext()) {
            String localColName = (String)localColNameIter.next();
            Column localCol = this.getTable().getColumn(localColName);
            if (!localCol.isMultipleFK() && !this.getForeignTableName().equals(this.getTable().getName())) continue;
            relCol = String.valueOf(relCol) + localCol.getJavaName();
        }
        if (StringUtils.isNotEmpty((String)relCol)) {
            relCol = "RelatedBy" + relCol;
        }
        return StringUtils.uncapitalize((String)(String.valueOf(className) + relCol));
    }

    public String getForeignTable() {
        return super.getForeignTableName();
    }

    public void setForeignTable(String string) {
        super.setForeignTableName(string);
    }

    public String getLabel() {
        if (StringUtils.isEmpty((String)this.label)) {
            return this.getName();
        }
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean isNavigatable() {
        return this.navigatable;
    }

    public void setNavigatable(boolean b) {
        this.navigatable = b;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public void setOneToOne(boolean b) {
        this.oneToOne = b;
    }
}

