/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asyrinx.joey.gen.model.IElement;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.TypeNameUtils;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnumEntry;

public class WmEnum
implements Cloneable,
IElement {
    private WmDatabase database = null;
    private final List entries = new ArrayList();
    private String name = null;
    private String label = null;
    private String valueType = null;

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() throws CloneNotSupportedException {
        WmEnum result = (WmEnum)super.clone();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            WmEnumEntry entry = (WmEnumEntry)iterator.next();
            result.addEntry((WmEnumEntry)entry.clone());
        }
        return result;
    }

    public void finishLoad() {
    }

    public void addEntry(WmEnumEntry entry) {
        entry.setEnum(this);
        this.entries.add(entry);
    }

    public List getEntries() {
        return this.entries;
    }

    public boolean isPrimitiveValueType() {
        return TypeNameUtils.toClassName(this.getValueType()) != null;
    }

    public String getValueClass() {
        String result = TypeNameUtils.toClassName(this.getValueType());
        if (result != null) {
            return result;
        }
        return this.getValueType();
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String string) {
        this.valueType = string;
    }

    public WmDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(WmDatabase database) {
        this.database = database;
    }
}

