/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Database;
import org.asyrinx.joey.gen.model.IElement;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmTableAspect;

public class WmDatabase
extends Database
implements IElement {
    private String defaultJavaType;
    private final List aspects = new ArrayList();
    private final List tableAspects = new ArrayList();
    private final List enums = new ArrayList();
    Log log = LogFactory.getLog(this.getClass());

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return ObjectUtils.identityToString((Object)this);
    }

    public void finishLoad() {
        if (this.getDefaultJavaNamingMethod() == null) {
            this.setDefaultJavaNamingMethod("underscore");
        }
    }

    public void addAspect(WmAspect aspect) {
        aspect.setDatabase(this);
        this.aspects.add(aspect);
    }

    public List getAspects() {
        return this.aspects;
    }

    public WmAspect findAspect(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        Iterator iterator = this.aspects.iterator();
        while (iterator.hasNext()) {
            WmAspect aspect = (WmAspect)iterator.next();
            if (!name.equals(aspect.getName())) continue;
            return aspect;
        }
        return null;
    }

    public void addTableAspect(WmTableAspect tableAspect) {
        tableAspect.setDatabase(this);
        this.tableAspects.add(tableAspect);
    }

    public List getTableAspects() {
        return this.tableAspects;
    }

    public void addEnum(WmEnum wmEnum) {
        wmEnum.setDatabase(this);
        this.enums.add(wmEnum);
    }

    public List getEnums() {
        return this.enums;
    }

    public WmEnum findEnum(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        Iterator iterator = this.enums.iterator();
        while (iterator.hasNext()) {
            WmEnum wmEnum = (WmEnum)iterator.next();
            if (!name.equals(wmEnum.getName())) continue;
            return wmEnum;
        }
        return null;
    }

    public String getDefaultIdMethod() {
        return super.getDefaultIdMethod();
    }

    public void setDefaultIdMethod(String v) {
        this.log.debug((Object)("setDefaultIdMethod was called: " + v));
        super.setDefaultIdMethod(v);
    }

    public String getDefaultJavaType() {
        return this.defaultJavaType;
    }

    public void setDefaultJavaType(String string) {
        this.defaultJavaType = string;
    }
}

