/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.torque.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.asyrinx.brownie.servlet.FileNameResolver;

public class TorqueInitFilter
implements Filter {
    public static final String CONFIG_KEY_TORQUE = "torque_properties";

    public void init(FilterConfig config) throws ServletException {
        this.initTorque(config);
    }

    protected void initTorque(FilterConfig config) throws ServletException {
        String configPath = config.getInitParameter(CONFIG_KEY_TORQUE);
        ServletContext context = config.getServletContext();
        FileNameResolver resolver = new FileNameResolver(context);
        String actualPath = resolver.toRealPath(configPath);
        if (StringUtils.isEmpty((String)actualPath)) {
            actualPath = configPath;
        }
        try {
            Torque.init((String)actualPath);
            context.log("Torque was initialized");
        }
        catch (TorqueException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter(req, res);
    }

    public void destroy() {
    }
}

