/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.ObjectUtils;

public final class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static final String NUMERIC_CHARS = ".-0123456789\uff0e\uff0d\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
    private static final String NUMBER_CHARS = "0123456789\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
    public static final String NULL_STRING = "";
    public static final char QUOTE_SINGLE = '\'';
    public static final char QUOTE_DOUBLE = '\"';
    public static final char QUOTE_SINGLE_ZENKAKU_BEGIN = '\u2018';
    public static final char QUOTE_SINGLE_ZENKAKU_END = '\u2019';
    public static final char QUOTE_DOUBLE_ZENKAKU_BEGIN = '\u201c';
    public static final char QUOTE_DOUBLE_ZENKAKU_END = '\u201d';
    public static final char[] QUOTE_SINGLES = new char[]{'\'', '\u2018', '\u2019'};
    public static final char[] QUOTE_DOUBLES = new char[]{'\"', '\u201c', '\u201d'};

    public static boolean isAvailable(String value) {
        return StringUtils.isAvailable(value, false);
    }

    public static boolean isAvailable(String value, boolean trim) {
        if (value == null) {
            return false;
        }
        if (trim) {
            value = value.trim();
        }
        return !value.equals(NULL_STRING);
    }

    public static String connectString(Collection col, String connectStr) {
        if (col == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(NULL_STRING);
        StringUtils.connectString(buf, col, connectStr);
        return buf.toString();
    }

    public static void connectString(StringBuffer dest, Collection col, String connectStr) {
        if (col == null) {
            return;
        }
        Iterator ite = col.iterator();
        boolean isFirst = true;
        while (ite.hasNext()) {
            if (!isFirst) {
                dest.append(connectStr);
            } else {
                isFirst = false;
            }
            dest.append(ite.next());
        }
    }

    public static String deleteNotNumeric(Object value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String str = String.valueOf(value);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (NUMERIC_CHARS.indexOf(c) > -1) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean isNumeric(char c) {
        return NUMBER_CHARS.indexOf(c) > -1;
    }

    public static boolean hasNumeric(String string) {
        if (!StringUtils.isAvailable(string)) {
            return false;
        }
        int i = 0;
        while (i < string.length()) {
            if (NUMBER_CHARS.indexOf(string.charAt(i)) > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNumericOnly(String string) {
        if (!StringUtils.isAvailable(string)) {
            return false;
        }
        int i = 0;
        while (i < string.length()) {
            if (NUMBER_CHARS.indexOf(string.charAt(i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String deleteNotNumber(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (NUMBER_CHARS.indexOf(c) > -1) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static void replace(StringBuffer buffer, String pattern, String newPattern) {
        if (org.apache.commons.lang.StringUtils.equals((String)pattern, (String)newPattern)) {
            return;
        }
        int patternLength = pattern.length();
        int idx = buffer.toString().indexOf(pattern);
        while (idx > -1) {
            buffer.replace(idx, idx + patternLength, newPattern);
            idx = buffer.toString().indexOf(pattern, idx + newPattern.length());
        }
    }

    public static void replace(StringBuffer buffer, char oldChar, char newChar) {
        int idx = buffer.toString().indexOf(oldChar);
        String newString = String.valueOf(newChar) + NULL_STRING;
        while (idx > -1) {
            buffer.replace(idx, idx + 1, newString);
            idx = buffer.toString().indexOf(oldChar, idx + 1);
        }
    }

    public static String replace(String source, String pattern, String newPattern) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source);
        StringUtils.replace(result, pattern, newPattern);
        return result.toString();
    }

    public static String replace(String source, char oldChar, char newChar) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source);
        StringUtils.replace(result, oldChar, newChar);
        return result.toString();
    }

    public static String replaceBySystemProp(String source) {
        return StringUtils.replaceBySystemProp(source, '%');
    }

    public static String replaceBySystemProp(String source, char delim) {
        return StringUtils.replaceBySystemProp(source, delim, delim);
    }

    public static String replaceBySystemProp(String source, char delimBegin, char delimEnd) {
        String key = StringUtils.extractString(source, delimBegin, delimEnd);
        while (key != null) {
            source = StringUtils.replace(source, String.valueOf(delimBegin) + key + delimEnd, System.getProperty(key, NULL_STRING));
            key = StringUtils.extractString(source, delimBegin, delimEnd);
        }
        return source;
    }

    public static String extractString(String source, char delim) {
        return StringUtils.extractString(source, delim, delim);
    }

    public static String extractString(String source, char delimBegin, char delimEnd) {
        return StringUtils.extractString(source, delimBegin, delimEnd, 0);
    }

    public static String extractString(String source, char delimBegin, char delimEnd, int fromIndex) {
        int idxBegin = source.indexOf(delimBegin, fromIndex);
        if (idxBegin < 0) {
            return null;
        }
        int idxEnd = source.indexOf(delimEnd, idxBegin + 1);
        if (idxEnd < 0) {
            return null;
        }
        return source.substring(idxBegin + 1, idxEnd);
    }

    public static void extractStrings(String source, List dest, char delim) {
        StringUtils.extractStrings(source, dest, delim, delim, 0);
    }

    public static void extractStrings(String source, List dest, char delimBegin, char delimEnd) {
        StringUtils.extractStrings(source, dest, delimBegin, delimEnd, 0);
    }

    public static void extractStrings(String source, List dest, char delimBegin, char delimEnd, int fromIndex) {
        int idxBegin = source.indexOf(delimBegin, fromIndex);
        while (idxBegin > -1) {
            int idxEnd = source.indexOf(delimEnd, idxBegin + 1);
            if (idxEnd < 0) {
                return;
            }
            dest.add(source.substring(idxBegin + 1, idxEnd));
            idxBegin = source.indexOf(delimBegin, idxEnd + 1);
        }
    }

    public static String nullTrim(Object value) {
        return StringUtils.nullTrim(value, false);
    }

    public static String nullTrim(Object value, boolean trim) {
        if (value == null) {
            return NULL_STRING;
        }
        if (trim) {
            return value.toString().trim();
        }
        return value.toString();
    }

    public static String nullTrim(Object[] values) {
        return StringUtils.nullTrim(values, false);
    }

    public static String nullTrim(Object[] values, boolean trim) {
        if (values == null) {
            return NULL_STRING;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            result.append(StringUtils.nullTrim(values[i], trim));
            ++i;
        }
        return result.toString();
    }

    public static boolean compare(String target1, String target2) {
        return ObjectUtils.equals((Object)target1, (Object)target2);
    }

    public static List parseToList(String value, String delimiters) {
        Vector<String> result = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters, false);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static void tokenize(List dest, String str, String delim) {
        if (dest == null) {
            return;
        }
        if (org.apache.commons.lang.StringUtils.isEmpty((String)str)) {
            return;
        }
        buf = new StringBuffer(str);
        idx = buf.indexOf(delim);
        if (idx >= 0) ** GOTO lbl16
        dest.add(str);
        return;
lbl-1000:
        // 1 sources

        {
            dest.add(buf.substring(0, idx));
            buf.delete(0, idx + delim.length());
            idx = buf.toString().indexOf(delim);
lbl16:
            // 2 sources

            ** while (idx > -1)
        }
lbl17:
        // 1 sources

        if (buf != null) {
            dest.add(buf.toString());
        }
    }

    public static String[] tokenizeToArray(String str, String delim) {
        if (str == null) {
            return null;
        }
        ArrayList resultList = new ArrayList();
        StringUtils.tokenize(resultList, str, delim);
        if (resultList.size() < 1) {
            return new String[0];
        }
        String[] result = new String[resultList.size()];
        int i = 0;
        while (i < resultList.size()) {
            result[i] = (String)resultList.get(i);
            ++i;
        }
        return result;
    }

    public static List tokenize(String str, String delim) {
        ArrayList result = new ArrayList();
        StringUtils.tokenize(result, str, delim);
        return result;
    }

    public static int indexOf(char[] source, char value) {
        if (source == null) {
            return -1;
        }
        int i = 0;
        while (i < source.length) {
            if (source[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean containAnyChar(String s, char[] chars) {
        if (s == null) {
            return false;
        }
        if (chars == null) {
            return false;
        }
        int i = 0;
        while (i < chars.length) {
            int idx = s.indexOf(chars[i]);
            if (idx > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String duplicateQuote(String value, char[] quotes, boolean nullTrim) {
        if (nullTrim) {
            value = StringUtils.nullTrim(value);
        }
        if (value == null) {
            return null;
        }
        if (!StringUtils.containAnyChar(value, quotes)) {
            return value;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            result.append(c);
            if (StringUtils.indexOf(quotes, c) > -1) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String duplicateQuote(String value, char[] quotes) {
        return StringUtils.duplicateQuote(value, quotes, true);
    }

    public static String duplicateQuote(String value, char quote, boolean nullTrim) {
        return StringUtils.duplicateQuote(value, new char[]{quote}, nullTrim);
    }

    public static String duplicateQuote(String value, char quote) {
        return StringUtils.duplicateQuote(value, quote, true);
    }

    public static String toQuoted(String value, char quote, boolean nullTrim) {
        String result = StringUtils.duplicateQuote(value, quote, nullTrim);
        if (!nullTrim && result == null) {
            return null;
        }
        return StringUtils.addQuote(result, quote);
    }

    public static String toQuoted(String value, char quote) {
        return StringUtils.toQuoted(value, quote, true);
    }

    private static String addQuote(String value, char quote) {
        return String.valueOf(quote) + StringUtils.nullTrim(value) + quote;
    }

    public static String padHead(String value, String pad, int length) {
        if (value.getBytes().length >= length) {
            return value;
        }
        int addNum = (length - value.getBytes().length) / pad.getBytes().length;
        StringBuffer buffer = new StringBuffer(value);
        int index = 0;
        while (index < addNum) {
            buffer.insert(0, pad);
            ++index;
        }
        return buffer.toString();
    }

    public static String padTail(String value, String pad, int length) {
        if (value.getBytes().length >= length) {
            return value;
        }
        int addNum = (length - value.getBytes().length) / pad.getBytes().length;
        StringBuffer buffer = new StringBuffer(value);
        int index = 0;
        while (index < addNum) {
            buffer.append(pad);
            ++index;
        }
        return buffer.toString();
    }
}

