/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import org.asyrinx.brownie.core.lang.StringUtils;

public class NumberUtils {
    public static int toInt(Object value, int defaultValue) {
        return NumberUtils.toInt(value, defaultValue, true);
    }

    public static int toInt(Object value, int defaultValue, boolean deleteNotNumeric) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String val = deleteNotNumeric ? StringUtils.deleteNotNumeric(value) : String.valueOf(value);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double toDouble(Object value, double defaultValue) {
        return NumberUtils.toDouble(value, defaultValue, true);
    }

    public static double toDouble(Object value, double defaultValue, boolean deleteNotNumeric) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        String val = deleteNotNumeric ? StringUtils.deleteNotNumeric(value) : String.valueOf(value);
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long toLong(Object value, long defaultValue) {
        return NumberUtils.toLong(value, defaultValue, true);
    }

    public static long toLong(Object value, long defaultValue, boolean deleteNotNumeric) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        String val = deleteNotNumeric ? StringUtils.deleteNotNumeric(value) : String.valueOf(value);
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

