/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package test.org.asyrinx.brownie.core.util;

import java.util.Calendar;
import java.util.Date;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.util.SimpleDate;

/**
 * @author akima
 */
public class SimpleDateTest extends TestCase {

	/**
	 * Constructor for SimpleDateTest.
	 * @param name
	 */
	public SimpleDateTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(SimpleDateTest.class);
	}

	public void testEqual() {
		final SimpleDate simpleDate = new SimpleDate(2003, 9, 23);
		//
		final Calendar calendar = Calendar.getInstance();
		calendar.set(2003, 9, 23);
		final Date d1 = calendar.getTime();
		assertTrue(simpleDate.equals(d1)); //OK
		assertTrue(!d1.equals(simpleDate)); //͂߁I
		//
		calendar.set(2003, 9, 23, 0, 0, 0);
		final Date d2 = calendar.getTime();
		assertTrue(simpleDate.equals(d2)); //OK
		assertTrue(!d2.equals(simpleDate)); //͂߁I
		//
		calendar.set(2003, 9, 23, 12, 30, 29);
		final Date d3 = calendar.getTime();
		assertTrue(simpleDate.equals(d3)); //OK
		assertTrue(!d3.equals(simpleDate)); //͂߁I
		//
		calendar.set(2003, 9, 23, 23, 59, 59);
		final Date d4 = calendar.getTime();
		assertTrue(simpleDate.equals(d4)); //OK
		assertTrue(!d4.equals(simpleDate)); //͂߁I
		//
		calendar.set(2003, 9, 31, 23, 59, 59); //tႤ
		final Date d5 = calendar.getTime();
		assertTrue(!simpleDate.equals(d5)); //͂߁I
		assertTrue(!d4.equals(simpleDate)); //߁I
		//
		final SimpleDate simpleDate2 = new SimpleDate(2003, 9, 23);
		final SimpleDate simpleDate3 = new SimpleDate(2003, 9, 24);
		final SimpleDate simpleDate4 = new SimpleDate(2003, 8, 23);
		final SimpleDate simpleDate5 = new SimpleDate(2002, 9, 23);
		final SimpleDate simpleDate6 = new SimpleDate(2002, 1, 1);
		assertEquals(simpleDate, simpleDate2);
		assertFalse(simpleDate.equals(simpleDate3));
		assertFalse(simpleDate.equals(simpleDate4));
		assertFalse(simpleDate.equals(simpleDate5));
		assertFalse(simpleDate.equals(simpleDate6));
	}

	private void checkOrder(SimpleDate before, SimpleDate after) {
		assertTrue(before.before(after));
		assertTrue(after.after(before));
		assertTrue(!before.after(after));
		assertTrue(!after.before(before));
	}

	public void testAfterAndBefore() {
		final SimpleDate d1 = new SimpleDate(2001, 0, 31);
		final SimpleDate d2 = new SimpleDate(2003, 8, 30);
		final SimpleDate d3 = new SimpleDate(2003, 9, 15);
		final SimpleDate d4 = new SimpleDate(2003, 9, 23);
		final SimpleDate d5 = new SimpleDate(2003, 10, 2);
		final SimpleDate d6 = new SimpleDate(2003, 10, 23);
		checkOrder(d1, d2);
		checkOrder(d1, d3);
		checkOrder(d1, d4);
		checkOrder(d1, d5);
		checkOrder(d1, d6);
		checkOrder(d2, d3);
		checkOrder(d2, d4);
		checkOrder(d2, d5);
		checkOrder(d2, d6);
		checkOrder(d3, d4);
		checkOrder(d3, d5);
		checkOrder(d3, d6);
		checkOrder(d4, d5);
		checkOrder(d4, d6);
		checkOrder(d5, d6);
	}

	public void testToDate() {
		final SimpleDate d = new SimpleDate(2003, 9, 23);
		final Date dateBegin = d.toDateBegin();
		final Date dateEnd = d.toDateEnd();
		final Calendar calendar = Calendar.getInstance();
		calendar.set(2003, 9, 23, 0, 0, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		assertEquals(calendar.getTime(), dateBegin);
		calendar.set(2003, 9, 23, 23, 59, 59);
		calendar.set(Calendar.MILLISECOND, 999);
		assertEquals(calendar.getTime(), dateEnd);
	}

}
