/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/21
 */
package test.org.asyrinx.brownie.core.sql;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.sql.DynamicSelect;
import org.asyrinx.brownie.core.sql.Operator;

/**
 * @author akima
 */
public class DynamicSelectTest extends TestCase {

	/**
	 * Constructor for DynamicSelectTest.
	 * @param name
	 */
	public DynamicSelectTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(DynamicSelectTest.class);
	}

	public void testSimpleSQL1() {
		final DynamicSelect select = new DynamicSelect();
		select.getSelectFields().add("a");
		select.getSelectFields().add("b");
		select.getSelectFields().add("c");
		select.getFromTables().add("A1");
		select.getWhereConditions().add("d", 1);
		//System.out.println(select.build());
		assertEquals("select a, b, c from A1 where d = 1 ", select.build());
	}

	public void testSimpleHQL1() {
		final DynamicSelect select = new DynamicSelect();
		select.getFromTables().add("A1");
		select.getWhereConditions().add("d", 1);
		//System.out.println(select.build());
		assertEquals("from A1 where d = 1 ", select.build());
	}

	public void testSimpleComplexCondition() {
		final DynamicSelect select = new DynamicSelect();
		select.getSelectFields().add("a").add("b").add("c");
		select.getFromTables().add("A1");
		select
			.getWhereConditions()
			.add("d", 1)
			.addNewCondition(Operator.OR)
			.add("a", 123)
			.add("b", 456)
			.addNewCondition(Operator.AND)
			.add("c", 789)
			.add("d", 1234);
		select.getWhereConditions().add("e", 2);
		//System.out.println(select.build());
		assertEquals(
			"select a, b, c from A1 where d = 1 and (a = 123 or b = 456 or (c = 789 and d = 1234)) and e = 2 ",
			select.build());
	}

}
