/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package test.org.asyrinx.brownie.core.lang.enum;

import java.util.Set;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.enum.ValuedEnum;
import org.asyrinx.brownie.core.lang.enum.ValuedEnumSet;

/**
 * @author akima
 */
public class ValuedEnumSetTest extends TestCase {

	/**
	 * Constructor for ValuedEnumSetTest.
	 * @param name
	 */
	public ValuedEnumSetTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(ValuedEnumSetTest.class);
	}

	public void testSelected() {
		final ValuedEnumSet enumSet = new ValuedEnumSet(TestValuedEnum.class);
		assertEquals(4, enumSet.size());
		//getEntryByName
		assertEquals(
			TestValuedEnum.VALUE_1,
			enumSet.getEntryByName("value1").getEnum());
		assertEquals(
			TestValuedEnum.VALUE_2,
			enumSet.getEntryByName("value2").getEnum());
		assertEquals(
			TestValuedEnum.VALUE_3,
			enumSet.getEntryByName("value3").getEnum());
		assertEquals(
			TestValuedEnum.VALUE_4,
			enumSet.getEntryByName("value4").getEnum());
		//getEntryByValue
		assertEquals(
			TestValuedEnum.VALUE_1,
			enumSet.getEntryByValue(new Integer(1)).getEnum());
		assertEquals(
			TestValuedEnum.VALUE_2,
			enumSet.getEntryByValue(new Integer(2)).getEnum());
		assertEquals(
			TestValuedEnum.VALUE_3,
			enumSet.getEntryByValue(new Integer(3)).getEnum());
		assertEquals(
			TestValuedEnum.VALUE_4,
			enumSet.getEntryByValue(new Integer(4)).getEnum());
		//
		Set selectedEnums = enumSet.getSelectedEnums();
		Set selectedValues = enumSet.getSelectedEnumValues();
		assertEquals(0, selectedEnums.size());
		assertEquals(0, selectedValues.size());
		//
		enumSet.getEntry(TestValuedEnum.VALUE_1).setSelected(true);
		selectedEnums = enumSet.getSelectedEnums();
		selectedValues = enumSet.getSelectedEnumValues();
		assertEquals(1, selectedEnums.size());
		assertTrue(selectedEnums.contains(TestValuedEnum.VALUE_1));
		assertTrue(selectedValues.contains(new Integer(1)));
		//
		enumSet.getEntry(TestValuedEnum.VALUE_1).setSelected(true);
		enumSet.getEntry(TestValuedEnum.VALUE_4).setSelected(true);
		selectedEnums = enumSet.getSelectedEnums();
		selectedValues = enumSet.getSelectedEnumValues();
		assertEquals(2, selectedEnums.size());
		assertTrue(selectedEnums.contains(TestValuedEnum.VALUE_1));
		assertTrue(selectedEnums.contains(TestValuedEnum.VALUE_4));
		assertTrue(selectedValues.contains(new Integer(1)));
		assertTrue(selectedValues.contains(new Integer(4)));
	}

}
class TestValuedEnum extends ValuedEnum {

	/**
	 * @param name
	 * @param value
	 */
	public TestValuedEnum(String name, int value) {
		super(name, new Integer(value));
	}

	public int toInt() {
		return ((Integer) getValue()).intValue();
	}

	static final TestValuedEnum VALUE_1 = new TestValuedEnum("value1", 1);
	static final TestValuedEnum VALUE_2 = new TestValuedEnum("value2", 2);
	static final TestValuedEnum VALUE_3 = new TestValuedEnum("value3", 3);
	static final TestValuedEnum VALUE_4 = new TestValuedEnum("value4", 4);

}
