/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/28
 */
package test.org.asyrinx.brownie.core.collection;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.Predicate;
import org.asyrinx.brownie.core.collection.CollectionSqueezer;
import org.asyrinx.brownie.core.lang.ArrayUtils;

import junit.framework.TestCase;

/**
 * @author akima
 */
public class CollectionSqueezerTest extends TestCase {

	/**
	 * Constructor for CollectionSqueezerTest.
	 * @param name
	 */
	public CollectionSqueezerTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(CollectionSqueezerTest.class);
	}

	final String[] targetValues =
		new String[] { "a1", "b3", "b1", "a3", "b2", "a2", };

	public void testExecute() {
		final List target = ArrayUtils.toArrayList(targetValues);
		final CollectionSqueezer squeezer =
			new CollectionSqueezer(new Predicate() {
			public boolean evaluate(Object input) {
				if (input instanceof String) {
					final String value = (String) input;
					return value.startsWith("a");
				} else
					return false;
			}
		});
		final List dest = new ArrayList();
		squeezer.execute(target.iterator(), dest);
		assertEquals(3, dest.size());
		assertEquals("a1", dest.get(0));
		assertEquals("a3", dest.get(1));
		assertEquals("a2", dest.get(2));
	}

	public void testEvaluate() {
		final List target = ArrayUtils.toArrayList(targetValues);
		final CollectionSqueezer squeezer = new CollectionSqueezer() {
			public boolean evaluate(Object input) {
				if (input instanceof String) {
					final String value = (String) input;
					return value.startsWith("a");
				} else
					return false;
			}
		};
		final List dest = new ArrayList();
		squeezer.execute(target.iterator(), dest);
		assertEquals(3, dest.size());
		assertEquals("a1", dest.get(0));
		assertEquals("a3", dest.get(1));
		assertEquals("a2", dest.get(2));
	}

}
