/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package org.asyrinx.brownie.tapestry.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IPage;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.Shell;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author akima
 */
public class ComponentUtils {

	/**
	 * 
	 */
	private ComponentUtils() {
		super();
	}

	private static Log log = LogFactory.getLog(ComponentUtils.class);

	public static IComponent getTopContainer(IComponent target) {
		if (target == null)
			return null;
		if (target.getContainer() != null)
			return getTopContainer(target.getContainer());
		else
			return target;
	}

	public static IComponent lookFor(IComponent target, Predicate filter) {
		if (target == null)
			return null;
		final Map targetComponents = target.getComponents();
		final Iterator iterator = targetComponents.values().iterator();
		while (iterator.hasNext()) {
			final Object component = iterator.next();
			if (!(component instanceof IComponent))
				continue;
			if (filter.evaluate(component))
				return (IComponent) component;
		}
		return null;
	}

	public static IComponent lookForByClass(IComponent target, Class class1) {
		return lookFor(target, new ClassMatch(class1));
	}

	public static IComponent lookForById(
		IComponent target,
		String componentId) {
		return lookFor(target, new IdMatch(componentId));
	}

	public static IComponent searchBottom(
		IComponent target,
		Predicate filter) {
		if (target == null)
			return null;
		IComponent result = lookFor(target, filter);
		if (result != null)
			return result;
		final Iterator iterator = target.getComponents().values().iterator();
		while (iterator.hasNext()) {
			final IComponent subcomponent = (IComponent) iterator.next();
			result = searchBottom(subcomponent, filter);
			if (result != null)
				return result;
		}
		return null;
	}

	public static IComponent searchBottomById(
		IComponent target,
		String componentId) {
		return searchBottom(target, new IdMatch(componentId));
	}

	public static IComponent searchBottomByClass(
		IComponent target,
		Class clazz) {
		return searchBottom(target, new ClassMatch(clazz));
	}

	public static IComponent searchUpper(IComponent target, Predicate filter) {
		if (target == null)
			return null;
		final IComponent parent = target.getContainer();
		if (parent == null)
			return null;
		if (filter.evaluate(parent))
			return parent;
		else
			return searchUpper(parent, filter);
	}

	public static IComponent searchUpperById(
		IComponent target,
		String componentId) {
		return searchUpper(target, new IdMatch(componentId));
	}

	public static IComponent searchUpperByClass(
		IComponent target,
		Class clazz) {
		return searchUpper(target, new ClassMatch(clazz));
	}

	/**
	 * IFomComponentId͎sɐ^OnameƂ͈قȂ邱Ƃ̂ŁA
	 * IForm擾܂B
	 * @param linkComponent
	 * @param id
	 * @return
	 */
	public static String getElementId(IComponent client, String id) {
		final IPage page = client.getPage();
		final IComponent component = ComponentUtils.searchBottomById(page, id);
		final IFormComponent formComponent =
			(component instanceof IFormComponent)
				? (IFormComponent) component
				: null;
		if (formComponent == null)
			return null;
		final IForm form = formComponent.getForm();
		return form.getElementId(formComponent);
	}

	public static String getNameOnForm(IComponent component) {
		if (component instanceof IFormComponent)
			return ((IFormComponent) component).getName();
		else
			return null;
	}

	public static void addStylesheet(IComponent component, String assetName) {
		addStylesheet(component, component.getAsset(assetName));
	}

	public static void addStylesheet(IComponent component, IAsset asset) {
		final Shell shell =
			(Shell) ComponentUtils.searchBottomByClass(
				ComponentUtils.getTopContainer(component),
				Shell.class);
		addStylesheet(shell, asset);
	}

	public static void addStylesheet(Shell shell, IAsset asset) {
		if (shell == null) {
			log.warn("failed to addStylesheet because Shell is null");
			return;
		}
		final Object original = shell.getStylesheets();
		final Collection newStylesheets;
		if (original instanceof Object[]) {
			newStylesheets = ArrayUtils.toArrayList((Object[]) original);
		} else if (original instanceof Collection) {
			newStylesheets = (Collection) original;
		} else {
			return;
		}
		newStylesheets.add(asset);
	}

}

class IdMatch implements Predicate {

	public IdMatch(String componentId) {
		super();
		this.componentId = componentId;
	}
	final String componentId;
	/**
	 * @see org.asyrinx.brownie.core.util.Predicate#evaluate(java.lang.Object)
	 */
	public boolean evaluate(Object object) {
		if (!(object instanceof IComponent))
			return false;
		final IComponent component = (IComponent) object;
		if (StringUtils.isEmpty(component.getId()))
			return false;
		return component.getId().equals(this.componentId);
	}

}
class ClassMatch implements Predicate {

	public ClassMatch(Class clazz) {
		super();
		this.clazz = clazz;
	}
	final Class clazz;
	/**
	 * @see org.asyrinx.brownie.core.util.Predicate#evaluate(java.lang.Object)
	 */
	public boolean evaluate(Object object) {
		return clazz.isInstance(object);
	}

}
