/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/03
 */
package org.asyrinx.brownie.tapestry.script;

import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScript;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.spec.IComponentSpecification;

/**
 * @author akima
 */
public class ScriptUtils {

	/**
	 * 
	 */
	private ScriptUtils() {
		super();
	}

	public static IScript loadScript(IComponent component, String scriptName) {
		final IPage page = component.getPage();
		final IComponentSpecification specification =
			component.getSpecification();
		final IEngine engine = page.getEngine();
		final IScriptSource source = engine.getScriptSource();
		final IResourceLocation location =
			specification.getSpecificationLocation().getRelativeLocation(
				scriptName);
		return source.getScript(location);
	}

}
