/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/03
 */
package org.asyrinx.brownie.tapestry.components.link;

import java.util.HashMap;
import java.util.Map;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.link.ILinkRenderer;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.tapestry.util.ValueTagWriter;

/**
 * @author akima
 */
public class WindowOpenLinkRenderer extends AbstractScriptLinkRenderer {

	public static final ILinkRenderer SHARED_INSTANCE =
		new WindowOpenLinkRenderer();

	/**
	 * 
	 */
	public WindowOpenLinkRenderer() {
		super("WindowOpenLinkRenderer.script");
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#checkBeforeRender(org.apache.tapestry.IRequestCycle, org.apache.tapestry.components.ILinkComponent)
	 */
	protected void checkBeforeRender(
		IRequestCycle cycle,
		ILinkComponent linkComponent) {
		super.checkBeforeRender(cycle, linkComponent);
		if (!(linkComponent instanceof IWindowOpenOption))
			throw new ApplicationRuntimeException(
				"must-be-implemented-IWindowOpenOption",
				this,
				null,
				null);
	}

	public static final String CLICK_LINK_ROW_METHOD_NAME = "clickLink";
	private static final String HREF_DUMMY = "javascript:void(0);";

	public static final String SYM_METHOD_CLICK_ROW = "clickLinkMethodName";
	public static final String SYM_OPTIONS = "options";

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#addScript(org.apache.tapestry.IRequestCycle, org.apache.tapestry.IScript, org.apache.tapestry.html.Body)
	 */
	protected void addScript(IRequestCycle cycle, IScript script, Body body) {
		final Map symbols = new HashMap();
		symbols.put(SYM_METHOD_CLICK_ROW, CLICK_LINK_ROW_METHOD_NAME);
		script.execute(cycle, body, symbols);
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#renderBeginTag(org.apache.tapestry.IMarkupWriter, org.apache.tapestry.IRequestCycle, org.apache.tapestry.components.ILinkComponent)
	 */
	protected void renderBeginTag(
		IMarkupWriter writer,
		IRequestCycle cycle,
		ILinkComponent linkComponent) {
		if (getHasBody())
			writer.begin(getElement());
		else
			writer.beginEmpty(getElement());
		writer.attribute("href", HREF_DUMMY);
		writer.attribute("onclick", CLICK_LINK_ROW_METHOD_NAME + "(this)");
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#renderBody(org.apache.tapestry.IMarkupWriter, org.apache.tapestry.IRequestCycle, org.apache.tapestry.components.ILinkComponent)
	 */
	protected void renderBody(
		IMarkupWriter bodyWriter,
		IRequestCycle cycle,
		ILinkComponent linkComponent) {
		final ILink l = linkComponent.getLink(cycle);
		bodyWriter.println();
		addIdValueSpan(
			bodyWriter,
			"href",
			constructURL(l, linkComponent.getAnchor()));
		// linkComponent will be checked before here
		final IWindowOpenOption option = (IWindowOpenOption) linkComponent;
		addIdValueSpan(bodyWriter, "target", option.getWindowTarget());
		bodyWriter.println();
		//
		bodyWriter.begin("span");
		bodyWriter.attribute("id", "options");
		bodyWriter.attribute("style", "display:none");
		bodyWriter.println();
		final Map options = new HashMap();
		options.put("toolbar", option.getWindowToolbar());
		options.put("location", option.getWindowLocation());
		options.put("directories", option.getWindowDirectories());
		options.put("status", option.getWindowStatus());
		options.put("menubar", option.getWindowMenubar());
		options.put("scrollbars", option.getWindowScrollbars());
		options.put("resizable", option.getWindowResizable());
		options.put("width", option.getWindowWidth());
		options.put("height", option.getWindowHeight());
		options.put("left", option.getWindowLeft());
		options.put("top", option.getWindowTop());
		final IMarkupWriter nestedWriter = bodyWriter.getNestedWriter();
		final ValueTagWriter tagWriter = new ValueTagWriter(nestedWriter);
		tagWriter.addProperties(options);
		nestedWriter.close();
		bodyWriter.end();
	}

	private static void addIdValueSpan(
		IMarkupWriter writer,
		String id,
		String value) {
		if (StringUtils.isEmpty(value))
			return;
		writer.begin("span");
		writer.attribute("id", id);
		writer.attribute("style", "display:none");
		final IMarkupWriter innerDivWriter = writer.getNestedWriter();
		innerDivWriter.printRaw(value);
		innerDivWriter.close();
		writer.end();
	}

	/**
	 * @return
	 */
	private String getElement() {
		return "a";
	}
}
