/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/06
 */
package org.asyrinx.brownie.tapestry.components.link;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.util.ComponentUtils;

/**
 * @author akima
 */
public class SubWindowUtils {

	/**
	 * 
	 */
	private SubWindowUtils() {
		super();
	}

	public static void open(
		IRequestCycle cycle,
		final String pageName,
		final Map propFieldMap) {
		if (StringUtils.isEmpty(pageName))
			throw new ApplicationRuntimeException("failed to open sub-window because of null pageName");
		final IPage next = cycle.getPage(pageName);
		if (StringUtils.isEmpty(pageName))
			throw new ApplicationRuntimeException(
				"page not found: '" + pageName + "'");
		final IComponent subWindowListRow =
			ComponentUtils.lookForByClass(next, DirectSubWindowListRow.class);
		if (subWindowListRow instanceof DirectSubWindowListRow) {
			final DirectSubWindowListRow listRow =
				(DirectSubWindowListRow) subWindowListRow;
			listRow.setReturnOptions(propFieldMap);
		}
		cycle.activate(next);
	}

}
