/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/03
 */
package org.asyrinx.brownie.tapestry.components.link;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.link.ILinkRenderer;
import org.asyrinx.brownie.core.collection.MapTree;
import org.asyrinx.brownie.tapestry.util.ValueTagWriter;

/**
 * @author akima
 */
public class SubWindowListRowRenderer extends AbstractLinkRowRenderer {

	public static final ILinkRenderer SHARED_INSTANCE =
		new SubWindowListRowRenderer();

	/**
	 * 
	 */
	public SubWindowListRowRenderer() {
		super("SubWindowListRowRenderer.script");
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#checkBeforeRender(org.apache.tapestry.IRequestCycle, org.apache.tapestry.components.ILinkComponent)
	 */
	protected void checkBeforeRender(
		IRequestCycle cycle,
		ILinkComponent linkComponent) {
		super.checkBeforeRender(cycle, linkComponent);
		if (!(linkComponent instanceof ISubWindowListRow))
			throw new ApplicationRuntimeException(
				"must-be-implemented-ISubWindowListRow",
				this,
				null,
				null);
		if (getParameters(linkComponent) == null)
			throw new ApplicationRuntimeException(
				"must-has-getParameters-method",
				this,
				null,
				null);
	}

	public static final String SYM_METHOD_CLICK_ROW = "clickLinkRowMethodName";
	public static final String SYM_METHOD_MOSUE_OVER_ROW =
		"mouseOverLinkRowMethodName";
	public static final String SYM_METHOD_MOSUE_OUT_ROW =
		"mouseOutLinkRowMethodName";
	public static final String SYM_SELECT_BG_COLOR = "selectBgColor";
	public static final String SYM_SELECT_STYLE_CLASS = "selectStyleClass";
	public static final String SYM_RENDERER = "renderer";

	private static final String SCRIPT_ADD_FLAG_KEY =
		DirectLinkRow.class.getName() + ".added.javascript";

	protected String getScriptId() {
		return SCRIPT_ADD_FLAG_KEY + "." + this.hashCode();
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#addScript(org.apache.tapestry.IRequestCycle, org.apache.tapestry.IScript, org.apache.tapestry.html.Body)
	 */
	protected void addScript(IRequestCycle cycle, IScript script, Body body) {
		if (cycle.getAttribute(getScriptId()) != null)
			return;
		cycle.setAttribute(getScriptId(), new int[0]);
		final Map symbols = new HashMap();
		symbols.put(SYM_RENDERER, this);
		symbols.put(SYM_METHOD_CLICK_ROW, CLICK_LINK_ROW_METHOD_NAME);
		symbols.put(SYM_METHOD_MOSUE_OVER_ROW, MOSUE_OVER_LINK_ROW_METHOD_NAME);
		symbols.put(SYM_METHOD_MOSUE_OUT_ROW, MOSUE_OUT_LINK_ROW_METHOD_NAME);
		symbols.put(SYM_SELECT_BG_COLOR, getSelectBgColor());
		symbols.put(SYM_SELECT_STYLE_CLASS, getSelectStyleClass());
		script.execute(cycle, body, symbols);
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#renderBody(org.apache.tapestry.IMarkupWriter, org.apache.tapestry.IRequestCycle, org.apache.tapestry.components.ILinkComponent)
	 */
	protected void renderBody(
		IMarkupWriter bodyWriter,
		IRequestCycle cycle,
		ILinkComponent linkComponent) {
		final ISubWindowListRow subWindowListRow =
			(ISubWindowListRow) linkComponent;
		final Map options = subWindowListRow.getReturnOptions();
		final Object parameters = getParameters(linkComponent);
		final MapTree mapTree = new MapTree();
		final Iterator iterator = options.keySet().iterator();

		while (iterator.hasNext()) {
			final String propName = String.valueOf(iterator.next());
			final String targetObj = String.valueOf(options.get(propName));
			final String value = getPropValue(parameters, propName);
			mapTree.put("link." + propName + ".targetObj", targetObj);
			mapTree.put("link." + propName + ".value", value);
		}
		final ValueTagWriter tagWriter = new ValueTagWriter(bodyWriter);
		tagWriter.getExtraAttributes().put("style", "display:none");
		tagWriter.addProperties(mapTree.getRoot());
	}

	public String getPropValue(Object params, String propName) {
		if (params instanceof Map) {
			final Map paramMap = (Map) params;
			return String.valueOf(paramMap.get(propName));
		} else {
			try {
				return BeanUtils.getProperty(params, propName);
			} catch (Exception e) {
				return "";
			}
		}
	}

	protected Object getParameters(ILinkComponent linkComponent) {
		try {
			return PropertyUtils.getProperty(linkComponent, "parameters");
		} catch (Exception e) {
			return null;
		}
	}

}
