/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/25
 */
package org.asyrinx.brownie.spring.jdbc;

import java.sql.Connection;

import org.springframework.jdbc.datasource.SmartDataSource;

/**
 * @author akima
 */
public class LogDataSource
	extends org.asyrinx.brownie.jdbc.logger.LogDataSource
	implements SmartDataSource {

	/**
	 * 
	 */
	public LogDataSource() {
		super();
	}

	/**
	 * @see org.springframework.jdbc.datasource.SmartDataSource#shouldClose(java.sql.Connection)
	 */
	public boolean shouldClose(Connection conn) {
		if (getSource() instanceof SmartDataSource)
			return ((SmartDataSource) getSource()).shouldClose(conn);
		else
			throw new UnsupportedOperationException("the source DataSource object doesn't implement SmartDataSource interface.");
	}

}
