/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author Akima
 */
public final class ServletUtils {

	/**
	 * Constructor for ServletUtils.
	 */
	private ServletUtils() {
		super();
	}

	static public Map parametersToMap(ServletConfig config) {
		final Map result = new HashMap();
		final Enumeration enum = config.getInitParameterNames();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			result.put(key, config.getInitParameter(key));
		}
		return result;
	}

	static public Map parametersToMap(ServletContext context) {
		final Map result = new HashMap();
		final Enumeration enum = context.getInitParameterNames();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			result.put(key, context.getInitParameter(key));
		}
		return result;
	}

	static public Map attributesToMap(ServletContext context) {
		final Map result = new HashMap();
		final Enumeration enum = context.getAttributeNames();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			result.put(key, context.getAttribute(key));
		}
		return result;
	}

	static public Map attributesToMap(HttpSession session) {
		final Map result = new HashMap();
		final Enumeration enum = session.getAttributeNames();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			result.put(key, session.getAttribute(key));
		}
		return result;
	}

	static public Map attributesToMap(HttpServletRequest req) {
		final Map result = new HashMap();
		final Enumeration enum = req.getAttributeNames();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			result.put(key, req.getAttribute(key));
		}
		return result;
	}

	static public Map parametersToMap(HttpServletRequest req) {
		final Map result = new HashMap();
		final Enumeration enum = req.getParameterNames();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			String data = req.getParameter(key);
			result.put(key, data);
		}
		return result;
	}

	static public Map headerToMap(HttpServletRequest req) {
		final Map result = new HashMap();
		final Enumeration enum = req.getHeaderNames();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			String data = req.getHeader(key);
			result.put(key, data);
		}
		return result;
	}

	static public String reqToStr(HttpServletRequest req) {
		final StringBuffer result = new StringBuffer();
		result.append("\nUri=" + req.getRequestURI());
		result.append("\nMethod=" + req.getMethod());
		result.append("\nParameters=" + parametersToMap(req));
		result.append("\nAttributes=" + attributesToMap(req));
		result.append("\nQueryString=" + req.getQueryString());
		result.append("\nHeaders=" + headerToMap(req));
		result.append("\nPathInfo=" + req.getPathInfo());
		result.append("\nPathTranslated=" + req.getPathTranslated());
		result.append("\nRequestedSessionId=" + req.getRequestedSessionId());
		result.append("\nRemoteAddr=" + req.getRemoteAddr());
		result.append("\nRemoteHost=" + req.getRemoteHost());
		result.append("\nRemoteUser=" + req.getRemoteUser());
		result.append("\nSession=" + req.getSession());
		result.append("\nScheme=" + req.getScheme());
		result.append("\nServerName=" + req.getServerName());
		result.append("\nServerPort=" + req.getServerPort());
		result.append("\nServletPath=" + req.getServletPath());
		result.append("\nCookies=" + ArrayUtils.toArrayList(req.getCookies()));
		result.append("\nEncoding=" + req.getCharacterEncoding());
		result.append("\nAuthType=" + req.getAuthType());

		return result.toString();
	}

	/**
	 * T[o[TChɂHTTPwb_ւ̃LbVw
	 * @param HttpServletResponse res
	 * @return Ȃ
	 */
	public static void setNoCache(HttpServletResponse res) {
		res.setHeader("Pragma", "no-chace"); // LbVvO}wb_
		res.setHeader("Cahce-Control", "no-store"); // LbVRg[wb_
		long lngCurrentTm = System.currentTimeMillis(); // 
		long lngValidTm = (60 * 1000) * 5; // T
		res.setDateHeader("Expires", lngCurrentTm + lngValidTm); // L
	}
	/**
	 * w胊NGXgtqk̎擾<BR>
	 * p[^܂߂ŕ쐬iPOSTp[^GETp[^ɕϊj
	 * jhttp://xxx.org/AAAA.jsp?PAGE=123456&AAA=9999
	 * @param  HttpServletRequest    p_Req        HttpServletRequestIuWFNg
	 * @return  String  tqkiHttpRequestj
	 */
	public static String getFullURL(HttpServletRequest req) {
		final Enumeration enumPrms = req.getParameterNames(); // p[^񋓃IuWFNg
		String params = ""; // p[^
		while (enumPrms.hasMoreElements()) {
			// NGXg̕ϐ擾
			final String paramName = (String) enumPrms.nextElement();
			if (StringUtils.isAvailable(params))
				params += "&";
			params += paramName
				+ "="
				+ StringUtils.nullTrim(req.getParameter(paramName));
		}
		final String result = req.getRequestURI(); // tqk
		if (StringUtils.isAvailable(params))
			return result + "?" + params; // p[^ t
		else
			return result;
	}

}
