/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/27
 */
package org.asyrinx.brownie.servlet;

import java.io.File;

import javax.servlet.ServletContext;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.io.FileNameUtils;

/**
 * @author akima
 */
public class FileNameResolver {

	/**
	 * 
	 */
	public FileNameResolver(ServletContext servletContext) {
		super();
		this.servletContext = servletContext;
		this.contextRootPath = servletContext.getRealPath("/");
	}

	protected final ServletContext servletContext;
	protected final String contextRootPath;

	public String toRealPath(String path) {
		if (this.servletContext == null)
			throw new RuntimeException("servletContext is null!! ");
		if (StringUtils.isEmpty(path))
			return this.contextRootPath;
		final File origPathFile = new File(path);
		if (origPathFile.exists()) {
			this.servletContext.log(
				this.getClass().getName() + ": '" + path + "' exists.");
			return path;
		}
		if (origPathFile.isAbsolute()) {
			this.servletContext.log(
				this.getClass().getName()
					+ ": '"
					+ path
					+ "' is an absolute path.");
			return path;
		}
		final String realPath =
			FileNameUtils.toAbsolutePath(this.contextRootPath, path);
		this.servletContext.log(
			this.getClass().getName()
				+ ": '"
				+ path
				+ "' ----> '"
				+ realPath
				+ "'");
		return realPath;
	}
}
