/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/27
 */
package org.asyrinx.brownie.log.log4j.servlet;

import javax.servlet.ServletContext;

import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.FileWatchdog;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.xml.DOMConfigurator;
import org.asyrinx.brownie.servlet.FileNameResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author akima
 */
public class ServletDOMConfigurator extends DOMConfigurator {

	/**
	 * 
	 */
	public ServletDOMConfigurator(ServletContext servletContext) {
		super();
		if (servletContext == null)
			throw new RuntimeException("servletContext == null");
		this.resolver = new FileNameResolver(servletContext);
	}

	protected final FileNameResolver resolver;

	protected Appender parseAppender(Element appenderElement) {
		String className = subst(appenderElement.getAttribute("class"));
		LogLog.debug("Class name: [" + className + ']');
		try {
			Object instance = Loader.loadClass(className).newInstance();
			Appender appender = (Appender) instance;
			PropertySetter propSetter = new PropertySetter(appender);
			appender.setName(subst(appenderElement.getAttribute("name")));
			NodeList children = appenderElement.getChildNodes();
			int length = children.getLength();
			for (int loop = 0; loop < length; loop++) {
				Node currentNode = children.item(loop);
				if (currentNode.getNodeType() == 1) {
					Element currentElement = (Element) currentNode;
					if (currentElement.getTagName().equals("param")) {

						//convert from relative file path to real path.
						if ("file"
							.equalsIgnoreCase(
								currentElement.getAttribute("name"))) {
							currentElement.setAttribute(
								"value",
								this.resolver.toRealPath(
									currentElement.getAttribute("value")));
						}

						setParameter(currentElement, propSetter);
					} else if (currentElement.getTagName().equals("layout")) {
						appender.setLayout(parseLayout(currentElement));
					} else if (currentElement.getTagName().equals("filter")) {
						parseFilters(currentElement, appender);
					} else if (
						currentElement.getTagName().equals("errorHandler")) {
						parseErrorHandler(currentElement, appender);
					} else if (
						currentElement.getTagName().equals("appender-ref")) {
						String refName =
							subst(currentElement.getAttribute("ref"));
						if (appender instanceof AppenderAttachable) {
							AppenderAttachable aa =
								(AppenderAttachable) appender;
							LogLog.debug(
								"Attaching appender named ["
									+ refName
									+ "] to appender named ["
									+ appender.getName()
									+ "].");
							aa.addAppender(
								findAppenderByReference(currentElement));
						} else {
							LogLog.error(
								"Requesting attachment of appender named ["
									+ refName
									+ "] to appender named ["
									+ appender.getName()
									+ "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
						}
					}
				}
			}

			propSetter.activate();
			return appender;
		} catch (Exception oops) {
			LogLog.error(
				"Could not create an Appender. Reported error follows.",
				oops);
		}
		return null;
	}

	static public void configure(
		String configFilename,
		ServletContext servletContext) {
		if (servletContext == null)
			throw new RuntimeException("servletContext == null");
		servletContext.log(
			ServletDOMConfigurator.class.getName()
				+ "#configure(\""
				+ configFilename
				+ "\")");
		ServletDOMConfigurator configurator =
			new ServletDOMConfigurator(servletContext);
		configurator.doConfigure(
			configFilename,
			LogManager.getLoggerRepository());
	}

	/**
		   Like {@link #configureAndWatch(String, long)} except that the
		   default delay as defined by {@link FileWatchdog#DEFAULT_DELAY} is
		   used. 
	
		   @param configFilename A log4j configuration file in XML format.
	
		*/
	static public void configureAndWatch(
		String configFilename,
		ServletContext servletContext) {
		if (servletContext == null)
			throw new RuntimeException("servletContext == null");
		configureAndWatch(
			configFilename,
			FileWatchdog.DEFAULT_DELAY,
			servletContext);
	}

	/**
	   Read the configuration file <code>configFilename</code> if it
	   exists. Moreover, a thread will be created that will periodically
	   check if <code>configFilename</code> has been created or
	   modified. The period is determined by the <code>delay</code>
	   argument. If a change or file creation is detected, then
	   <code>configFilename</code> is read to configure log4j.  
	
		@param configFilename A log4j configuration file in XML format.
		@param delay The delay in milliseconds to wait between each check.
	*/
	static public void configureAndWatch(
		String configFilename,
		long delay,
		ServletContext servletContext) {
		if (servletContext == null)
			throw new RuntimeException("servletContext == null");
			servletContext.log(
				ServletDOMConfigurator.class.getName()
					+ "#configureAndWatch(\""
					+ configFilename
					+ "\")");
		ServletXmlWatchdog xdog =
			new ServletXmlWatchdog(configFilename, servletContext);
		xdog.setDelay(delay);
		xdog.start();
	}

}
class ServletXmlWatchdog extends FileWatchdog {

	ServletXmlWatchdog(String filename, ServletContext servletContext) {
		super(filename);
		if (servletContext == null)
			throw new RuntimeException("servletContext == null");
		this.servletContext = servletContext;
	}

	final ServletContext servletContext;

	/**
		 Call {@link PropertyConfigurator#configure(String)} with the
		 <code>filename</code> to reconfigure log4j. */
	public void doOnChange() {
		if (this.servletContext == null)
			throw new RuntimeException("servletContext == null");

		new ServletDOMConfigurator(this.servletContext).doConfigure(
			filename,
			LogManager.getLoggerRepository());
	}
}
