/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

/**
 * @author Akima
 */
public class PreparedStatementWrapper
	extends StatementWrapper
	implements PreparedStatement {

	/**
	 * Constructor for PreparedStatementWrapper.
	 */
	public PreparedStatementWrapper(PreparedStatement source) {
		super(source);
		this.source = source;
	}

	private final PreparedStatement source;

	/**
	 * @throws java.sql.SQLException
	 */
	public void addBatch() throws SQLException {
		source.addBatch();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void clearParameters() throws SQLException {
		source.clearParameters();
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public boolean execute() throws SQLException {
		return source.execute();
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public ResultSet executeQuery() throws SQLException {
		return source.executeQuery();
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public int executeUpdate() throws SQLException {
		return source.executeUpdate();
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public ResultSetMetaData getMetaData() throws SQLException {
		return source.getMetaData();
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public ParameterMetaData getParameterMetaData() throws SQLException {
		return source.getParameterMetaData();
	}

	/**
	 * @param i
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setArray(int i, Array x) throws SQLException {
		source.setArray(i, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setAsciiStream(int parameterIndex, InputStream x, int length)
		throws SQLException {
		source.setAsciiStream(parameterIndex, x, length);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBigDecimal(int parameterIndex, BigDecimal x)
		throws SQLException {
		source.setBigDecimal(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setBinaryStream(int parameterIndex, InputStream x, int length)
		throws SQLException {
		source.setBinaryStream(parameterIndex, x, length);
	}

	/**
	 * @param i
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBlob(int i, Blob x) throws SQLException {
		source.setBlob(i, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBoolean(int parameterIndex, boolean x) throws SQLException {
		source.setBoolean(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setByte(int parameterIndex, byte x) throws SQLException {
		source.setByte(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBytes(int parameterIndex, byte[] x) throws SQLException {
		source.setBytes(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param reader
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setCharacterStream(
		int parameterIndex,
		Reader reader,
		int length)
		throws SQLException {
		source.setCharacterStream(parameterIndex, reader, length);
	}

	/**
	 * @param i
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setClob(int i, Clob x) throws SQLException {
		source.setClob(i, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setDate(int parameterIndex, Date x) throws SQLException {
		source.setDate(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setDate(int parameterIndex, Date x, Calendar cal)
		throws SQLException {
		source.setDate(parameterIndex, x, cal);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setDouble(int parameterIndex, double x) throws SQLException {
		source.setDouble(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setFloat(int parameterIndex, float x) throws SQLException {
		source.setFloat(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setInt(int parameterIndex, int x) throws SQLException {
		source.setInt(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setLong(int parameterIndex, long x) throws SQLException {
		source.setLong(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param sqlType
	 * @throws java.sql.SQLException
	 */
	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		source.setNull(parameterIndex, sqlType);
	}

	/**
	 * @param paramIndex
	 * @param sqlType
	 * @param typeName
	 * @throws java.sql.SQLException
	 */
	public void setNull(int paramIndex, int sqlType, String typeName)
		throws SQLException {
		source.setNull(paramIndex, sqlType, typeName);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setObject(int parameterIndex, Object x) throws SQLException {
		source.setObject(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @param targetSqlType
	 * @throws java.sql.SQLException
	 */
	public void setObject(int parameterIndex, Object x, int targetSqlType)
		throws SQLException {
		source.setObject(parameterIndex, x, targetSqlType);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @param targetSqlType
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void setObject(
		int parameterIndex,
		Object x,
		int targetSqlType,
		int scale)
		throws SQLException {
		source.setObject(parameterIndex, x, targetSqlType, scale);
	}

	/**
	 * @param i
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setRef(int i, Ref x) throws SQLException {
		source.setRef(i, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setShort(int parameterIndex, short x) throws SQLException {
		source.setShort(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setString(int parameterIndex, String x) throws SQLException {
		source.setString(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setTime(int parameterIndex, Time x) throws SQLException {
		source.setTime(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setTime(int parameterIndex, Time x, Calendar cal)
		throws SQLException {
		source.setTime(parameterIndex, x, cal);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setTimestamp(int parameterIndex, Timestamp x)
		throws SQLException {
		source.setTimestamp(parameterIndex, x);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal)
		throws SQLException {
		source.setTimestamp(parameterIndex, x, cal);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 * @deprecated
	 */
	public void setUnicodeStream(int parameterIndex, InputStream x, int length)
		throws SQLException {
		//preparedStatement.setUnicodeStream(parameterIndex, x, length);
	}

	/**
	 * @param parameterIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setURL(int parameterIndex, URL x) throws SQLException {
		source.setURL(parameterIndex, x);
	}

}
