/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/22
 */
package org.asyrinx.brownie.jdbc.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

import org.asyrinx.brownie.core.io.sf.ClassResourceStreamFactory;
import org.asyrinx.brownie.core.io.sf.StringLoader;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author akima
 */
public class JdbcServerServiceImpl implements JdbcServerService {

	/**
	 * 
	 */
	public JdbcServerServiceImpl() {
		super();
	}

	/**
	 * 
	 */
	public JdbcServerServiceImpl(Connection connection) {
		super();
		setConnection(connection);
	}

	private Connection connection = null;

	/**
	 * @return
	 */
	public Connection getConnection() {
		return connection;
	}

	/**
	 * @param connection
	 */
	public void setConnection(Connection connection) {
		this.connection = connection;
		if (this.connection == null)
			jdbcDriver = null;
	}

	private JdbcDriverType jdbcDriver = null;

	private void initDriver() throws SQLException {
		if (this.getConnection() == null)
			throw new SQLException("connection not found.");
		if (jdbcDriver == null)
			jdbcDriver = JdbcDriverType.get(this.connection);
	}

	public Date getCurrentDate() throws SQLException {
		final ResultSet rs = executeNoParamSql("currentDate.sql");
		if (rs.next())
			return rs.getDate(1);
		else
			throw new SQLException("failed to retrieve current date.");
	}

	public Time getCurrentTime() throws SQLException {
		final ResultSet rs = executeNoParamSql("currentTime.sql");
		if (rs.next())
			return rs.getTime(1);
		else
			throw new SQLException("failed to retrieve current time.");
	}

	public Timestamp getCurrentTimestamp() throws SQLException {
		final ResultSet rs = executeNoParamSql("currentTimestamp.sql");
		if (rs.next())
			return rs.getTimestamp(1);
		else
			throw new SQLException("failed to retrieve current timestamp.");
	}

	protected final ResultSet executeNoParamSql(String filename)
		throws SQLException {
		initDriver();
		final String sql;
		try {
			sql = getSql(filename);
		} catch (IOException e) {
			throw new SQLException(e.getMessage());
		}
		final PreparedStatement st = getConnection().prepareStatement(sql);
		return st.executeQuery();
	}

	private static final String PATH_SQL = getPathSql();

	private static String getPathSql() {
		return StringUtils.replace(
			JdbcServerServiceImpl.class.getPackage().getName() + ".sql",
			'.',
			'/');
	}

	private StringLoader loader = null;

	public String getSql(String filename) throws IOException {
		if (loader == null)
			loader = new StringLoader(new ClassResourceStreamFactory());
		return loader.load(
			PATH_SQL + "/" + jdbcDriver.getInnerName() + "/" + filename);
	}

}
