/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.wrapper;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.type.Type;

/**
 * @author akima
 */
public class ScrollableResultsWrapper implements ScrollableResults {

	/**
	 * 
	 */
	public ScrollableResultsWrapper(ScrollableResults wrapped) {
		super();
		this.wrapped = wrapped;
	}

	protected final ScrollableResults wrapped;

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void afterLast() throws HibernateException {
		wrapped.afterLast();
	}

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void beforeFirst() throws HibernateException {
		wrapped.beforeFirst();
	}

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void close() throws HibernateException {
		wrapped.close();
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public boolean first() throws HibernateException {
		return wrapped.first();
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object[] get() throws HibernateException {
		return wrapped.get();
	}

	/**
	 * @param i
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object get(int i) throws HibernateException {
		return wrapped.get(i);
	}

	/**
	 * @param i
	 * @param type
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object get(int i, Type type) throws HibernateException {
		return wrapped.get(i, type);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public BigDecimal getBigDecimal(int col) throws HibernateException {
		return wrapped.getBigDecimal(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public byte[] getBinary(int col) throws HibernateException {
		return wrapped.getBinary(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Blob getBlob(int col) throws HibernateException {
		return wrapped.getBlob(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Boolean getBoolean(int col) throws HibernateException {
		return wrapped.getBoolean(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Byte getByte(int col) throws HibernateException {
		return wrapped.getByte(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Calendar getCalendar(int col) throws HibernateException {
		return wrapped.getCalendar(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Character getCharacter(int col) throws HibernateException {
		return wrapped.getCharacter(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Clob getClob(int col) throws HibernateException {
		return wrapped.getClob(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Date getDate(int col) throws HibernateException {
		return wrapped.getDate(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Double getDouble(int col) throws HibernateException {
		return wrapped.getDouble(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Float getFloat(int col) throws HibernateException {
		return wrapped.getFloat(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Integer getInteger(int col) throws HibernateException {
		return wrapped.getInteger(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Locale getLocale(int col) throws HibernateException {
		return wrapped.getLocale(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Long getLong(int col) throws HibernateException {
		return wrapped.getLong(col);
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public int getRowNumber() throws HibernateException {
		return wrapped.getRowNumber();
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Short getShort(int col) throws HibernateException {
		return wrapped.getShort(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public String getString(int col) throws HibernateException {
		return wrapped.getString(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public String getText(int col) throws HibernateException {
		return wrapped.getText(col);
	}

	/**
	 * @param col
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public TimeZone getTimeZone(int col) throws HibernateException {
		return wrapped.getTimeZone(col);
	}

	/**
	 * @param i
	 * @return
	 */
	public Type getType(int i) {
		return wrapped.getType(i);
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public boolean isFirst() throws HibernateException {
		return wrapped.isFirst();
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public boolean isLast() throws HibernateException {
		return wrapped.isLast();
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public boolean last() throws HibernateException {
		return wrapped.last();
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public boolean next() throws HibernateException {
		return wrapped.next();
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public boolean previous() throws HibernateException {
		return wrapped.previous();
	}

	/**
	 * @param i
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public boolean scroll(int i) throws HibernateException {
		return wrapped.scroll(i);
	}

	/**
	 * @param rowNumber
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public boolean setRowNumber(int rowNumber) throws HibernateException {
		return wrapped.setRowNumber(rowNumber);
	}

}
