/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.logger;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;

import javax.naming.NamingException;
import javax.naming.Reference;

import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.metadata.CollectionMetadata;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.hibernate.wrapper.SessionFactoryWrapper;

/**
 * @author akima
 */
public class LogSessionFactory extends SessionFactoryWrapper {

	/**
	 * 
	 */
	public LogSessionFactory() {
		super();
		this.log = new CascadeNamedLog(this.getClass());
	}

	/**
	 * 
	 */
	public LogSessionFactory(SessionFactory source, CascadeNamedLog parentLog) {
		super();
		setSource(source);
		this.log = parentLog.subLog(source);
	}

	private final CascadeNamedLog log;

	/**
	 * @return
	 */
	public String getDefaultLevel() {
		return log.getDefaultLevel();
	}

	/**
	 * @return
	 */
	public String getLoggerName() {
		return log.getLoggerName();
	}

	/**
	 * @param string
	 */
	public void setDefaultLevel(String string) {
		log.setDefaultLevel(string);
	}

	/**
	 * @param string
	 */
	public void setLoggerName(String string) {
		log.setLoggerName(string);
	}

	private DispatchLog getLog() {
		return log;
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#close()
	 */
	public void close() throws HibernateException {
		getLog().log("close()");
		super.close();
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#evict(java.lang.Class, java.io.Serializable)
	 */
	public void evict(Class persistentClass, Serializable id)
		throws HibernateException {
		getLog().log("evict(" + persistentClass.getName() + ", " + id + ")");
		super.evict(persistentClass, id);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#evict(java.lang.Class)
	 */
	public void evict(Class persistentClass) throws HibernateException {
		getLog().log("evict(" + persistentClass.getName() + ")");
		super.evict(persistentClass);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#evictCollection(java.lang.String, java.io.Serializable)
	 */
	public void evictCollection(String roleName, Serializable id)
		throws HibernateException {
		getLog().log("evict(" + roleName + ", " + id + ")");
		super.evictCollection(roleName, id);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#evictCollection(java.lang.String)
	 */
	public void evictCollection(String roleName) throws HibernateException {
		getLog().log("evict(" + roleName + ")");
		super.evictCollection(roleName);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#evictQueries()
	 */
	public void evictQueries() throws HibernateException {
		getLog().log("evictQueries()");
		super.evictQueries();
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#evictQueries(java.lang.String)
	 */
	public void evictQueries(String cacheRegion) throws HibernateException {
		getLog().log("evictQueries(" + cacheRegion + ")");
		super.evictQueries(cacheRegion);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#getAllClassMetadata()
	 */
	public Map getAllClassMetadata() throws HibernateException {
		return super.getAllClassMetadata();
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#getAllCollectionMetadata()
	 */
	public Map getAllCollectionMetadata() throws HibernateException {
		return super.getAllCollectionMetadata();
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#getClassMetadata(java.lang.Class)
	 */
	public ClassMetadata getClassMetadata(Class persistentClass)
		throws HibernateException {
		return super.getClassMetadata(persistentClass);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#getCollectionMetadata(java.lang.String)
	 */
	public CollectionMetadata getCollectionMetadata(String roleName)
		throws HibernateException {
		return super.getCollectionMetadata(roleName);
	}

	/**
	 * @see javax.naming.Referenceable#getReference()
	 */
	public Reference getReference() throws NamingException {
		return super.getReference();
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#openDatabinder()
	 */
	public Databinder openDatabinder() throws HibernateException {
		getLog().log("openDatabinder()");
		return new LogDatabinder(super.openDatabinder(), log);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#openSession()
	 */
	public Session openSession() throws HibernateException {
		getLog().log("openSession()");
		return new LogSession(super.openSession(), log);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#openSession(java.sql.Connection, net.sf.hibernate.Interceptor)
	 */
	public Session openSession(
		Connection connection,
		Interceptor interceptor) {
		getLog().log("openSession(" + connection + ", " + interceptor + ")");
		return new LogSession(super.openSession(connection, interceptor), log);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#openSession(java.sql.Connection)
	 */
	public Session openSession(Connection connection) {
		getLog().log("openSession(" + connection + ")");
		return new LogSession(super.openSession(connection), log);
	}

	/**
	 * @see net.sf.hibernate.SessionFactory#openSession(net.sf.hibernate.Interceptor)
	 */
	public Session openSession(Interceptor interceptor)
		throws HibernateException {
		getLog().log("openSession(" + interceptor + ")");
		return new LogSession(super.openSession(interceptor), log);
	}

}
