/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.xml.digester;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

/**
 * @author Akima
 */
public class StackSetPropertyRule extends Rule {

	/**
	 * Constructor for StackSetPropertyRule.
	 */
	public StackSetPropertyRule(String propertyName) {
		super();
		this.propertyName = propertyName;
	}

	private final String propertyName;

	/**
	 * @see org.apache.commons.digester.Rule#begin(org.xml.sax.Attributes)
	 * @deprecated
	 */
	public void begin(Attributes arg0) throws Exception {
		Object bean = digester.peek(1);
		Object value = digester.peek(0);
		BeanUtils.setProperty(bean, propertyName, value);
	}

	/**
	 * @see org.apache.commons.digester.Rule#begin(java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	public void begin(String namespace, String name, Attributes attributes)
		throws Exception {
		Object bean = digester.peek(1);
		Object value = digester.peek(0);
		BeanUtils.setProperty(bean, propertyName, value);
	}

}
