/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.xml.digester;

import javax.xml.parsers.SAXParser;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.XMLReader;

/**
 * @author Akima
 */
public class SettingDigester extends Digester {

	static public final String ATTRIBUTE_CLASS_DEFAULT = "class";

	/**
	 * Constructor for SettingDigester.
	 */
	public SettingDigester() {
		super();
	}

	/**
	 * Constructor for SettingDigester.
	 * @param parser
	 */
	public SettingDigester(SAXParser parser) {
		super(parser);
	}

	/**
	 * Constructor for SettingDigester.
	 * @param reader
	 */
	public SettingDigester(XMLReader reader) {
		super(reader);
	}

	protected final Log log = LogFactory.getLog(this.getClass());

	/**
	 * Method addSettingRoot.
	 * @param string
	 * @param class
	 */
	public void addRoot(String pattern, Class clazz) {
		addRoot(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
	}

	/**
	 * Method addSettingRoot.
	 * @param string
	 * @param class
	 */
	public void addRoot(String pattern, String attributeName, Class clazz) {
		addObjectCreate(pattern, attributeName, clazz);
	}

	/**
	 * Method addSettingRoot.
	 * @param string
	 * @param class
	 */
	public void addRoot(String pattern, String className) {
		addRoot(pattern, className, ATTRIBUTE_CLASS_DEFAULT);
	}

	/**
	 * Method addSettingRoot.
	 * @param string
	 * @param class
	 */
	public void addRoot(
		String pattern,
		String className,
		String attributeName) {
		addObjectCreate(pattern, className, attributeName);
	}

	public void addProp(
		String pattern,
		Class clazz,
		String propertyName,
		boolean setProperties) {
		addObjectCreate(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
		addRule(pattern, new StackSetPropertyRule(propertyName));
		if (setProperties)
			addSetProperties(pattern);
	}

	public void addProp(String pattern, Class clazz, String propertyName) {
		addProp(pattern, clazz, propertyName, true);
	}

	/**
	 * Method addNewProperties.
	 * @param string
	 * @param class
	 * @param string1
	 */
	public void addProps(
		String pattern,
		Class clazz,
		String addingMethodName) {
		addObjectCreate(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
		addSetProperties(pattern);
		addSetNext(pattern, addingMethodName);
		//addSetProperty(pattern, "property", "value");
		addSetProperties(pattern);
	}

	/**
	 * Method addNewProperties.
	 * @param string
	 * @param class
	 */
	public void addProps(String pattern, Class clazz) {
		addProps(pattern, clazz, "add");
	}

	/**
	 * @see org.apache.commons.digester.Digester#addCallMethod(java.lang.String, java.lang.String, int, java.lang.Class[])
	 */
	public void addCallMethod(
		String pattern,
		String methodName,
		Class[] paramTypes,
		String[] attributeName) {
		addCallMethod(pattern, methodName, paramTypes.length, paramTypes);
		for (int i = 0; i < attributeName.length; i++) {
			addCallParam(pattern, i, attributeName[i]);
		}
	}
}
