/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

import java.util.Calendar;
import java.util.Date;

/**
 * t݂̂\NXłB
 * @author akima
 */
public final class SimpleDate {

	private final int year;
	private final int month;
	private final int day;

	/**
	 * 
	 */
	public SimpleDate(int year, int month, int day) {
		super();
		this.year = year;
		this.month = month;
		this.day = day;
	}

	/**
	 * 
	 */
	public SimpleDate(Date d) {
		this(d, Calendar.getInstance());
	}

	/**
	 * 
	 */
	public SimpleDate(Date d, Calendar calendar) {
		super();
		calendar.setTime(d);
		this.year = calendar.get(Calendar.YEAR);
		this.month = calendar.get(Calendar.MONTH);
		this.day = calendar.get(Calendar.DAY_OF_MONTH);
	}

	/**
	 * @return
	 */
	public Date toDate() {
		return toDateBegin();
	}

	/**
	 * @return
	 */
	public Date toDateBegin() {
		return DateUtils.toDateBegin(year, month, day);
	}

	/**
	 * @return
	 */
	public Date toDateEnd() {
		return DateUtils.toDateEnd(year, month, day);
	}

	/**
	 * @param obj
	 * @return
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof SimpleDate) {
			final SimpleDate date = (SimpleDate) obj;
			return (this.year == date.year)
				&& (this.month == date.month)
				&& (this.day == date.day);
		} else if (obj instanceof Date) {
			return this.equals(new SimpleDate((Date) obj));
		} else {
			return super.equals(obj);
		}
	}

	public boolean after(SimpleDate when) {
		if (when.year < this.year) {
			return true;
		} else if (when.year > this.year) {
			return false;
		} else {
			if (when.month < this.month) {
				return true;
			} else if (when.month > this.month) {
				return false;
			} else {
				return when.day < this.day;
			}
		}
	}

	public boolean before(SimpleDate when) {
		if (when.year > this.year) {
			return true;
		} else if (when.year < this.year) {
			return false;
		} else {
			if (when.month > this.month) {
				return true;
			} else if (when.month < this.month) {
				return false;
			} else {
				return when.day > this.day;
			}
		}
	}

	/**
	 * @return
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return year + "/" + month + "/" + day;
	}

	/**
	 * @return
	 */
	public int getDay() {
		return day;
	}

	/**
	 * @return
	 */
	public int getMonth() {
		return month;
	}

	/**
	 * @return
	 */
	public int getYear() {
		return year;
	}

}
