/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

import java.util.Calendar;
import java.util.Date;

/**
 * @author akima
 */
public final class DateUtils {

	/**
	 * w肳ꂽt000b0~bɐݒ肳ꂽDateIuWFNgԂ
	 * @param y
	 * @param m
	 * @param d
	 * @return
	 */
	public static Date toDateBegin(int y, int m, int d) {
		return toDateTime(y, m, d, 0, 0, 0, 0);
	}

	/**
	 * w肳ꂽt235959b999~bɐݒ肳ꂽDateIuWFNgԂ
	 * @param y
	 * @param m
	 * @param d
	 * @return
	 */
	public static Date toDateEnd(int y, int m, int d) {
		return toDateTime(y, m, d, 23, 59, 59, 999);
	}

	public static Date toDateTime(
		int year,
		int month,
		int day,
		int hours,
		int minuites,
		int seconds,
		int milliseconds) {
		final Calendar cal = Calendar.getInstance();
		cal.set(year, month, day, hours, minuites, seconds);
		cal.set(Calendar.MILLISECOND, milliseconds);
		return new Date(cal.getTime().getTime());
	}

	public static Date adjustDateTime(
		Date d,
		int hours,
		int minuites,
		int seconds,
		int miliseconds) {
		final Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		return toDateTime(
			cal.get(Calendar.YEAR),
			cal.get(Calendar.MONTH),
			cal.get(Calendar.DAY_OF_MONTH),
			hours,
			minuites,
			seconds,
			miliseconds);
	}

	public static Date adjustDateBegin(Date d) {
		return adjustDateTime(d, 0, 0, 0, 0);
	}

	public static Date adjustDateEnd(Date d) {
		return adjustDateTime(d, 23, 59, 59, 999);
	}

	public static int get(Date d, int calendarField) {
		final Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		return cal.get(calendarField);
	}

	public static int getYear(Date d) {
		return get(d, Calendar.YEAR);
	}

	public static int getMonth(Date d) {
		return get(d, Calendar.MONTH);
	}

	public static int getDay(Date d) {
		return get(d, Calendar.DAY_OF_MONTH);
	}

}
