/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

import java.util.Date;

import org.apache.commons.lang.ObjectUtils;

/**
 * @author akima
 */
public class DateRange {

	/**
	 * 
	 */
	public DateRange(Date from, Date to) {
		super();
		this.from = from;
		this.to = to;
	}

	private final Date from;
	private final Date to;

	/**
	 * @param obj
	 * @return
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof DateRange) {
			final DateRange range = (DateRange) obj;
			return ObjectUtils.equals(this.from, range.from)
				&& ObjectUtils.equals(this.to, range.to);
		} else {
			return super.equals(obj);
		}
	}

	public boolean include(Date when) {
		if (from == null && to == null) {
			return false;
		} else if (from != null && to == null) {
			return from.before(when);
		} else if (from == null && to != null) {
			return to.after(when);
		} else {
			return from.before(when) && to.after(when);
		}
	}

	/**
	 * @return
	 */
	public Date getFrom() {
		return from;
	}

	/**
	 * @return
	 */
	public Date getTo() {
		return to;
	}

}
