/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/12
 */
package org.asyrinx.brownie.core.user;

import org.apache.commons.lang.exception.NestableRuntimeException;
import org.asyrinx.brownie.core.lang.ClassUtils;

/**
 * @author akima
 */
public class LoginManager {

	/**
	 * 
	 */
	public LoginManager(IUserCertifier certifier) {
		super();
		this.certifier = certifier;
	}

	/**
	 * 
	 */
	public LoginManager(String certifierClassName) {
		this(newCertifier(certifierClassName));
	}

	private static IUserCertifier newCertifier(String certifierClassName) {
		try {
			return (IUserCertifier) ClassUtils.newObject(
				certifierClassName,
				IUserCertifier.class);
		} catch (InstantiationException e) {
			throw new NestableRuntimeException(e);
		}
	}

	protected final IUserCertifier certifier;

	public IUser tryLogin(String userId, String password) {
		if (certifier == null)
			return null;
		return certifier.canLogin(userId, password);
	}

}
