/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.sql2;

/**
 * @author akima
 */
public class Fields extends Elements {

	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	/**
	 * tB[hQǉ܂B
	 * @param fields
	 */
	public Fields addNewFields() {
		final Fields result = new Fields();
		super.addImpl(result);
		return result;
	}

	/**
	 * tB[hǉ܂B
	 * @param field
	 */
	public Fields add(String field) {
		return add(null, field, null);
	}

	/**
	 * e[uiGCAXjAtB[hAtB[hGCAXA֐w肵
	 * tB[hǉ郁\bhłB
	 * <br>
	 * 1:  [tB[h] 
	 * 2:  [tB[h] as [tB[hGCAX]
	 * 3:  [e[uiGCAXj].[tB[h]  
	 * 4:  [e[uiGCAXj].[tB[h]  as [tB[hGCAX]
	 */
	public Fields add(String tableAlias, String fieldName, String aliasName) {
		return add(tableAlias, fieldName, aliasName, null);
	}

	/**
	 * e[uiGCAXjAtB[hAtB[hGCAXA֐w肵
	 * tB[hǉ郁\bhłB
	 * <br>
	 * 1:  [tB[h] 
	 * 2:  [tB[h] as [tB[hGCAX]
	 * 3:  [e[uiGCAXj].[tB[h]  
	 * 4:  [e[uiGCAXj].[tB[h]  as [tB[hGCAX]
	 * 5:  [֐] ( [tB[h] ) 
	 * 6:  [֐] ( [tB[h] ) as [tB[hGCAX]
	 * 7:  [֐] ( [e[uiGCAXj].[tB[h] ) as [tB[hGCAX]
	 */
	public Fields add(
		String tableAlias,
		String fieldName,
		String aliasName,
		String functionName) {
		final Field result = new Field();
		result.setTableAlias(tableAlias);
		result.setFieldName(fieldName);
		result.setAliasName(aliasName);
		result.setFunctionName(functionName);
		addImpl(result);
		return this;
	}

}
