/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.log;

import org.apache.commons.logging.Log;
import org.asyrinx.brownie.core.util.Wrapper;

/**
 * <b>Tv</b>
 * LogC^tF[X̃bp[NXłB
 * <br>
 * 
 * @author Akima
 */
public class LogWrapper extends Wrapper implements Log {

	/**
	 * Constructor for LogWrapper.
	 */
	public LogWrapper(Log impl) {
		super(impl);
		this.impl = impl;
	}

	protected final Log impl;

	/**
	 * @see org.apache.commons.logging.Log#isDebugEnabled()
	 */
	public boolean isDebugEnabled() {
		return impl.isDebugEnabled();
	}

	/**
	 * @see org.apache.commons.logging.Log#isErrorEnabled()
	 */
	public boolean isErrorEnabled() {
		return impl.isErrorEnabled();
	}

	/**
	 * @see org.apache.commons.logging.Log#isFatalEnabled()
	 */
	public boolean isFatalEnabled() {
		return impl.isFatalEnabled();
	}

	/**
	 * @see org.apache.commons.logging.Log#isInfoEnabled()
	 */
	public boolean isInfoEnabled() {
		return impl.isInfoEnabled();
	}

	/**
	 * @see org.apache.commons.logging.Log#isTraceEnabled()
	 */
	public boolean isTraceEnabled() {
		return impl.isTraceEnabled();
	}

	/**
	 * @see org.apache.commons.logging.Log#isWarnEnabled()
	 */
	public boolean isWarnEnabled() {
		return impl.isWarnEnabled();
	}

	/**
	 * @see org.asyrinx.log.Logger#log(LogLevel, Object)
	 */
	public void log(LogLevel level, Object message) {
		this.log(level, message, null);
	}

	/**
	 * @see org.asyrinx.log.Logger#log(LogLevel, Object, Throwable)
	 */
	public void log(LogLevel level, Object message, Throwable t) {
		if (impl == null)
			return;
		if (level == null)
			level = LogLevel.DEBUG;
		//
		if (level == LogLevel.FATAL)
			impl.fatal(message, t);
		else if (level == LogLevel.ERROR)
			impl.error(message, t);
		else if (level == LogLevel.WARN)
			impl.warn(message, t);
		else if (level == LogLevel.INFO)
			impl.info(message, t);
		else if (level == LogLevel.DEBUG)
			impl.debug(message, t);
		else if (level == LogLevel.TRACE)
			impl.trace(message, t);
	}

	/**
	 * @see org.apache.commons.logging.Log#trace(Object)
	 */
	public void trace(Object message) {
		impl.trace(message);
	}

	/**
	 * @see org.apache.commons.logging.Log#trace(Object, Throwable)
	 */
	public void trace(Object message, Throwable t) {
		impl.trace(message, t);
	}

	/**
	 * @see org.apache.commons.logging.Log#debug(Object)
	 */
	public void debug(Object message) {
		impl.debug(message);
	}

	/**
	 * @see org.apache.commons.logging.Log#debug(Object, Throwable)
	 */
	public void debug(Object message, Throwable t) {
		impl.debug(message, t);
	}

	/**
	 * @see org.apache.commons.logging.Log#info(Object)
	 */
	public void info(Object message) {
		impl.info(message);
	}

	/**
	 * @see org.apache.commons.logging.Log#info(Object, Throwable)
	 */
	public void info(Object message, Throwable t) {
		impl.info(message, t);
	}

	/**
	 * @see org.apache.commons.logging.Log#warn(Object)
	 */
	public void warn(Object message) {
		impl.warn(message);
	}

	/**
	 * @see org.apache.commons.logging.Log#warn(Object, Throwable)
	 */
	public void warn(Object message, Throwable t) {
		impl.warn(message, t);
	}

	/**
	 * @see org.apache.commons.logging.Log#error(Object)
	 */
	public void error(Object message) {
		impl.error(message);
	}

	/**
	 * @see org.apache.commons.logging.Log#error(Object, Throwable)
	 */
	public void error(Object message, Throwable t) {
		impl.error(message, t);
	}

	/**
	 * @see org.apache.commons.logging.Log#fatal(Object)
	 */
	public void fatal(Object message) {
		impl.fatal(message);
	}

	/**
	 * @see org.apache.commons.logging.Log#fatal(Object, Throwable)
	 */
	public void fatal(Object message, Throwable t) {
		impl.fatal(message, t);
	}

}
