/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.log;

import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.lang.ClassUtils;

/**
 * @author akima
 */
public class CascadeNamedLog extends DispatchLog {

	/**
	 * @param loggerName
	 */
	public CascadeNamedLog(String loggerName) {
		super(LogFactory.getLog(loggerName));
		this.loggerName = loggerName;
	}

	/**
	 * @param loggerName
	 */
	public CascadeNamedLog(Class class1) {
		this(class1.getName());
	}

	/**
	 * @param log
	 * @param defaultLevel
	 */
	public CascadeNamedLog(String loggerName, String defaultLevel) {
		super(LogFactory.getLog(loggerName), defaultLevel);
		this.loggerName = loggerName;
	}

	/**
	 * @param log
	 * @param defaultLevel
	 */
	public CascadeNamedLog(Class class1, String defaultLevel) {
		this(class1.getName(), defaultLevel);
	}

	private String loggerName;

	/**
	 * @return
	 */
	public String getLoggerName() {
		return loggerName;
	}

	/**
	 * @param string
	 */
	public void setLoggerName(String loggerName) {
		this.loggerName = loggerName;
		super.setLog(LogFactory.getLog(loggerName));
	}

	private static final char DEFAULT_SUB_LOG_NAME_DELIMITER = '.';

	private char subLogNameDelimiter = DEFAULT_SUB_LOG_NAME_DELIMITER;

	/**
	 * @return
	 */
	public char getSubLogNameDelimiter() {
		return subLogNameDelimiter;
	}

	/**
	 * @param c
	 */
	public void setSubLogNameDelimiter(char c) {
		subLogNameDelimiter = c;
	}

	public CascadeNamedLog subLog(String subName) {
		return new CascadeNamedLog(
			this.getLoggerName() + getSubLogNameDelimiter() + subName,
			getDefaultLevel());
	}

	public CascadeNamedLog subLog(Object object) {
		return subLog(object.getClass());
	}

	public CascadeNamedLog subLog(Class class1) {
		return subLogByShortClassName(class1);
	}

	public CascadeNamedLog subLogByShortClassName(Class class1) {
		return subLog(ClassUtils.toShortClassName(class1));
	}

	public CascadeNamedLog subLogByFullClassName(Class class1) {
		return subLog(class1.getName());
	}

}
