/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.commons.lang.ObjectUtils;

/**
 * Ɋւ鑀sNXłB
 * 
 * @author Akima
 */
public final class StringUtils extends org.apache.commons.lang.StringUtils {

	/**
	 * nullłȂ󕶎łȂ肵܂B
	 * 
	 * @param value Ώە
	 * @return nullł󕶎łȂƂtrue 
	 */
	static public boolean isAvailable(String value) {
		return isAvailable(value, false);
	}

	/**
	 * nullłȂ󕶎łȂ肵܂B<P>
	 * trimtruêƂ͔Oɕtrim܂B
	 * 
	 * @param value
	 * @param trim
	 * @return boolean
	 */
	static public boolean isAvailable(String value, boolean trim) {
		if (value == null) {
			return false;
		} else {
			if (trim) {
				value = value.trim();
			}
			return (!value.equals(""));
		}
	}

	/** 
	 * RNVɊi[ꂽw肳ꂽłȂĕԂ܂B
	 * gpj<br>
	 * col: { "AAA", "BBB", "CCC" } <br>
	 * connectStr: " , " <br>
	 * L̏ꍇ߂ĺA"AAA , BBB , CCC" ƂȂB<br>
	 * 
	 * @param col RNV
	 * @param connectStr Ȃ镶
	 * @return Ȃ̕
	 */
	static public String connectString(Collection col, String connectStr) {
		if (col == null)
			return null;
		StringBuffer buf = new StringBuffer("");
		connectString(buf, col, connectStr);
		return buf.toString();
	}

	/** 
	 * RNVɊi[ꂽw肳ꂽłȂ
	 * w肳ꂽobt@ɏo͂܂BB<br>
	 * gpj<br>
	 * col: { "AAA", "BBB", "CCC" } <br>
	 * connectStr: " , " <br>
	 * L̏ꍇ߂ĺA"AAA , BBB , CCC" ƂȂB<br>
	 * 
	 * @param dest o͐obt@
	 * @param col RNV
	 * @param connectStr Ȃ镶
	 * @return Ȃ̕
	 */
	static public void connectString(
		StringBuffer dest,
		Collection col,
		String connectStr) {
		if (col == null)
			return;
		final Iterator ite = col.iterator();
		boolean isFirst = true;
		while (ite.hasNext()) {
			if (!isFirst) {
				dest.append(connectStr);
			} else {
				isFirst = false;
			}
			dest.append(ite.next());
		}
	}

	/** Ƃ݂Ȃׂ̂ */
	static private final String NUMERIC_CHARS = ".-0123456789D|OPQRSTUVWX";

	/**
	 * ̒̐Ƃ݂Ȃ镶(pESp0`9A.-)ȊO폜ĕԂ܂B
	 * 
	 * @param value 
	 * @return ꂽ̕ 
	 */
	static public String deleteNotNumeric(Object value) {
		if (value == null)
			return null;
		final StringBuffer result = new StringBuffer();
		final String str = String.valueOf(value);
		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			if (NUMERIC_CHARS.indexOf(c) > -1) {
				result.append(c);
			}
		}
		return result.toString();
	}

	/** ׂ */
	static private final String NUMBER_CHARS = "0123456789OPQRSTUVWX";

	/**
	 * ǂ𔻒fB
	 * @param c
	 */
	public static boolean isNumeric(char c) {
		return NUMBER_CHARS.indexOf(c) > -1;
	}

	/**
	 * ܂ނǂ𔻒fB
	 * @param string 
	 */
	public static boolean hasNumeric(String string) {
		if (!StringUtils.isAvailable(string))
			return false;
		for (int i = 0; i < string.length(); i++) {
			if (NUMBER_CHARS.indexOf(string.charAt(i)) > -1)
				return true;
		}
		return false;
	}

	/**
	 * ݂̂ō\Ă邩ǂ𔻒fB
	 * @param string 
	 */
	public static boolean isNumericOnly(String string) {
		if (!StringUtils.isAvailable(string))
			return false;
		for (int i = 0; i < string.length(); i++) {
			if (NUMBER_CHARS.indexOf(string.charAt(i)) < 0)
				return false;
		}
		return true;
	}

	/**
	 * ̒̐(pASp0`9)ȊO폜ĕԂ܂B
	 * 
	 * @param value 
	 * @return ꂽ̕
	 */
	static public String deleteNotNumber(String value) {
		if (value == null)
			return null;
		StringBuffer result = new StringBuffer();
		for (int i = 0; i < value.length(); i++) {
			char c = value.charAt(i);
			if (NUMBER_CHARS.indexOf(c) > -1) {
				result.append(c);
			}
		}
		return result.toString();
	}

	/**
	 * StringBuffer̕u܂B
	 * 
	 * @param buffer u镶
	 * @param pattern 
	 * @param newPattern u
	 */
	static public void replace(
		StringBuffer buffer,
		String pattern,
		String newPattern) {
		if (StringUtils.equals(pattern, newPattern))
			return;
		int patternLength = pattern.length();
		int idx = buffer.toString().indexOf(pattern);
		while (idx > -1) {
			buffer.replace(idx, idx + patternLength, newPattern);
			idx = buffer.toString().indexOf(pattern, idx + newPattern.length());
		}
	}

	/**
	 * StringBuffer̕u܂B
	 * 
	 * @param buffer u镶
	 * @param pattern 
	 * @param newPattern u
	 */
	static public void replace(
		StringBuffer buffer,
		char oldChar,
		char newChar) {
		int idx = buffer.toString().indexOf(oldChar);
		String newString = newChar + "";
		while (idx > -1) {
			buffer.replace(idx, idx + 1, newString);
			idx = buffer.toString().indexOf(oldChar, idx + 1);
		}
	}

	/**
	 * source̒patternnewPatternɒu܂B
	 * 
	 * @param source u镶
	 * @param pattern 
	 * @param newPattern u
	 * @return uꂽ
	 */
	static public String replace(
		String source,
		String pattern,
		String newPattern) {
		if (source == null)
			return null;
		StringBuffer result = new StringBuffer(source);
		replace(result, pattern, newPattern);
		return result.toString();
	}

	/**
	 * Ŏw肳ꂽp[^ɂuĕԂ܂B
	 * 
	 * @param source u镶
	 * @param oldChar 
	 * @param newChar u
	 * @return uꂽ
	 */
	static public String replace(String source, char oldChar, char newChar) {
		if (source == null)
			return null;
		StringBuffer result = new StringBuffer(source);
		replace(result, oldChar, newChar);
		return result.toString();
	}

	/**
	 * ϐu郁\bhB
	 * ϐ '%'  '%' ŋ܂ꂽƂĕ\B
	 * 
	 * @param source 
	 * @return String ϐɒuƂ̕
	 */
	static public String replaceBySystemProp(String source) {
		return replaceBySystemProp(source, '%');
	}

	/**
	 * ϐu郁\bhB
	 * 
	 * @param source 
	 * @param delim ؂蕶
	 * @return ϐɒuƂ̕
	 */
	static public String replaceBySystemProp(String source, char delim) {
		return replaceBySystemProp(source, delim, delim);
	}

	/**
	 * ϐu郁\bhB
	 * 
	 * @param source 
	 * @param delimBegin Jn̋؂蕶
	 * @param delimEnd I̋؂蕶
	 * @return ϐɒuƂ̕
	 */
	static public String replaceBySystemProp(
		String source,
		char delimBegin,
		char delimEnd) {
		String key = extractString(source, delimBegin, delimEnd);
		while (key != null) {
			source =
				replace(
					source,
					delimBegin + key + delimEnd,
					System.getProperty(key, ""));
			key = extractString(source, delimBegin, delimEnd);
		}
		return source;
	}

	/**
	 * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏o
	 * 
	* @param source 
	 * @param delim ؂蕶
	 * @return oꂽ
	 */
	static public String extractString(String source, char delim) {
		return extractString(source, delim, delim);
	}

	/**
	 * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏o
	 * 
	* @param source 
	 * @param delimBegin Jn̋؂蕶
	 * @param delimEnd I̋؂蕶
	 * @return oꂽ
	 */
	static public String extractString(
		String source,
		char delimBegin,
		char delimEnd) {
		return extractString(source, delimBegin, delimEnd, 0);
	}

	/**
	 * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏o
	 * 
	 * @param source 
	 * @param delimBegin Jn̋؂蕶
	 * @param delimEnd I̋؂蕶
	 * @param fromIndex Jn镶̈ʒu
	 * @return oꂽ
	 */
	static public String extractString(
		String source,
		char delimBegin,
		char delimEnd,
		int fromIndex) {
		int idxBegin = source.indexOf(delimBegin, fromIndex);
		if (idxBegin < 0)
			return null;
		int idxEnd = source.indexOf(delimEnd, idxBegin + 1);
		if (idxEnd < 0)
			return null;
		return source.substring(idxBegin + 1, idxEnd);
	}

	/**
	 * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏oA
	 * ListɒǉB
	 * 
	 * @param source 
	 * @param dest Xg
	 * @param delim ؂蕶
	 */
	static public void extractStrings(String source, List dest, char delim) {
		extractStrings(source, dest, delim, delim, 0);
	}

	/**
	 * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏oA
	 * ListɒǉB
	 * 
	 * @param source 
	 * @param dest Xg
	 * @param delimBegin Jn̋؂蕶
	 * @param delimEnd I̋؂蕶
	 */
	static public void extractStrings(
		String source,
		List dest,
		char delimBegin,
		char delimEnd) {
		extractStrings(source, dest, delimBegin, delimEnd, 0);
	}

	/**
	 * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏oA
	 * ListɒǉB
	 * 
	 * @param source 
	 * @param dest Xg
	 * @param delimBegin Jn̋؂蕶
	 * @param delimEnd I̋؂蕶
	 * @param fromIndex Jn镶̈ʒu
	 */
	static public void extractStrings(
		String source,
		List dest,
		char delimBegin,
		char delimEnd,
		int fromIndex) {
		int idxBegin = source.indexOf(delimBegin, fromIndex);
		while (idxBegin > -1) {
			int idxEnd = source.indexOf(delimEnd, idxBegin + 1);
			if (idxEnd < 0)
				return;
			dest.add(source.substring(idxBegin + 1, idxEnd));
			idxBegin = source.indexOf(delimBegin, idxEnd + 1);
		}
	}

	/**
	 * kł͂Ȃăk
	 * 萔錾̂ʓ|Ȃ̂Ő錾ĂB
	 */
	static public final String NULL_STRING = "";

	/**
	 * p[^̒lnullȂ΋󕶎ɁAȊO͂̂܂ܕԂ܂B
	 * 
	 * @param value 
	 * @return String u̕
	 */
	static public String nullTrim(Object value) {
		return nullTrim(value, false);
	}

	/**
	 * p[^̒lnullȂ΋󕶎ɁAȊO<BR>
	 * trimtruȅꍇtrimāAtrimfalsȅꍇ͂̂܂ܕԂ܂B
	 * 
	 * @param value 
	 * @return String u̕
	 */
	static public String nullTrim(Object value, boolean trim) {
		if (value == null) {
			return NULL_STRING;
		} else {
			if (trim)
				return value.toString().trim();
			else
				return value.toString();
		}
	}

	/**
	 * z̕nullTrimȂȂ܂B
	 * z񎩑̂null̂Ƃ̓kԂ܂B
	 * 
	 * @param values 񂪊i[ꂽ
	 * @param ȂƂ̕
	 */
	public static String nullTrim(Object[] values) {
		return nullTrim(values, false);
	}

	/**
	 * z̕nullTrimȂȂ܂B<P>
	 * z񎩑̂null̂Ƃ̓kԂ܂B
	 * 
	 * @param values 񂪊i[ꂽ
	 * @param ȂƂ̕
	 */
	public static String nullTrim(Object[] values, boolean trim) {
		if (values == null)
			return NULL_STRING;
		StringBuffer result = new StringBuffer();
		for (int i = 0; i < values.length; i++) {
			result.append(nullTrim(values[i], trim));
		}
		return result.toString();
	}

	/**
	 * String^ǂrB
	 * ǂ炩nullłr\BƂnull̏ꍇtrue
	 * 
	 * @param target1 
	 * @param target2 
	 * @return boolean ǂB
	 */
	public static boolean compare(String target1, String target2) {
		return ObjectUtils.equals(target1, target2);
	}

	/**
	 * w肳ꂽ؂蕶ɂĕĕԂ܂B
	 * 
	 * @param value 
	 * @param delimiters ؂蕶
	 * @return ؂ꂽ񂪊i[ꂽList
	 */
	static public List parseToList(String value, String delimiters) {
		List result = new Vector();
		StringTokenizer tokenizer =
			new StringTokenizer(value, delimiters, false);
		while (tokenizer.hasMoreTokens()) {
			result.add(tokenizer.nextToken());
		}
		return result;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param dest DOCUMENT ME!
	 * @param str DOCUMENT ME!
	 * @param delim DOCUMENT ME!
	 */
	public static void tokenize(List dest, String str, String delim) {
		if (dest == null)
			return;
		if (StringUtils.isEmpty(str))
			return;
		final StringBuffer buf = new StringBuffer(str);
		//
		int idx = buf.indexOf(delim);
		if (idx < 0) {
			dest.add(str);
			return;
		}
		while (idx > -1) {
			dest.add(buf.substring(0, idx));
			buf.delete(0, idx + delim.length());
			idx = buf.toString().indexOf(delim);
		}
		if (buf != null) {
			dest.add(buf.toString());
		}
	}

	/**
	 * Method tokenize.
	 * @param str
	 * @param delim
	 * @return Object[]
	 */
	public static String[] tokenizeToArray(String str, String delim) {
		if (str == null)
			return null;
		ArrayList resultList = new ArrayList();
		tokenize(resultList, str, delim);
		if (resultList.size() < 1)
			return new String[0];
		String[] result = new String[resultList.size()];
		for (int i = 0; i < resultList.size(); i++)
			result[i] = (String) resultList.get(i);
		return result;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param dest DOCUMENT ME!
	 * @param str DOCUMENT ME!
	 * @param delim DOCUMENT ME!
	 */
	public static List tokenize(String str, String delim) {
		final List result = new ArrayList();
		tokenize(result, str, delim);
		return result;
	}

	/**
	 * source̕z̒Ɉvalueŕ\镶݂ꍇA
	 * CfbNXԂ܂B݂Ȃꍇɂ -1 Ԃ܂B
	 */
	static public int indexOf(char[] source, char value) {
		if (source == null)
			return -1;
		for (int i = 0; i < source.length; i++) {
			if (source[i] == value)
				return i;
		}
		return -1;
	}

	/**
	 * schars̒̂ǂꂩł܂łtrueԂ܂B
	 * ǂ܂łȂƂɂfalseԂ܂B
	 */
	static public boolean containAnyChar(String s, char[] chars) {
		if (s == null)
			return false;
		if (chars == null)
			return false;
		for (int i = 0; i < chars.length; i++) {
			int idx = s.indexOf(chars[i]);
			if (idx > -1)
				return true;
		}
		return false;
	}

	static public final char QUOTE_SINGLE = '\'';
	static public final char QUOTE_DOUBLE = '"';
	static public final char QUOTE_SINGLE_ZENKAKU_BEGIN = 'e';
	static public final char QUOTE_SINGLE_ZENKAKU_END = 'f';
	static public final char QUOTE_DOUBLE_ZENKAKU_BEGIN = 'g';
	static public final char QUOTE_DOUBLE_ZENKAKU_END = 'h';

	static public final char[] QUOTE_SINGLES =
		new char[] {
			QUOTE_SINGLE,
			QUOTE_SINGLE_ZENKAKU_BEGIN,
			QUOTE_SINGLE_ZENKAKU_END };

	static public final char[] QUOTE_DOUBLES =
		new char[] {
			QUOTE_DOUBLE,
			QUOTE_DOUBLE_ZENKAKU_BEGIN,
			QUOTE_DOUBLE_ZENKAKU_END };

	/**
	 * 񒆂Ɉp݂ꍇɈpd܂B<br>
	 * example:<br>
	 *   quotes == {'\'', 'e', 'f'} (pASp(n)ASp(I)̃VONI[e[V) ̏ꍇ<br>
	 *   [nullTrim == false] (null) -> (null)   //nullϊΏۊOƂ܂B<br>
	 *   [nullTrim == true]  (null) -> ""   //null̓kƓlɕϊ܂B<br>
	 *   "" -> ""   //k͕ϊΏۂłB<br>
	 *   "aaaa" -> "aaaa"     //Oquotet܂B<br>
	 *   "aa'aa"  -> "aa''aa" //OquotetA񒆂quoteQɂȂ܂B<br>
	 *   "aa\"aa"  -> "aa\"aa"  //_uNI[g͂̕ƂĈ܂B<br>
	 *   "aa'\"aa"  -> "aa''\"aa"  //_uNI[g͂̕ƂĈA<br>
	 *   "aa''a'a"  -> "aa''''a''a" //quote݂ĂSĕϊ܂B<br>
	 *   "aa'faea"  -> "aa''ffaeea" //quotew肳ĂĂAꂼɓd܂B<br>
	 */
	static public String duplicateQuote(
		String value,
		char[] quotes,
		boolean nullTrim) {
		if (nullTrim)
			value = nullTrim(value);
		if (value == null)
			return null;
		if (!containAnyChar(value, quotes))
			return value;
		StringBuffer result = new StringBuffer();
		for (int i = 0; i < value.length(); i++) {
			char c = value.charAt(i);
			result.append(c);
			if (indexOf(quotes, c) > -1)
				result.append(c);
		}
		return result.toString();
	}

	/**
	 * value̒̈pdĕԂ܂BSQL̂߂Ɏgp܂B<P>
	 * quotesɂ͈ȉ̂ꂩw肵ĉB<BR>
	 * QUOTE_SINGLESFpESp̃VONH[e[V<BR>
	 * QUOTE_DOUBLESFpESp̃_uNH[e[V<br>
	 * @param value
	 * @param quotes
	 * @return String
	 */
	static public String duplicateQuote(String value, char[] quotes) {
		return duplicateQuote(value, quotes, true);
	}

	/**
	 * 񒆂Ɉp݂ꍇɈpd܂B
	 * 
	 * example:
	 *   quote == '\''(p̃VONI[e[V) ̏ꍇ
	 *   [nullTrim == false] (null) -> (null)   //nullϊΏۊOƂ܂B
	 *   [nullTrim == true]  (null) -> ""   //null̓kƓlɕϊ܂B
	 *   "" -> ""   //k͕ϊΏۂłB
	 *   "aaaa" -> "aaaa"     //Oquotet܂B
	 *   "aa'aa"  -> "aa''aa" //OquotetA񒆂quoteQɂȂ܂B
	 *   "aa\"aa"  -> "aa\"aa"  //_uNI[g͂̕ƂĈ܂B
	 *   "aa'\"aa"  -> "aa''\"aa"  //_uNI[g͂̕ƂĈA
	 *   "aa''a'a"  -> "aa''''a''a" //quote݂ĂSĕϊ܂B
	 * 
	 */
	static public String duplicateQuote(
		String value,
		char quote,
		boolean nullTrim) {
		return duplicateQuote(value, new char[] { quote }, nullTrim);
	}

	static public String duplicateQuote(String value, char quote) {
		return duplicateQuote(value, quote, true);
	}

	/**
	 * 񒆂Ɉp݂ꍇɈpd܂B<br>
	 * example:<br>
	 *   quote == '\'' ̏ꍇ<br>
	 *   [nullTrim == false] (null) -> (null)   //nullϊΏۊOƂ܂B<br>
	 *   [nullTrim == true]  (null) -> ""   //null̓kƓlɕϊ܂B<br>
	 *   "" -> ""   //k͕ϊΏۂłB<br>
	 *   "aaaa" -> "'aaaa'"     //Oquotet܂B<br>
	 *   "aa'aa"  -> "'aa''aa'" //OquotetA񒆂quoteQɂȂ܂B<br>
	 *   "aa\"aa"  -> "'aa\"aa'"  //_uNI[g͂̕ƂĈ܂B<br>
	 *   "aa'\"aa"  -> "'aa''\"aa'"  //_uNI[g͂̕ƂĈA<br>
	 *   "aa''a'a"  -> "'aa''''a''a'" //quote݂ĂSĕϊ܂B<br>
	 */
	static public String toQuoted(String value, char quote, boolean nullTrim) {
		String result = duplicateQuote(value, quote, nullTrim);
		if (!nullTrim && (result == null))
			return null;
		else
			return addQuote(result, quote);
	}

	/**
	 * ɈquoteŎw肳ꂽpOɕt܂B<br>
	 * A񒆂Ɉp݂ꍇɂ͈pd܂B<br>
	 * 
	 * ڂ͈ȉ̃\bhQƂĂB<br>
	 * @see toQuoted(String value, char quote, boolean nullTrim)
	 */
	static public String toQuoted(String value, char quote) {
		return toQuoted(value, quote, true);
	}

	static private String addQuote(String value, char quote) {
		return quote + nullTrim(value) + quote;
	}

	/**
	 * ̑OɎw肳ꂽw肳ꂽoCg܂ŋl߂܂B<br>
	 * (w肳ꂽoCg-̃oCg)l߂镶̃oCgŊ؂邱ƂOłB<br>
	 * ̃oCgw肳ꂽoCgȏ̏ꍇ͂̂܂ܕԂ܂B<br>
	 * @param value Ƃ̕
	 * @param pad l߂镶
	 * @param length w肳ꂽoCg
	 * @return l߂Ԃ̕
	 */
	public static String padHead(String value, String pad, int length) {

		if (value.getBytes().length >= length) {
			return value;
		}

		int addNum = (length - value.getBytes().length) / pad.getBytes().length;

		StringBuffer buffer = new StringBuffer(value);

		for (int index = 0; index < addNum; index++) {
			buffer.insert(0, pad);
		}
		return buffer.toString();
	}

	/**
	 * ̌Ɏw肳ꂽw肳ꂽoCg܂ŋl߂܂B<br>
	 * (w肳ꂽoCg-̃oCg)l߂镶̃oCgŊ؂邱ƂOłB<br>
	 * ̃oCgw肳ꂽoCgȏ̏ꍇ͂̂܂ܕԂ܂B<br>
	 * @param value Ƃ̕
	 * @param pad l߂镶
	 * @param length w肳ꂽoCg
	 * @return l߂Ԃ̕
	 */
	public static String padTail(String value, String pad, int length) {

		if (value.getBytes().length >= length) {
			return value;
		}

		int addNum = (length - value.getBytes().length) / pad.getBytes().length;

		StringBuffer buffer = new StringBuffer(value);

		for (int index = 0; index < addNum; index++) {
			buffer.append(pad);
		}
		return buffer.toString();
	}

}