/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.lang;

import org.apache.commons.beanutils.PropertyUtils;

/**
 * @author Akima
 */
public final class ObjectUtils extends org.apache.commons.lang.ObjectUtils {

	/**
	 * ƂnullȂfalse
	 * ƂnullȊOȂfalse
	 * ǂ炩nullȂtrue
	 */
	static public boolean eitherIsNull(Object obj1, Object obj2) {
		if ((obj1 == null) && (obj2 == null))
			return false;
		if ((obj1 != null) && (obj2 != null))
			return false;
		return true;
	}

	/**
	 * PropertyUtilsNX(reflection)gpăvpeB
	 * \擾܂B
	 */
	public static String describeProperties(Object bean) {
		if (bean == null)
			return "";
		try {
			return String.valueOf(PropertyUtils.describe(bean));
		} catch (Exception e) {
			return "";
		}
	}

	/**
	 * PropertyUtilsNX(reflection)gpăvpeB
	 * \܂ށAIuWFNg̏𕶎ƂĎ擾܂B
	 */
	public static String toString(Object bean) {
		if (bean == null)
			return "";
		StringBuffer result = new StringBuffer();
		result.append(bean.getClass().getName());
		result.append("@");
		result.append(bean.hashCode());
		result.append(" ");
		try {
			result.append(String.valueOf(PropertyUtils.describe(bean)));
		} catch (Exception e) {
		}
		return result.toString();
	}
}
