/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.asyrinx.brownie.core.io.FileNameUtils;

/**
 * @author Akima
 */
public class DirectoryBaseFileStreamFactory extends AbstractFileStreamFactory {

	/**
	 * Constructor for DirectoryBaseFileStreamFactory.
	 */
	public DirectoryBaseFileStreamFactory(String baseDirectory) {
		super();
		this.baseDirectory = baseDirectory;
	}

	private final String baseDirectory;

	/**
	 * @see org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory#toFilePath(java.lang.String)
	 */
	public String toFilePath(String virtualFileName) {
		virtualFileName = FileNameUtils.replaceSeparatorSlash(virtualFileName);
		return FileNameUtils.toAbsolutePath(baseDirectory, virtualFileName);
	}

	/**
	 */
	public InputStream newInput(String fileName) throws IOException {
		return new FileInputStream(toFilePath(fileName));
	}

	/**
	 */
	public OutputStream newOutput(String fileName) throws IOException {
		return new FileOutputStream(toFilePath(fileName));
	}

	/**
	 * Returns the baseDirectory.
	 * @return String
	 */
	public String getBaseDirectory() {
		return baseDirectory;
	}

}
