/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package test.org.asyrinx.brownie.core.util.jp;

import java.text.DateFormat;
import java.text.ParseException;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.util.SimpleDate;
import org.asyrinx.brownie.core.util.jp.JpDateFormat;

/**
 * @author akima
 */
public class JpDateFormatTest extends TestCase {

	/**
	 * Constructor for JpDateFormatTest.
	 * @param name
	 */
	public JpDateFormatTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(JpDateFormatTest.class);
	}

	final DateFormat format0 = new JpDateFormat("yyyy/MM/dd");
	final DateFormat format1 = new JpDateFormat("jejyy/MM/dd");
	final DateFormat format2 = new JpDateFormat("jEjyyNMMdd");
	final DateFormat format3 = new JpDateFormat("jEEjyyNMMdd");

	private void checkFormatAndParse(
		String result,
		int y,
		int m,
		int d,
		DateFormat format) {
		assertEquals(
			result,
			format.format(new SimpleDate(y, m, d).toDateBegin()));
		try {
			assertEquals(
				new SimpleDate(y, m, d),
				new SimpleDate(format.parse(result)));
		} catch (ParseException e) {
			fail(e.getMessage());
		}
	}

	/*
	 * Test for StringBuffer format(Date, StringBuffer, FieldPosition)
	 */
	public void testFormatDateStringBufferFieldPosition() {
		checkFormatAndParse("2003/08/09", 2003, 8, 9, format0);
		checkFormatAndParse("H15/08/09", 2003, 8, 9, format1);
		checkFormatAndParse("15N1228", 2003, 12, 28, format2);
		checkFormatAndParse("吳1N0906", 1912, 9, 6, format3);
		//checkFormatAndParse("\ܔN\񌎓\", 2003, 11, 28, format3);
	}

}
