/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/15
 */
package test.org.asyrinx.brownie.core.io.sf.a.b;

import java.io.IOException;
import java.io.InputStream;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.io.TextFile;
import org.asyrinx.brownie.core.io.sf.RelativeClassResourceStreamFactory;

/**
 * @author akima
 */
public class RelativeClassResourceFileStreamFactoryTest_B extends TestCase {

	/**
	 * Constructor for RelativeClassResourceFileStreamFactoryTest_B.
	 * @param name
	 */
	public RelativeClassResourceFileStreamFactoryTest_B(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(
			RelativeClassResourceFileStreamFactoryTest_B.class);
	}

	/*
	 * Test for InputStream newInput(String)
	 */
	public void testNewInputString() {
		final RelativeClassResourceStreamFactory factory =
			new RelativeClassResourceStreamFactory();
		try {
			final TextFile textFile =
				new TextFile("../../ClassResourceStreamFactoryTest_01.txt");
			final InputStream inputStream = factory.newInput(textFile);
			textFile.load(inputStream);
			assertEquals("0123456789", textFile.getText());
		} catch (IOException e) {
			e.printStackTrace();
			fail();
		}
		try {
			final TextFile textFile =
				new TextFile("ClassResourceStreamFactoryTest_b.txt");
			final InputStream inputStream = factory.newInput(textFile);
			textFile.load(inputStream);
			assertEquals("org/asyrinx/io/sf/test/a/b", textFile.getText());
		} catch (IOException e) {
			e.printStackTrace();
			fail();
		}
		try {
			final TextFile textFile =
				new TextFile("../c/ClassResourceStreamFactoryTest_c.txt");
			final InputStream inputStream = factory.newInput(textFile);
			textFile.load(inputStream);
			assertEquals("org/asyrinx/io/sf/test/a/c", textFile.getText());
		} catch (IOException e) {
			e.printStackTrace();
			fail();
		}
	}

}
