/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/17 18:49:10
 */
package org.asyrinx.brownie.tapestry.util;

import java.util.Iterator;
import java.util.Map;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author takeshi
 */
public class BindingUtils {

    public static void renderInformalParametersFilteredTail(IComponent component, IMarkupWriter writer,
            IRequestCycle cycle, String tail) {
        if (component.getBindings() == null)
            return;
        final Iterator i = component.getBindings().entrySet().iterator();
        while (i.hasNext()) {
            final Map.Entry entry = (Map.Entry) i.next();
            final String name = (String) entry.getKey();
            if (!name.endsWith(tail))
                continue;
            final IBinding binding = (IBinding) entry.getValue();
            final Object value = binding.getObject();
            if (value == null)
                continue;
            final String attribute;
            if (value instanceof IAsset) {
                IAsset asset = (IAsset) value;
                attribute = asset.buildURL(cycle);
            } else
                attribute = value.toString();
            writer.attribute(StringUtils.left(name, name.length() - tail.length()), attribute);
        }
    }

    public static void renderInformalParameters(IComponent component, IMarkupWriter writer, IRequestCycle cycle) {
        if (component.getBindings() == null)
            return;
        final Iterator i = component.getBindings().entrySet().iterator();
        while (i.hasNext()) {
            final Map.Entry entry = (Map.Entry) i.next();
            final String name = (String) entry.getKey();
            final IBinding binding = (IBinding) entry.getValue();
            final Object value = binding.getObject();
            if (value == null)
                continue;
            final String attribute;
            if (value instanceof IAsset) {
                IAsset asset = (IAsset) value;
                attribute = asset.buildURL(cycle);
            } else
                attribute = value.toString();
            writer.attribute(name, attribute);
        }
    }

}